/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input.sparse;

import edu.uci.jforests.input.sparse.SparseTextFileLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class SparseTextFileReader {
    static final Pattern SPLIT_COLON = Pattern.compile(":");
    BufferedReader reader;

    public void open(String filename) {
        try {
            this.reader = filename.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)))) : new BufferedReader(new FileReader(new File(filename)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean loadNextLine(SparseTextFileLine line) {
        try {
            String str;
            do {
                if ((str = this.reader.readLine()) == null) {
                    return false;
                }
                int commentIdx = (str = str.trim()).indexOf(35);
                if (commentIdx < 0) continue;
                str = str.substring(0, commentIdx).trim();
            } while (str.length() == 0);
            if (str.startsWith("@")) {
                line.meta = true;
                line.content = str;
            } else {
                line.meta = false;
                line.content = null;
                StringTokenizer st = new StringTokenizer(str, " ");
                line.target = Integer.parseInt(st.nextToken());
                line.numPairs = 0;
                while (st.hasMoreTokens()) {
                    String[] parts = SPLIT_COLON.split(st.nextToken(), 2);
                    if (parts[0].equals("qid")) {
                        line.qid = parts[1];
                        continue;
                    }
                    line.ensureCapacity(line.numPairs + 1);
                    line.pairs[line.numPairs].featureIndex = Integer.parseInt(parts[0]);
                    line.pairs[line.numPairs].featureValue = Double.parseDouble(parts[1]);
                    ++line.numPairs;
                }
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

