/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.config;

import edu.uci.jforests.config.TrainingConfig;
import edu.uci.jforests.util.ConfigHolder;
import java.util.Map;

public class RankingTrainingConfig
extends TrainingConfig {
    public String trainQidsFilename = null;
    private static final String TRAIN_QIDS_FILENAME = "input.train.qids-filename";
    public int validNDCGTruncation = 3;
    private static final String VALID_NDCG_TRUNCATION = "ranking.valid-ndcg-truncation";
    public boolean augmentationDocSamplingEnabled = false;
    private static final String RANKING_AUGMENTATION_DOCSAMPLING_ENABLED = "ranking.augmentation.doc-sampling-enabled";
    public int augmentationDocSamplingTimes = 3;
    private static final String RANKING_AUGMENTATION_DOCSAMPLING_TIMES = "ranking.augmentation.doc-sampling-times";
    public double augmentationDocSamplingRate = 0.5;
    private static final String RANKING_AUGMENTATION_DOCSAMPLING_RATE = "ranking.augmentation.doc-sampling-rate";

    @Override
    public void init(ConfigHolder config) {
        super.init(config);
        for (Map.Entry<Object, Object> entry : config.getEntries()) {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = (String)entry.getValue();
            if (key.equals(TRAIN_QIDS_FILENAME)) {
                this.trainQidsFilename = value;
                continue;
            }
            if (key.equals(VALID_NDCG_TRUNCATION)) {
                this.validNDCGTruncation = Integer.parseInt(value);
                continue;
            }
            if (key.equals(RANKING_AUGMENTATION_DOCSAMPLING_ENABLED)) {
                this.augmentationDocSamplingEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equals(RANKING_AUGMENTATION_DOCSAMPLING_TIMES)) {
                this.augmentationDocSamplingTimes = Integer.parseInt(value);
                continue;
            }
            if (!key.equals(RANKING_AUGMENTATION_DOCSAMPLING_RATE)) continue;
            this.augmentationDocSamplingRate = Double.parseDouble(value);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString() + "\n");
        sb.append("ranking.valid-ndcg-truncation: " + this.validNDCGTruncation + "\n");
        sb.append("ranking.augmentation.doc-sampling-enabled: " + this.augmentationDocSamplingEnabled + "\n");
        sb.append("ranking.augmentation.doc-sampling-times: " + this.augmentationDocSamplingTimes + "\n");
        sb.append("ranking.augmentation.doc-sampling-rate: " + this.augmentationDocSamplingRate + "\n");
        return sb.toString();
    }
}

