/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.applications;

import edu.uci.jforests.applications.ClassificationApp;
import edu.uci.jforests.applications.RankingApp;
import edu.uci.jforests.dataset.Dataset;
import edu.uci.jforests.dataset.DatasetLoader;
import edu.uci.jforests.dataset.RankingDataset;
import edu.uci.jforests.dataset.RankingDatasetLoader;
import edu.uci.jforests.input.RankingRaw2BinConvertor;
import edu.uci.jforests.input.Raw2BinConvertor;
import edu.uci.jforests.learning.LearningUtils;
import edu.uci.jforests.learning.trees.Ensemble;
import edu.uci.jforests.learning.trees.decision.DecisionTree;
import edu.uci.jforests.learning.trees.regression.RegressionTree;
import edu.uci.jforests.sample.RankingSample;
import edu.uci.jforests.sample.Sample;
import edu.uci.jforests.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class Runner {
    private static void generateBin(OptionSet options) throws Exception {
        if (!options.has("folder")) {
            System.err.println("The input folder is not specified.");
            return;
        }
        if (!options.has("file")) {
            System.err.println("Input files are not specified.");
            return;
        }
        String folder = (String)options.valueOf("folder");
        List<?> filesList = options.valuesOf("file");
        String[] files = new String[filesList.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = (String)filesList.get(i);
        }
        if (options.has("ranking")) {
            System.out.println("Generating binary files for ranking data sets...");
            new RankingRaw2BinConvertor().convert(folder, files);
        } else {
            System.out.println("Generating binary files...");
            new Raw2BinConvertor().convert(folder, files);
        }
    }

    private static void train(OptionSet options) throws Exception {
        Ensemble ensemble;
        ClassificationApp app;
        if (!options.has("config-file")) {
            System.err.println("The configurations file is not specified.");
            return;
        }
        FileInputStream configInputStream = new FileInputStream((String)options.valueOf("config-file"));
        Properties configProperties = new Properties();
        configProperties.load(configInputStream);
        if (options.has("train-file")) {
            configProperties.put("input.train", options.valueOf("train-file"));
        }
        if (options.has("validation-file")) {
            configProperties.put("input.valid", options.valueOf("validation-file"));
        }
        if (options.has("ranking")) {
            app = new RankingApp();
            ensemble = app.run(configProperties);
        } else {
            app = new ClassificationApp();
            ensemble = app.run(configProperties);
        }
        if (options.has("output-model")) {
            String outputModelFile = (String)options.valueOf("output-model");
            File file = new File(outputModelFile);
            PrintStream ensembleOutput = new PrintStream(file);
            ensembleOutput.println(ensemble);
            ensembleOutput.close();
        }
    }

    private static void predict(OptionSet options) throws Exception {
        Sample sample;
        Dataset dataset;
        if (!options.has("model-file")) {
            System.err.println("Model file is not specified.");
            return;
        }
        if (!options.has("tree-type")) {
            System.err.println("Types of trees in the ensemble is not specified.");
            return;
        }
        if (!options.has("test-file")) {
            System.err.println("Test file is not specified.");
            return;
        }
        File modelFile = new File((String)options.valueOf("model-file"));
        Ensemble ensemble = new Ensemble();
        if (options.valueOf("tree-type").equals("RegressionTree")) {
            ensemble.loadFromFile(RegressionTree.class, modelFile);
        } else if (options.valueOf("tree-type").equals("DecisionTree")) {
            ensemble.loadFromFile(DecisionTree.class, modelFile);
        } else {
            System.err.println("Unknown tree type: " + options.valueOf("tree-type"));
        }
        InputStream in = new IOUtils().getInputStream((String)options.valueOf("test-file"));
        if (options.has("ranking")) {
            dataset = new RankingDataset();
            RankingDatasetLoader.load(in, dataset);
            sample = new RankingSample((RankingDataset)dataset);
        } else {
            dataset = new Dataset();
            DatasetLoader.load(in, dataset);
            sample = new Sample(dataset);
        }
        in.close();
        long startms = System.currentTimeMillis();
        double[] predictions = new double[sample.size];
        LearningUtils.updateScores(sample, predictions, ensemble);
        long stopms = System.currentTimeMillis();
        System.err.println(sample.size + " predictions in " + (stopms - startms) + " ms");
        PrintStream output = options.has("output-file") ? new PrintStream(new File((String)options.valueOf("output-file"))) : System.out;
        for (int i = 0; i < sample.size; ++i) {
            output.println(predictions[i]);
        }
    }

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.accepts("cmd").withRequiredArg();
        parser.accepts("ranking");
        parser.accepts("folder").withRequiredArg();
        parser.accepts("file").withRequiredArg();
        parser.accepts("config-file").withRequiredArg();
        parser.accepts("train-file").withRequiredArg();
        parser.accepts("validation-file").withRequiredArg();
        parser.accepts("output-model").withRequiredArg();
        parser.accepts("model-file").withRequiredArg();
        parser.accepts("tree-type").withRequiredArg();
        parser.accepts("test-file").withRequiredArg();
        parser.accepts("output-file").withRequiredArg();
        OptionSet options = parser.parse(args);
        if (!options.has("cmd")) {
            System.err.println("You must specify the command through 'cmd' parameter.");
            return;
        }
        if (options.valueOf("cmd").equals("generate-bin")) {
            Runner.generateBin(options);
        } else if (options.valueOf("cmd").equals("train")) {
            Runner.train(options);
        } else if (options.valueOf("cmd").equals("predict")) {
            Runner.predict(options);
        } else {
            System.err.println("Unknown command: " + options.valueOf("cmd"));
        }
        ClassificationApp.shutdown();
    }
}

