/*
 * Decompiled with CFR 0.152.
 */
package dt;

import dt.Algorithm;
import dt.Attribute;
import dt.BadDecisionException;
import dt.Examples;
import dt.ID3Algorithm;
import dt.UnknownDecisionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DecisionTree {
    private LinkedHashSet<String> attributes;
    private Map<String, Set<String>> decisions;
    private boolean decisionsSpecified = false;
    private Examples examples = new Examples();
    private boolean compiled;
    private Attribute rootAttribute;
    private Algorithm algorithm = null;

    public DecisionTree() {
        this.attributes = new LinkedHashSet();
        this.decisions = new HashMap<String, Set<String>>();
    }

    private void setDefaultAlgorithm() {
        if (this.algorithm == null) {
            this.setAlgorithm(new ID3Algorithm(this.examples));
        }
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DecisionTree setAttributes(String[] attributeNames) {
        this.compiled = false;
        this.decisions.clear();
        this.decisionsSpecified = false;
        this.attributes.clear();
        for (int i = 0; i < attributeNames.length; ++i) {
            this.attributes.add(attributeNames[i]);
        }
        return this;
    }

    public DecisionTree setDecisions(String attributeName, String[] decisions) {
        if (!this.attributes.contains(attributeName)) {
            return this;
        }
        this.compiled = false;
        this.decisionsSpecified = true;
        HashSet<String> decisionsSet = new HashSet<String>();
        for (int i = 0; i < decisions.length; ++i) {
            decisionsSet.add(decisions[i]);
        }
        this.decisions.put(attributeName, decisionsSet);
        return this;
    }

    public DecisionTree addExample(String[] attributeValues, boolean classification) throws UnknownDecisionException {
        String[] attributes = this.attributes.toArray(new String[0]);
        if (this.decisionsSpecified) {
            for (int i = 0; i < attributeValues.length; ++i) {
                if (this.decisions.get(attributes[i]).contains(attributeValues[i])) continue;
                throw new UnknownDecisionException(attributes[i], attributeValues[i]);
            }
        }
        this.compiled = false;
        this.examples.add(attributes, attributeValues, classification);
        return this;
    }

    public DecisionTree addExample(Map<String, String> attributes, boolean classification) throws UnknownDecisionException {
        this.compiled = false;
        this.examples.add(attributes, classification);
        return this;
    }

    public boolean apply(Map<String, String> data) throws BadDecisionException {
        this.compile();
        return this.rootAttribute.apply(data);
    }

    private Attribute compileWalk(Attribute current, Map<String, String> chosenAttributes, Set<String> usedAttributes) {
        if (current.isLeaf()) {
            return current;
        }
        String attributeName = current.getName();
        usedAttributes.add(attributeName);
        for (String decisionName : this.decisions.get(attributeName)) {
            chosenAttributes.put(attributeName, decisionName);
            current.addDecision(decisionName, this.compileWalk(this.algorithm.nextAttribute(chosenAttributes, usedAttributes), chosenAttributes, usedAttributes));
        }
        chosenAttributes.remove(attributeName);
        return current;
    }

    public void compile() {
        if (this.compiled) {
            return;
        }
        this.setDefaultAlgorithm();
        HashMap<String, String> chosenAttributes = new HashMap<String, String>();
        HashSet<String> usedAttributes = new HashSet<String>();
        if (!this.decisionsSpecified) {
            this.decisions = this.examples.extractDecisions();
        }
        this.rootAttribute = this.compileWalk(this.algorithm.nextAttribute(chosenAttributes, usedAttributes), chosenAttributes, usedAttributes);
        this.compiled = true;
    }

    public String toString() {
        this.compile();
        if (this.rootAttribute != null) {
            return this.rootAttribute.toString();
        }
        return "";
    }

    public Attribute getRoot() {
        return this.rootAttribute;
    }
}

