/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.gp.symbolic.interpreter;

import com.lagodiuk.gp.symbolic.interpreter.Context;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Function;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class SyntaxTreeUtils {
    public static Expression createTree(int depth, Context context) {
        if (depth > 0) {
            int i;
            Function f = FastMath.random() >= 0.5 ? context.getRandomNonTerminalFunction() : context.getRandomTerminalFunction();
            Expression expr = new Expression(f);
            if (f.argumentsCount() > 0) {
                for (i = 0; i < f.argumentsCount(); ++i) {
                    Expression child = SyntaxTreeUtils.createTree(depth - 1, context);
                    expr.addChild(child);
                }
            } else if (f.isVariable()) {
                String varName = context.getRandomVariableName();
                expr.setVariable(varName);
            }
            for (i = 0; i < f.coefficientsCount(); ++i) {
                expr.addCoefficient(context.getRandomValue());
            }
            return expr;
        }
        Function f = context.getRandomTerminalFunction();
        Expression expr = new Expression(f);
        if (f.isVariable()) {
            String varName = context.getRandomVariableName();
            expr.setVariable(varName);
        }
        for (int i = 0; i < f.coefficientsCount(); ++i) {
            expr.addCoefficient(context.getRandomValue());
        }
        return expr;
    }

    public static void simplifyTree(Expression tree, Context context) {
        if (SyntaxTreeUtils.hasVariableNode(tree)) {
            for (Expression child : tree.getChilds()) {
                SyntaxTreeUtils.simplifyTree(child, context);
            }
        } else {
            double value = tree.eval(context);
            tree.addCoefficient(value);
            tree.removeChilds();
            List<Function> terminalFunctions = context.getTerminalFunctions();
            for (Function f : terminalFunctions) {
                if (!f.isNumber()) continue;
                tree.setFunction(f);
                break;
            }
        }
    }

    public static void cutTree(Expression tree, Context context, int depth) {
        if (depth > 0) {
            for (Expression child : tree.getChilds()) {
                SyntaxTreeUtils.cutTree(child, context, depth - 1);
            }
        } else {
            tree.removeChilds();
            tree.removeCoefficients();
            Function func = context.getRandomTerminalFunction();
            tree.setFunction(func);
            if (func.isVariable()) {
                tree.setVariable(context.getRandomVariableName());
            } else {
                tree.addCoefficient(context.getRandomValue());
            }
        }
    }

    public static boolean hasVariableNode(Expression tree) {
        boolean ret = false;
        if (tree.getFunction().isVariable()) {
            ret = true;
        } else {
            Expression child;
            Iterator<Expression> iterator = tree.getChilds().iterator();
            while (iterator.hasNext() && !(ret = SyntaxTreeUtils.hasVariableNode(child = iterator.next()))) {
            }
        }
        return ret;
    }
}

