/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.gp.symbolic.example;

import com.lagodiuk.gp.symbolic.SymbolicRegressionEngine;
import com.lagodiuk.gp.symbolic.SymbolicRegressionIterationListener;
import com.lagodiuk.gp.symbolic.TabulatedFunctionFitness;
import com.lagodiuk.gp.symbolic.Target;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Functions;
import java.util.LinkedList;
import java.util.List;

public class LauncherXYZ {
    public static void main(String[] args) {
        TabulatedFunctionFitness fitnessFunction = new TabulatedFunctionFitness(new Target().when("x", 26.0).when("y", 35.0).when("z", 1.0).targetIs(830.0), new Target().when("x", 8.0).when("y", 24.0).when("z", -11.0).targetIs(130.0), new Target().when("x", 20.0).when("y", 1.0).when("z", 10.0).targetIs(477.0), new Target().when("x", 33.0).when("y", 11.0).when("z", 2.0).targetIs(1217.0), new Target().when("x", 37.0).when("y", 16.0).when("z", 7.0).targetIs(1524.0));
        SymbolicRegressionEngine engine = new SymbolicRegressionEngine(fitnessFunction, LauncherXYZ.list("x", "y", "z"), LauncherXYZ.list(Functions.ADD, Functions.SUB, Functions.MUL, Functions.VARIABLE, Functions.CONSTANT));
        LauncherXYZ.addListener(engine);
        engine.evolve(200);
        System.out.println(engine.getBestSyntaxTree().print());
    }

    private static void addListener(SymbolicRegressionEngine engine) {
        engine.addIterationListener(new SymbolicRegressionIterationListener(){
            private double prevFitValue = -1.0;

            @Override
            public void update(SymbolicRegressionEngine engine) {
                Expression bestSyntaxTree = engine.getBestSyntaxTree();
                double currFitValue = engine.fitness(bestSyntaxTree);
                if (Double.compare(currFitValue, this.prevFitValue) != 0) {
                    System.out.println("Func = " + bestSyntaxTree.print());
                }
                System.out.println(String.format("%s \t %s", engine.getIteration(), currFitValue));
                this.prevFitValue = currFitValue;
                if (currFitValue < 5.0) {
                    engine.terminate();
                }
            }
        });
    }

    private static <T> List<T> list(T ... items) {
        LinkedList<T> list = new LinkedList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }
}

