/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.ga;

import com.lagodiuk.ga.Chromosome;
import com.lagodiuk.ga.Fitness;
import com.lagodiuk.ga.IterartionListener;
import com.lagodiuk.ga.Population;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class GeneticAlgorithm<C extends Chromosome<C>, T extends Comparable<T>> {
    private static final int ALL_PARENTAL_CHROMOSOMES = Integer.MAX_VALUE;
    private final ChromosomesComparator chromosomesComparator;
    private final Fitness<C, T> fitnessFunc;
    private Population<C> population;
    private final List<IterartionListener<C, T>> iterationListeners = new LinkedList<IterartionListener<C, T>>();
    private boolean terminate = false;
    private int parentChromosomesSurviveCount = Integer.MAX_VALUE;
    private int iteration = 0;

    public GeneticAlgorithm(Population<C> population, Fitness<C, T> fitnessFunc) {
        this.population = population;
        this.fitnessFunc = fitnessFunc;
        this.chromosomesComparator = new ChromosomesComparator();
        this.population.sortPopulationByFitness(this.chromosomesComparator);
    }

    public void evolve() {
        int i;
        int parentPopulationSize = this.population.getSize();
        Population newPopulation = new Population();
        for (i = 0; i < parentPopulationSize && i < this.parentChromosomesSurviveCount; ++i) {
            newPopulation.addChromosome(this.population.getChromosomeByIndex(i));
        }
        for (i = 0; i < parentPopulationSize; ++i) {
            C chromosome = this.population.getChromosomeByIndex(i);
            Object mutated = chromosome.mutate();
            C otherChromosome = this.population.getRandomChromosome();
            List<C> crossovered = chromosome.crossover(otherChromosome);
            newPopulation.addChromosome(mutated);
            for (Chromosome c : crossovered) {
                newPopulation.addChromosome(c);
            }
        }
        newPopulation.sortPopulationByFitness(this.chromosomesComparator);
        newPopulation.trim(parentPopulationSize);
        this.population = newPopulation;
    }

    public void evolve(int count) {
        this.terminate = false;
        for (int i = 0; i < count && !this.terminate; ++i) {
            this.evolve();
            this.iteration = i;
            for (IterartionListener<C, T> l : this.iterationListeners) {
                l.update(this);
            }
        }
    }

    public int getIteration() {
        return this.iteration;
    }

    public void terminate() {
        this.terminate = true;
    }

    public Population<C> getPopulation() {
        return this.population;
    }

    public C getBest() {
        return this.population.getChromosomeByIndex(0);
    }

    public C getWorst() {
        return this.population.getChromosomeByIndex(this.population.getSize() - 1);
    }

    public void setParentChromosomesSurviveCount(int parentChromosomesCount) {
        this.parentChromosomesSurviveCount = parentChromosomesCount;
    }

    public int getParentChromosomesSurviveCount() {
        return this.parentChromosomesSurviveCount;
    }

    public void addIterationListener(IterartionListener<C, T> listener) {
        this.iterationListeners.add(listener);
    }

    public void removeIterationListener(IterartionListener<C, T> listener) {
        this.iterationListeners.remove(listener);
    }

    public T fitness(C chromosome) {
        return this.chromosomesComparator.fit(chromosome);
    }

    public void clearCache() {
        this.chromosomesComparator.clearCache();
    }

    private class ChromosomesComparator
    implements Comparator<C> {
        private final Map<C, T> cache = new WeakHashMap();

        private ChromosomesComparator() {
        }

        @Override
        public int compare(C chr1, C chr2) {
            Object fit1 = this.fit(chr1);
            Object fit2 = this.fit(chr2);
            int ret = fit1.compareTo(fit2);
            return ret;
        }

        public T fit(C chr) {
            Comparable fit = (Comparable)this.cache.get(chr);
            if (fit == null) {
                fit = GeneticAlgorithm.this.fitnessFunc.calculate(chr);
                this.cache.put(chr, fit);
            }
            return fit;
        }

        public void clearCache() {
            this.cache.clear();
        }
    }
}

