/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import org.jdesktop.swingx.AlphaPaintable;
import org.jdesktop.swingx.BackgroundPaintable;
import org.jdesktop.swingx.ScrollableSizeHint;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.util.Contract;
import org.jdesktop.swingx.util.GraphicsUtilities;
import org.jdesktop.swingx.util.JVM;

public class JXPanel
extends JPanel
implements AlphaPaintable,
BackgroundPaintable,
Scrollable {
    private ScrollableSizeHint scrollableWidthHint = ScrollableSizeHint.FIT;
    private ScrollableSizeHint scrollableHeightHint = ScrollableSizeHint.FIT;
    private volatile float alpha = 1.0f;
    private boolean oldOpaque;
    private float oldAlpha = 1.0f;
    private boolean inheritAlpha = true;
    private Painter backgroundPainter;
    private boolean paintBorderInsets = true;
    private PropertyChangeListener painterChangeListener;

    public JXPanel() {
    }

    public JXPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public JXPanel(LayoutManager layout) {
        super(layout);
    }

    public JXPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    @Override
    public void setOpaque(boolean opaque) {
        if (opaque) {
            this.oldAlpha = this.getAlpha();
            if (this.oldAlpha < 1.0f) {
                this.setAlpha(1.0f);
            } else {
                super.setOpaque(true);
                this.repaint();
            }
        } else if (this.getAlpha() == 1.0f) {
            if (this.oldAlpha == 1.0f) {
                super.setOpaque(false);
                this.repaint();
            } else {
                this.setAlpha(this.oldAlpha);
            }
        }
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("invalid alpha value " + alpha);
        }
        float oldValue = this.getAlpha();
        this.alpha = alpha;
        if (this.getAlpha() < 1.0f) {
            if (oldValue == 1.0f) {
                this.oldOpaque = this.isOpaque();
                super.setOpaque(false);
            }
            this.installRepaintManager();
        } else {
            this.uninstallRepaintManager();
            if (this.oldOpaque) {
                super.setOpaque(true);
            }
        }
        this.firePropertyChange("alpha", oldValue, this.getAlpha());
        this.repaint();
    }

    void installRepaintManager() {
        if (!JVM.current().isOrLater(1700)) {
            RepaintManager manager = RepaintManager.currentManager(this);
            RepaintManager trm = SwingXUtilities.getTranslucentRepaintManager(manager);
            RepaintManager.setCurrentManager(trm);
        }
    }

    void uninstallRepaintManager() {
    }

    @Override
    public float getEffectiveAlpha() {
        float a = this.getAlpha();
        if (this.isInheritAlpha()) {
            for (Container c = this.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof AlphaPaintable)) continue;
                a = Math.min(((AlphaPaintable)((Object)c)).getEffectiveAlpha(), a);
                break;
            }
        }
        return a;
    }

    @Override
    public boolean isInheritAlpha() {
        return this.inheritAlpha;
    }

    @Override
    public void setInheritAlpha(boolean val) {
        boolean oldValue = this.isInheritAlpha();
        this.inheritAlpha = val;
        this.firePropertyChange("inheritAlpha", oldValue, this.isInheritAlpha());
    }

    public final void setScrollableWidthHint(ScrollableSizeHint hint) {
        Contract.asNotNull((Object)((Object)hint), (String)"hint cannot be null");
        ScrollableSizeHint oldValue = this.getScrollableWidthHint();
        if (oldValue == hint) {
            return;
        }
        this.scrollableWidthHint = hint;
        this.revalidate();
        this.firePropertyChange("scrollableWidthHint", (Object)oldValue, (Object)this.getScrollableWidthHint());
    }

    public final void setScrollableHeightHint(ScrollableSizeHint hint) {
        Contract.asNotNull((Object)((Object)hint), (String)"hint cannot be null");
        ScrollableSizeHint oldValue = this.getScrollableHeightHint();
        if (oldValue == hint) {
            return;
        }
        this.scrollableHeightHint = hint;
        this.revalidate();
        this.firePropertyChange("scrollableHeightHint", (Object)oldValue, (Object)this.getScrollableHeightHint());
    }

    protected ScrollableSizeHint getScrollableWidthHint() {
        return this.scrollableWidthHint;
    }

    protected ScrollableSizeHint getScrollableHeightHint() {
        return this.scrollableHeightHint;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.scrollableHeightHint.getTracksParentSize(this, 1);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.scrollableWidthHint.getTracksParentSize(this, 0);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        if (orientation == 0) {
            return visibleRect.width;
        }
        throw new IllegalArgumentException("invalid orientation");
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableBlockIncrement(visibleRect, orientation, direction) / 10;
    }

    public void setScrollableTracksViewportHeight(boolean scrollableTracksViewportHeight) {
        this.setScrollableHeightHint(scrollableTracksViewportHeight ? ScrollableSizeHint.FIT : ScrollableSizeHint.NONE);
    }

    public void setScrollableTracksViewportWidth(boolean scrollableTracksViewportWidth) {
        this.setScrollableWidthHint(scrollableTracksViewportWidth ? ScrollableSizeHint.FIT : ScrollableSizeHint.NONE);
    }

    @Override
    public void setBackgroundPainter(Painter p) {
        Painter old = this.getBackgroundPainter();
        if (old instanceof AbstractPainter) {
            ((AbstractPainter)old).removePropertyChangeListener(this.painterChangeListener);
        }
        this.backgroundPainter = p;
        if (this.backgroundPainter instanceof AbstractPainter) {
            ((AbstractPainter)this.backgroundPainter).addPropertyChangeListener(this.getPainterChangeListener());
        }
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    protected PropertyChangeListener getPainterChangeListener() {
        if (this.painterChangeListener == null) {
            this.painterChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JXPanel.this.repaint();
                }
            };
        }
        return this.painterChangeListener;
    }

    @Override
    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    @Override
    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    @Override
    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    @Override
    protected boolean isPaintingOrigin() {
        return this.getAlpha() < 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (this.getAlpha() == 1.0f) {
            super.paint(g);
        } else {
            BufferedImage img = GraphicsUtilities.createCompatibleTranslucentImage((int)this.getWidth(), (int)this.getHeight());
            Graphics2D gfx = img.createGraphics();
            try {
                super.paint(gfx);
            }
            finally {
                gfx.dispose();
            }
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComp = g2d.getComposite();
            try {
                AlphaComposite alphaComp = AlphaComposite.getInstance(3, this.getEffectiveAlpha());
                g2d.setComposite(alphaComp);
                g2d.drawImage(img, null, 0, 0);
            }
            finally {
                g2d.setComposite(oldComp);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            SwingXUtilities.paintBackground(this, g2);
        }
        finally {
            g2.dispose();
        }
        this.getUI().paint(g, this);
    }
}

