/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.swing.layout.GraphicConstraint;

public abstract class GraphUnitLayout
extends SpringLayout {
    private final LinkedHashMap<Component, GraphicConstraint> componentMap = new LinkedHashMap();

    public void putGraphicConstraint(Component c, double x, double y, int alignX, int alignY) {
        this.componentMap.put(c, new GraphicConstraint(c, x, y, alignX, alignY));
    }

    public LinkedHashMap<Component, GraphicConstraint> getComponentMap() {
        return this.componentMap;
    }

    public void setComponentMap(LinkedHashMap<Component, GraphicConstraint> map) {
        this.componentMap.putAll(map);
    }

    public ArrayList<Dimension> getDimensions() {
        ArrayList<Dimension> dim = new ArrayList<Dimension>(this.componentMap.size());
        for (Component c : this.componentMap.keySet()) {
            dim.add(c.getPreferredSize());
        }
        return dim;
    }

    public void setDimensions(ArrayList<Dimension> dim) {
        int k = 0;
        for (Component c : this.componentMap.keySet()) {
            c.setPreferredSize(dim.get(k));
            ++k;
        }
    }

    protected final void revalidateComponent(Component c, GJAbstractGraphContainer container, GJGraphInterface gr, boolean translateCoordinates) {
        GraphicConstraint constraint = this.getComponentMap().get(c);
        if (constraint != null) {
            double x = gr.getXTransform().getData(constraint.getX());
            double y = gr.getYTransform().getData(constraint.getY());
            int alignX = constraint.getAlignX();
            int alignY = constraint.getAlignY();
            double xpixel = (int)gr.xPositionToPixel(x);
            double ypixel = (int)gr.yPositionToPixel(y);
            switch (alignX) {
                case 2: {
                    xpixel -= (double)c.getWidth();
                    break;
                }
                case 0: {
                    xpixel -= (double)c.getWidth() / 2.0;
                    break;
                }
            }
            switch (alignY) {
                case 1: {
                    ypixel -= (double)c.getHeight();
                    break;
                }
                case 0: {
                    ypixel -= (double)c.getHeight() / 2.0;
                    break;
                }
            }
            if (translateCoordinates) {
                Insets theseInsets = container.getInsets();
                Point point = SwingUtilities.convertPoint((Component)((Object)gr), (int)(xpixel -= (double)theseInsets.left), (int)(ypixel -= (double)theseInsets.top), container);
                this.putConstraint("West", c, (int)point.getX(), "West", (Component)container);
                this.putConstraint("North", c, (int)point.getY(), "North", (Component)container);
            } else {
                this.putConstraint("West", c, (int)Math.round(xpixel), "West", (Component)((Object)gr));
                this.putConstraint("North", c, (int)Math.round(ypixel), "North", (Component)((Object)gr));
            }
        }
    }

    public void doSuperLayoutContainer(Container c) {
    }
}

