/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.math;

import java.util.Arrays;
import java.util.Formatter;
import kcl.waterloo.math.ArrayMath;

public class ColumnStats {
    private final double[][] summary;
    public static final int SUM = 0;
    public static final int SUMDELTA2 = 1;
    public static final int SUMDELTA3 = 2;
    public static final int SUMDELTA4 = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int MEDIAN = 6;
    public static final int LOWER = 7;
    public static final int UPPER = 8;
    public static final int SUMLOG = 9;
    public static final int N = 10;
    private boolean varianceCorrected = true;
    private boolean skewCorrected = false;
    private boolean kurtosisCorrected = false;
    private final int percent;

    public ColumnStats(double[][] data) {
        this(data, 25);
    }

    public ColumnStats(double[][] data, int percentile) {
        this.summary = ColumnStats.initialMatrix(data[0].length);
        this.percent = percentile;
        this.createSummary(data);
    }

    private static double[][] initialMatrix(int N) {
        double[][] matrix = new double[11][N];
        ArrayMath.filli(matrix[4], Double.POSITIVE_INFINITY);
        ArrayMath.filli(matrix[5], Double.NEGATIVE_INFINITY);
        return matrix;
    }

    public int getDimension() {
        return this.summary[0].length;
    }

    public double[][] getSum() {
        return new double[][]{(double[])this.summary[0].clone()};
    }

    public double[][] getMean() {
        return new double[][]{ArrayMath.div(this.summary[0], this.summary[10])};
    }

    public double[][] getVariance() {
        double[] factor = this.varianceCorrected ? ArrayMath.div(ArrayMath.filli(new double[this.getDimension()], 1.0), ArrayMath.sub(this.summary[10], 1.0)) : ArrayMath.div(ArrayMath.filli(new double[this.getDimension()], 1.0), this.summary[10]);
        return new double[][]{ArrayMath.muli(factor, this.summary[1])};
    }

    public double[][] getSD() {
        return new double[][]{ArrayMath.sqrt(this.getVariance()[0])};
    }

    public double[][] getSkew() {
        double[] NN = this.getN()[0];
        double[] num = ArrayMath.div(this.summary[2], NN);
        boolean old = this.varianceCorrected;
        this.varianceCorrected = false;
        double[] den = this.getSD()[0];
        this.varianceCorrected = old;
        den = ArrayMath.powi(den, 3.0);
        double[] result = ArrayMath.div(num, den);
        if (this.skewCorrected) {
            for (int k = 0; k < NN.length; ++k) {
                if (!(NN[k] >= 3.0)) continue;
                int n = k;
                result[n] = result[n] * (Math.sqrt(NN[k] * (NN[k] - 1.0)) / (NN[k] - 2.0));
            }
        }
        return new double[][]{result};
    }

    public double[][] getKurtosis() {
        double[] NN = this.getN()[0];
        double[] num = ArrayMath.div(this.summary[3], NN);
        boolean old = this.varianceCorrected;
        this.varianceCorrected = false;
        double[] den = this.getVariance()[0];
        this.varianceCorrected = old;
        den = ArrayMath.powi(den, 2.0);
        double[] result = ArrayMath.div(num, den);
        if (this.kurtosisCorrected) {
            for (int k = 0; k < NN.length; ++k) {
                if (!(NN[k] >= 4.0)) continue;
                result[k] = ((NN[k] + 1.0) * result[k] - 3.0 * (NN[k] - 1.0)) * (NN[k] - 1.0) / ((NN[k] - 2.0) * (NN[k] - 3.0)) + 3.0;
            }
        }
        return new double[][]{result};
    }

    public double[][] getMinimum() {
        return new double[][]{(double[])this.summary[4].clone()};
    }

    public double[][] getMaximum() {
        return new double[][]{(double[])this.summary[5].clone()};
    }

    public double[][] getGeometricMean() {
        double[] g = ArrayMath.div(this.summary[9], this.summary[10]);
        for (int k = 0; k < g.length; ++k) {
            g[k] = Math.exp(g[k]);
        }
        return new double[][]{g};
    }

    public double[][] getN() {
        return new double[][]{(double[])this.summary[10].clone()};
    }

    public double[][] getMedian() {
        return new double[][]{(double[])this.summary[6].clone()};
    }

    public double[][] getLower() {
        return new double[][]{(double[])this.summary[7].clone()};
    }

    public double[][] getUpper() {
        return new double[][]{(double[])this.summary[8].clone()};
    }

    public double getPercentile() {
        return this.percent;
    }

    public double[][] getSummary() {
        return (double[][])this.summary.clone();
    }

    public boolean isVarianceCorrected() {
        return this.varianceCorrected;
    }

    public void setVarianceCorrected(boolean flag) {
        this.varianceCorrected = flag;
    }

    public boolean isSkewCorrected() {
        return this.skewCorrected;
    }

    public void setSkewCorrected(boolean flag) {
        this.skewCorrected = flag;
    }

    public boolean isKurtosisCorrected() {
        return this.kurtosisCorrected;
    }

    public void setKurtosisCorrected(boolean flag) {
        this.kurtosisCorrected = flag;
    }

    private double[][] createSummary(double[][] data) {
        int k;
        if ((double)this.percent < 0.0 || (double)this.percent > 50.0) {
            return new double[0][0];
        }
        double[][] tr = new double[data[0].length][data.length];
        for (k = 0; k < data.length; ++k) {
            for (int kk = 0; kk < data[k].length; ++kk) {
                if (!Double.isNaN(data[k][kk])) {
                    double[] dArray = this.summary[9];
                    int n = kk;
                    dArray[n] = dArray[n] + Math.log(data[k][kk]);
                    this.summary[4][kk] = Math.min(this.summary[4][kk], data[k][kk]);
                    this.summary[5][kk] = Math.max(this.summary[5][kk], data[k][kk]);
                    double[] dArray2 = this.summary[10];
                    int n2 = kk;
                    dArray2[n2] = dArray2[n2] + 1.0;
                }
                tr[kk][k] = data[k][kk];
            }
        }
        for (int m = 0; m < data[0].length; ++m) {
            this.summary[0][m] = ColumnStats.localSum(tr[m]);
            double mean = this.summary[0][m] / this.summary[10][m];
            double[] residuals = ArrayMath.sub(tr[m], mean);
            double[] raised = ArrayMath.pow(residuals, 2.0);
            this.summary[1][m] = ColumnStats.localSum(raised);
            raised = ArrayMath.pow(residuals, 3.0);
            this.summary[2][m] = ColumnStats.localSum(raised);
            raised = ArrayMath.pow(residuals, 4.0);
            this.summary[3][m] = ColumnStats.localSum(raised);
        }
        for (int n = 0; n < tr.length; ++n) {
            Arrays.sort(tr[n]);
            this.summary[6][n] = ColumnStats.median(tr[n], (int)this.summary[10][n]);
            this.summary[7][n] = ColumnStats.percentile(tr[n], (int)this.summary[10][n], this.percent);
            this.summary[8][n] = ColumnStats.percentile(tr[n], (int)this.summary[10][n], 100 - this.percent);
        }
        for (k = 0; k < this.summary.length; ++k) {
            for (int kk = 0; kk < this.summary[k].length; ++kk) {
                if (this.summary[10][kk] != 0.0) continue;
                this.summary[0][kk] = Double.NaN;
                this.summary[4][kk] = Double.NaN;
                this.summary[5][kk] = Double.NaN;
            }
        }
        return this.summary;
    }

    private static double localSum(double[] in) {
        double sum = 0.0;
        double y = 0.0;
        for (int k = 0; k < in.length; ++k) {
            double x = sum + in[k];
            double z = x - sum;
            y += sum - (x - z) + (in[k] - z);
            sum = x;
        }
        return sum + y;
    }

    private static double median(double[] in, int N) {
        if (N == 0) {
            return Double.NaN;
        }
        if (N == 1) {
            return in[0];
        }
        if (N % 2 != 0) {
            return in[N / 2];
        }
        return (in[N / 2 - 1] + in[N / 2]) / 2.0;
    }

    private static double percentile(double[] in, int N, int percentile) {
        double d;
        if (N == 1) {
            return in[0];
        }
        double pos = (double)(percentile * (N + 1)) / 100.0;
        if (pos < 1.0) {
            return in[0];
        }
        if (pos >= (double)N) {
            return in[N - 1];
        }
        double f = Math.floor(pos);
        int idx = (int)f - 1;
        double result = in[idx] + (d = pos - f) * (in[idx + 1] - in[idx]);
        if (Double.isNaN(result)) {
            if (Double.isInfinite(in[idx])) {
                return in[idx];
            }
            if (Double.isInfinite(in[idx + 1])) {
                return in[idx + 1];
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Formatter f = new Formatter(s);
        f.format("Summary statistics:%n", new Object[0]);
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t    [" + Integer.toString(k) + "]\t", new Object[0]);
        }
        f.format("%nMean:", new Object[0]);
        double[][] mean = this.getMean();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", mean[0][k]);
        }
        f.format("%nSD:", new Object[0]);
        if (this.varianceCorrected) {
            f.format("%3s", "[+]");
        }
        double[][] sd = this.getSD();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", sd[0][k]);
        }
        f.format("%nSkew:", new Object[0]);
        if (this.skewCorrected) {
            f.format("[+]", new Object[0]);
        }
        double[][] skew = this.getSkew();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", skew[0][k]);
        }
        f.format("%nK'osis:", new Object[0]);
        if (this.kurtosisCorrected) {
            f.format("[+]", new Object[0]);
        }
        double[][] kurtosis = this.getKurtosis();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", kurtosis[0][k]);
        }
        f.format("%nMin:", new Object[0]);
        double[][] min = this.getMinimum();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", min[0][k]);
        }
        f.format("%nMax:", new Object[0]);
        double[][] max = this.getMaximum();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", max[0][k]);
        }
        f.format("%nN:", new Object[0]);
        double[][] n = this.getN();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10d", (int)n[0][k]);
        }
        f.format("%nPercentiles:", new Object[0]);
        f.format("%20s", "%nMedian:");
        double[][] median = this.getMedian();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", median[0][k]);
        }
        f.format("%n%2d%%:", this.percent);
        double[][] lower = this.getLower();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", lower[0][k]);
        }
        f.format("%n%2d%%:", 100 - this.percent);
        double[][] upper = this.getUpper();
        for (int k = 0; k < this.summary[0].length; ++k) {
            f.format("\t%10.6f", upper[0][k]);
        }
        f.format("%n%n  [+] indicates bias correction applied", new Object[0]);
        return f.toString();
    }
}

