/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.transforms;

import java.util.ArrayList;
import kcl.waterloo.graphics.transforms.GJAbstractDataTransform;

public final class PTransform
extends GJAbstractDataTransform {
    private static final PTransform Instance = new PTransform();
    private static final long serialVersionUID = 1L;
    private static final ArrayList<Double> minorGrid = PTransform.minorGridMaker();
    private static final ArrayList<Double> majorGrid = PTransform.majorGridMaker();

    private PTransform() {
    }

    public static PTransform getInstance() {
        return Instance;
    }

    @Override
    public String getName() {
        return "-log10";
    }

    @Override
    public final double getData(double val) {
        return -Math.log10(val);
    }

    @Override
    public final double[] getData(double[] arr) {
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = -Math.log10(arr[k]);
        }
        return arr;
    }

    @Override
    public final double getInverse(double val) {
        return Math.pow(10.0, -val);
    }

    @Override
    public final String getTickLabel(double val) {
        return this.nf.format(val);
    }

    @Override
    public ArrayList<Double> getAxisTickPositions(double start, double stop, double inc) {
        int k;
        start = Math.pow(10.0, -start);
        stop = Math.pow(10.0, -stop);
        int idx0 = 0;
        int idx1 = majorGrid.size() - 1;
        for (k = 1; k < majorGrid.size() - 1; ++k) {
            if (!(-Math.pow(10.0, majorGrid.get(k)) > start)) continue;
            idx0 = k - 1;
            break;
        }
        for (k = 1; k < majorGrid.size() - 3; ++k) {
            if (!(-Math.pow(10.0, majorGrid.get(k)) > stop)) continue;
            idx1 = k + 2;
            break;
        }
        return new ArrayList<Double>(majorGrid.subList(idx0, idx1));
    }

    private static ArrayList<Double> majorGridMaker() {
        ArrayList<Double> pos = new ArrayList<Double>();
        for (double s = -16.0; s <= 16.0; s += 1.0) {
            pos.add(s);
        }
        return pos;
    }

    @Override
    public ArrayList<Double> getMinorGridPositions(double start, double stop, double inc, int n) {
        return minorGrid;
    }

    private static ArrayList<Double> minorGridMaker() {
        ArrayList<Double> pos = new ArrayList<Double>();
        for (double s = 1.0E-16; s < 1.0E16; s *= 10.0) {
            for (double s2 = 2.0; s2 <= 9.0; s2 += 1.0) {
                pos.add(Math.log10(s * s2));
            }
        }
        return pos;
    }
}

