/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.transforms;

import java.util.ArrayList;
import kcl.waterloo.graphics.GJUtilities;
import kcl.waterloo.graphics.transforms.GJAbstractDataTransform;

public final class Log2Transform
extends GJAbstractDataTransform {
    static final Log2Transform Instance = new Log2Transform();
    private static final long serialVersionUID = 1L;
    private static final ArrayList<Double> minorGrid = Log2Transform.minorGridMaker();
    private static final ArrayList<Double> majorGrid = Log2Transform.majorGridMaker();

    private Log2Transform() {
    }

    public static Log2Transform getInstance() {
        return Instance;
    }

    @Override
    public String getName() {
        return "log2";
    }

    @Override
    public final double getData(double val) {
        val = Math.log(val) / Math.log(2.0);
        return val;
    }

    @Override
    public final double[] getData(double[] arr) {
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = Math.log(arr[k]) / Math.log(2.0);
        }
        return arr;
    }

    @Override
    public final double getInverse(double val) {
        return Math.pow(2.0, val);
    }

    @Override
    public final String getTickLabel(double val) {
        return "2" + GJUtilities.getSuperscripts(this.nf.format(val));
    }

    @Override
    public ArrayList<Double> getAxisTickPositions(double start, double stop, double inc) {
        int k;
        start = Math.pow(2.0, start);
        stop = Math.pow(2.0, stop);
        if (start <= 0.0) {
            start = stop / 1000.0;
        }
        int idx0 = 0;
        int idx1 = majorGrid.size() - 1;
        for (k = 1; k < majorGrid.size() - 1; ++k) {
            if (!(Math.pow(2.0, majorGrid.get(k)) > start)) continue;
            idx0 = k - 1;
            break;
        }
        for (k = 1; k < majorGrid.size() - 3; ++k) {
            if (!(Math.pow(2.0, majorGrid.get(k)) > stop)) continue;
            idx1 = k + 2;
            break;
        }
        return new ArrayList<Double>(majorGrid.subList(idx0, idx1));
    }

    private static ArrayList<Double> majorGridMaker() {
        ArrayList<Double> pos = new ArrayList<Double>();
        for (double s = -53.0; s <= 53.0; s += 1.0) {
            pos.add(s);
        }
        return pos;
    }

    @Override
    public ArrayList<Double> getMinorGridPositions(double start, double stop, double inc, int n) {
        return minorGrid;
    }

    private static ArrayList<Double> minorGridMaker() {
        return new ArrayList<Double>();
    }
}

