/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D.contour;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.TreeMap;
import kcl.waterloo.graphics.plots2D.contour.Contour;

class ContourSet
extends TreeMap<Double, ArrayList<Contour>> {
    private final Area commonArea = new Area();

    public final Area getCommonArea() {
        return (Area)this.commonArea.clone();
    }

    public final void setCommonArea() {
        Path2D.Double commonPath = new Path2D.Double();
        for (ArrayList arr : this.values()) {
            for (Contour c : arr) {
                if (c.isClosed()) {
                    commonPath.append(c.getPath(), false);
                    continue;
                }
                commonPath.append(c.getPath(), true);
            }
        }
        this.commonArea.reset();
        this.commonArea.add(new Area(commonPath));
    }

    public final Rectangle2D getBounds2D() {
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        for (Double level : this.keySet()) {
            ArrayList c = (ArrayList)this.get(level);
            for (Contour c1 : c) {
                ((Rectangle2D)r).setRect(((Rectangle2D)r).createUnion(c1.getPath().getBounds2D()));
            }
        }
        return r;
    }

    public final ArrayList<Contour> sort() {
        return this.byArea();
    }

    private ArrayList<Contour> byArea() {
        ArrayList<Contour> all = new ArrayList<Contour>();
        for (Double level : this.keySet()) {
            ArrayList c = (ArrayList)this.get(level);
            all.addAll(c);
        }
        Collections.sort(all, Collections.reverseOrder(AreaSorter.getInstance()));
        return all;
    }

    @Override
    public String toString() {
        Formatter f = new Formatter();
        String clss = this.getClass().toString().replace("kcl.waterloo.graphics.plots2D.contour.", "");
        clss = clss.replace("class", "");
        f.format("Waterloo graphics %s [@%x]:\n", clss, this.hashCode());
        f.format("NOTE: Double.NaN, when present, are ignored\n", new Object[0]);
        for (Double key : this.keySet()) {
            ArrayList list = (ArrayList)this.get(key);
            f.format("\nLevel %7.3f:", (double)key);
            int i = 0;
            for (Contour c : list) {
                Double[] val = new Double[Math.min(c.getX().size(), 20)];
                val = c.getX().subList(0, Math.min(c.getX().size(), 20)).toArray(val);
                f.format("\nx%d: ", i);
                ContourSet.outputVector(f, val);
                val = new Double[Math.min(c.getY().size(), 20)];
                val = c.getY().subList(0, Math.min(c.getY().size(), 20)).toArray(val);
                f.format("\ny%d: ", i);
                ContourSet.outputVector(f, val);
                ++i;
            }
        }
        f.format("\n", new Object[0]);
        return f.toString();
    }

    private static void outputVector(Formatter f, Double[] val) {
        if (val.length >= 16) {
            int k;
            for (k = 0; k < 8; ++k) {
                f.format("%7.3f ", (double)val[k]);
            }
            f.format(" ...", new Object[0]);
            for (k = val.length - 8; k < val.length; ++k) {
                f.format("%7.3f ", (double)val[k]);
            }
        } else {
            for (int k = 0; k < val.length; ++k) {
                f.format("%7.3f ", (double)val[k]);
            }
        }
    }

    private static final class AreaSorter
    implements Comparator<Contour> {
        private static AreaSorter instance = new AreaSorter();

        private AreaSorter() {
        }

        private static AreaSorter getInstance() {
            return instance;
        }

        @Override
        public final int compare(Contour c0, Contour c1) {
            if (c0.getArea() > c1.getArea()) {
                return 1;
            }
            if (c0.getArea() < c1.getArea()) {
                return -1;
            }
            return 0;
        }
    }
}

