/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D.contour;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import kcl.waterloo.graphics.data.GJXYSeries;
import kcl.waterloo.graphics.plots2D.GJContour;
import kcl.waterloo.graphics.plots2D.contour.Contour;
import kcl.waterloo.graphics.plots2D.contour.ContourSet;
import kcl.waterloo.marker.ShapeUtils;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.math.ArrayUtils;

public class ContourExtra {
    private TreeMap<Double, ArrayList<GJXYSeries>> levelData = null;
    private final ContourSet contourSet = new ContourSet();
    private final TreeMap<Double, Path2D> compoundLines = new TreeMap();
    private final ArrayList<SortedContour> sortedSet = new ArrayList();
    BasicStroke zeroStroke = null;
    private Paint positiveLineColor = null;
    private Paint negativeLineColor = null;

    public ArrayList<SortedContour> sort() {
        if (this.sortedSet.isEmpty()) {
            ArrayList<Contour> sortedList = this.contourSet.sort();
            Area accumulator = new Area();
            for (int k = 0; k < sortedList.size(); ++k) {
                Contour contour = sortedList.get(k);
                int index = this.getColorIndex(contour.getLevel());
                if (k > 0 && k < sortedList.size() - 1 && ShapeUtils.contains(sortedList.get(k - 1).getContourAsArea(), contour.getContourAsArea()) && sortedList.get(k + 1).getLevel() > contour.getLevel()) {
                    index = this.getColorIndex(sortedList.get(k + 1).getLevel());
                }
                SortedContour sortedContour = new SortedContour(contour, index);
                if (k > 0 && !ShapeUtils.contains(accumulator, contour.getContourAsArea()) && ShapeUtils.intersects(accumulator, contour.getContourAsArea())) {
                    Area area2 = contour.getContourAsArea();
                    area2.subtract(accumulator);
                    sortedContour.setFillArea(area2);
                }
                this.sortedSet.add(sortedContour);
                accumulator.add(contour.getContourAsArea());
            }
        }
        return this.sortedSet;
    }

    public final int getColorIndex(Double key) {
        int k = 0;
        for (Double level : this.levelData.keySet()) {
            if (key.equals(level)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public Double[] getLevels() {
        Double[] levels = new Double[this.levelData.size()];
        int k = 0;
        Iterator<Double> iterator = this.levelData.keySet().iterator();
        while (iterator.hasNext()) {
            Double level;
            levels[k] = level = iterator.next();
            ++k;
        }
        return levels;
    }

    public final TreeMap<Double, ArrayList<GJXYSeries>> getLevelData() {
        return this.levelData;
    }

    public final void setLevelData(TreeMap<Double, ArrayList<GJXYSeries>> levels) {
        this.levelData = levels;
        this.generateContours();
    }

    public final Area getCommonPath() {
        return this.contourSet.getCommonArea();
    }

    public final ArrayList<Contour> getLevel(Double level) {
        return (ArrayList)this.contourSet.get(level);
    }

    public final int size() {
        return this.levelData.size();
    }

    public final Set<Double> keySet() {
        return this.contourSet.keySet();
    }

    public final TreeMap<Double, Path2D> getCompounds() {
        return this.compoundLines;
    }

    public final Path2D getCompound(Double level) {
        return (Path2D)this.compoundLines.get(level).clone();
    }

    public final void generateCompounds() {
        for (Double level : this.contourSet.keySet()) {
            Path2D.Double path = new Path2D.Double();
            for (Contour c : (ArrayList)this.contourSet.get(level)) {
                path.append(c.getPath(), false);
            }
            this.compoundLines.put(level, path);
        }
    }

    public void generateContours() {
        this.contourSet.clear();
        for (Double thisLevel : this.getLevelData().keySet()) {
            ArrayList<GJXYSeries> collection = this.getLevelData().get(thisLevel);
            for (GJXYSeries series : collection) {
                ArrayList<Double> x = series.getX();
                ArrayList<Double> y = series.getY();
                if (x.size() <= 2) continue;
                Double[] x0 = new Double[x.size()];
                x0 = x.toArray(x0);
                Double[] y0 = new Double[y.size()];
                y0 = y.toArray(y0);
                Contour contour = new Contour(x0, y0, thisLevel);
                if (!this.contourSet.containsKey(thisLevel)) {
                    this.contourSet.put(thisLevel, new ArrayList());
                }
                ((ArrayList)this.contourSet.get(thisLevel)).add(contour);
            }
        }
        this.generateCompounds();
        this.sortedSet.clear();
        this.contourSet.setCommonArea();
    }

    public final void generateContours(GJContour plot) {
        if (plot.getParentGraph() == null) {
            return;
        }
        double xoffset = plot.getXData().getDimension() <= 0 ? 0.0 : plot.getXData().getRawDataValues()[0];
        double yoffset = plot.getYData().getDimension() <= 0 ? 0.0 : plot.getYData().getRawDataValues()[0];
        if (this.getLevelData().keySet().size() > 0) {
            this.contourSet.clear();
            for (Double thisLevel : this.getLevelData().keySet()) {
                ArrayList<GJXYSeries> collection = this.getLevelData().get(thisLevel);
                for (GJXYSeries series : collection) {
                    double[] x0 = ArrayUtils.asDouble(series.getX());
                    ArrayMath.addi(x0, xoffset);
                    x0 = plot.getParentGraph().getXTransform().getData(x0);
                    if (x0.length <= 2) continue;
                    double[] y0 = ArrayUtils.asDouble(series.getY());
                    ArrayMath.addi(y0, yoffset);
                    y0 = plot.getParentGraph().getYTransform().getData(y0);
                    Contour contour = new Contour(x0, y0, thisLevel);
                    if (!this.contourSet.containsKey(thisLevel)) {
                        this.contourSet.put(thisLevel, new ArrayList());
                    }
                    ((ArrayList)this.contourSet.get(thisLevel)).add(contour);
                }
            }
        }
        this.generateCompounds();
        this.contourSet.setCommonArea();
        this.sortedSet.clear();
    }

    public static ContourExtra createInstance() {
        ContourExtra contours = new ContourExtra();
        contours.levelData = new TreeMap();
        return contours;
    }

    public void addContour(ArrayList<ArrayList<Double>> data, double level) {
        this.addContour(new GJXYSeries(data), level);
    }

    public void addContour(GJXYSeries data, double level) {
        if (this.getLevelData().get(level) == null) {
            this.getLevelData().put(level, new ArrayList());
        }
        this.getLevelData().get(level).add(data);
    }

    public static ContourExtra createFromMatrix(double[][] C) {
        ContourExtra contours = new ContourExtra();
        contours.levelData = new TreeMap();
        int k = 0;
        while (k < C[0].length) {
            double thisLevel = C[0][k];
            int thisN = (int)C[1][k];
            if (thisN > 2) {
                double[][] data = new double[2][thisN];
                for (int n = 1; n <= thisN; ++n) {
                    data[0][n - 1] = C[0][k + n];
                    data[1][n - 1] = C[1][k + n];
                }
                if (contours.getLevelData().get(thisLevel) == null) {
                    contours.getLevelData().put(thisLevel, new ArrayList());
                }
                contours.getLevelData().get(thisLevel).add(new GJXYSeries(data[0], data[1]));
            }
            k = k + thisN + 1;
        }
        return contours;
    }

    public ArrayList<SortedContour> getSortedSet() {
        return this.sort();
    }

    public void setZeroStroke(BasicStroke s) {
        this.zeroStroke = s;
    }

    public BasicStroke getZeroStroke() {
        return this.zeroStroke;
    }

    public Paint getPositiveLineColor() {
        return this.positiveLineColor;
    }

    public void setPositiveLineColor(Paint positiveLineColor) {
        this.positiveLineColor = positiveLineColor;
    }

    public Paint getNegativeLineColor() {
        return this.negativeLineColor;
    }

    public void setNegativeLineColor(Paint negativeLineColor) {
        this.negativeLineColor = negativeLineColor;
    }

    public static final class SortedContour {
        private Contour contour = null;
        private int colorIndex = -1;
        private Area fillArea = null;

        private SortedContour(Contour contour, int index) {
            this.contour = contour;
            this.colorIndex = index;
            this.setFillArea(contour.getContourAsArea());
        }

        public final Contour getContour() {
            return this.contour;
        }

        public final void setContour(Contour contour) {
            this.contour = contour;
        }

        public final int getColorIndex() {
            return this.colorIndex;
        }

        public final void setColorIndex(int index) {
            this.colorIndex = index;
        }

        public final Area getFillArea() {
            return new Area(this.fillArea);
        }

        public final void setFillArea(Area fillArea) {
            this.fillArea = new Area(fillArea);
        }
    }
}

