/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJAbstractPolarPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.PolarExtra;
import kcl.waterloo.math.ArrayMath;

public class GJPolarBar
extends GJAbstractPolarPlot {
    public GJPolarBar() {
    }

    public GJPolarBar(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        GJPlotInterface instance = GJAbstractPlot.createInstance(new GJPolarBar());
        PolarExtra extra = new PolarExtra();
        instance.getDataModel().setExtraObject(extra);
        instance.setXData(new double[]{0.0});
        return instance;
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        Arc2D arc;
        int k;
        if (this.getParentGraph() == null || this.getDataModel() == null) {
            return;
        }
        super.paintPlot(g2);
        this.getScreenDataArray().clear();
        double[] y = this.getYData().getRawDataValues();
        ArrayMath.sqrti(y);
        double X = this.getParentGraph().xPositionToPixel(0.0);
        double Y = this.getParentGraph().yPositionToPixel(0.0);
        double scx = this.getParentGraph().getPixelWidth();
        double scy = this.getParentGraph().getPixelHeight();
        double sum = 0.0;
        double arcWidth = 360.0 / (double)y.length;
        for (k = 0; k < y.length; ++k) {
            double radius = y[k];
            arc = new Arc2D.Double(X - radius / scx, Y - radius / scy, 2.0 * radius / scx, 2.0 * radius / scy, sum, arcWidth, 2);
            g2.setPaint(this.getFill().get(k));
            g2.fill(arc);
            this.getScreenDataArray().add(arc);
            sum += arcWidth;
        }
        for (k = 0; k < this.getScreenDataArray().size(); ++k) {
            g2.setPaint(this.getEdgeColor().get(k));
            g2.setStroke(this.getEdgeStroke().get(k));
            arc = (Arc2D)this.getScreenDataArray().get(k);
            g2.draw(arc);
        }
    }

    @Override
    public Rectangle2D getDataRange() {
        if (this.getXDataValues() != null && this.getYDataValues() != null) {
            double[] y = ArrayMath.minmax(this.getYDataValues());
            y = ArrayMath.sqrti(y);
            Rectangle2D r = new Rectangle2D.Double(ArrayMath.min(y), ArrayMath.min(y), ArrayMath.max(y), ArrayMath.max(y));
            for (GJPlotInterface p : this.getPlotList()) {
                Rectangle2D r2 = (Rectangle2D)p.getDataRange();
                r = ((Rectangle2D)r).createUnion(r2);
            }
            return r;
        }
        return new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0);
    }
}

