/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.PieExtra;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.math.geom.Cartesian;
import kcl.waterloo.math.geom.Coordinates;

public class GJPie
extends GJAbstractPlot {
    private boolean newFlag = true;

    public GJPie() {
    }

    public GJPie(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        GJPlotInterface instance = GJAbstractPlot.createInstance(new GJPie());
        instance.getDataModel().setExtraObject(new PieExtra());
        instance.setXData(new double[]{0.0});
        return instance;
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        Arc2D arc;
        int k;
        if (this.getParentGraph() == null || this.getDataModel() == null) {
            return;
        }
        if (this.newFlag) {
            this.newFlag = false;
            this.getParentGraph().setLeftAxisPainted(false);
            this.getParentGraph().setRightAxisPainted(false);
            this.getParentGraph().setTopAxisPainted(false);
            this.getParentGraph().setBottomAxisPainted(false);
            this.getParentGraph().setMajorGridPainted(false);
            this.getParentGraph().setMinorGridPainted(false);
            if (this.getParentGraph().getGraphContainer() != null) {
                this.getParentGraph().getGraphContainer().setAspectRatio(1.0);
            }
            ((GJAbstractGraph)this.getParentGraph()).setAxesBounds(-1.0, -1.0, 2.0, 2.0);
        }
        super.paintPlot(g2);
        this.getScreenDataArray().clear();
        PieExtra extra = (PieExtra)this.getDataModel().getExtraObject();
        double minDim = Math.min(((Component)((Object)this.getParentGraph())).getWidth(), ((Component)((Object)this.getParentGraph())).getHeight());
        double outerDiameter = extra.getOuterRadius();
        double innerDiameter = extra.getInnerRadius();
        double[] y = this.getYData().getRawDataValues();
        double[] y2 = this.getYData().getRawDataValues();
        switch (extra.getMode()) {
            case PERCENTAGES: {
                ArrayMath.muli(y, 3.6);
                break;
            }
            case RADIANS: {
                ArrayMath.muli(y, 57.29577951308232);
                break;
            }
            case DEGREES: {
                break;
            }
            default: {
                ArrayMath.divi(y, ArrayMath.sum(y));
                ArrayMath.muli(y, 360.0);
            }
        }
        double X = this.getParentGraph().xPositionToPixel(-1.0);
        double Y = this.getParentGraph().yPositionToPixel(1.0);
        double xyTranslate = (minDim * outerDiameter - minDim * innerDiameter) / 2.0;
        Area center = new Area(new Arc2D.Double(X + xyTranslate, Y + xyTranslate, minDim * innerDiameter, minDim * innerDiameter, 0.0, 360.0, 0));
        double sum = 0.0;
        double explodeExtent = extra.getExplodeExtent();
        for (k = 0; k < y.length; ++k) {
            double Y2;
            double X2;
            if (extra.getExplode() != null && extra.getExplode().length > k && extra.getExplode()[k]) {
                double centerTheta = -(sum + y[k] / 2.0) * (Math.PI / 180);
                Cartesian a = Coordinates.polarToCartesian(centerTheta, outerDiameter + explodeExtent);
                Cartesian b = Coordinates.polarToCartesian(centerTheta, outerDiameter);
                double xoffset = minDim * (a.getX()[0] - b.getX()[0]);
                double yoffset = minDim * (a.getY()[0] - b.getY()[0]);
                X2 = X + xoffset;
                Y2 = Y + yoffset;
            } else {
                X2 = X;
                Y2 = Y;
            }
            arc = new Arc2D.Double(X2, Y2, minDim * outerDiameter, minDim * outerDiameter, sum, y[k], 2);
            g2.setPaint(this.getFill().get(k));
            g2.fill(arc);
            this.getScreenDataArray().add(arc);
            sum += y[k];
        }
        for (k = 0; k < this.getScreenDataArray().size(); ++k) {
            g2.setPaint(this.getEdgeColor().get(k));
            g2.setStroke(this.getEdgeStroke().get(k));
            arc = (Arc2D)this.getScreenDataArray().get(k);
            g2.draw(arc);
            if (innerDiameter == 0.0) continue;
            g2.setPaint(Color.WHITE);
            g2.fill(center);
            g2.setPaint(Color.BLACK);
            g2.draw(center);
        }
        if (extra.isLabeled()) {
            FontMetrics metrics = g2.getFontMetrics();
            xyTranslate = (minDim * outerDiameter - minDim * extra.getLabelRadius()) / 2.0;
            Arc2D.Double lbl = new Arc2D.Double(X + xyTranslate, Y + xyTranslate, minDim * extra.getLabelRadius(), minDim * extra.getLabelRadius(), 0.0, 360.0, 0);
            sum = 0.0;
            for (int k2 = 0; k2 < this.getScreenDataArray().size(); ++k2) {
                String s;
                Arc2D arc2 = (Arc2D)this.getScreenDataArray().get(k2);
                double theta = -(sum + y[k2] / 2.0) * (Math.PI / 180);
                double[] xy = this.getXY(arc2, lbl, theta);
                if (extra.getLabels().size() > 0) {
                    s = extra.getLabels().get(k2);
                } else if (extra.getLabelFormat() != null) {
                    s = extra.getLabelFormat().format(y2[k2]);
                } else {
                    switch (extra.getMode()) {
                        case PERCENTAGES: {
                            s = String.format("%3.1f%%", y2[k2]);
                            break;
                        }
                        case RADIANS: {
                            s = String.format("%3.2f", y2[k2]);
                            break;
                        }
                        default: {
                            s = String.format("%4.1f", y2[k2]);
                        }
                    }
                }
                g2.drawString(s, (float)(xy[0] - (double)((float)metrics.stringWidth(s) / 2.0f)), (float)(xy[1] + (double)metrics.getMaxAscent() / 2.0));
                sum += y[k2];
            }
        }
    }

    private double[] getXY(Arc2D arc0, Arc2D arc1, double theta) {
        double x1 = arc0.getCenterX();
        double y1 = arc0.getCenterY();
        double x2 = arc0.getCenterX() + Math.cos(theta) * arc1.getHeight();
        double y2 = arc0.getCenterY() + Math.sin(theta) * arc1.getWidth();
        double horzAngle = (Math.atan2(y2 - y1, x2 - x1) + Math.PI * 2) % (Math.PI * 2);
        double xc = arc1.getCenterX();
        double yc = arc1.getCenterY();
        double r1 = arc1.getWidth() / 2.0 - arc1.getWidth() / 30.0;
        double r2 = arc1.getHeight() / 2.0 - arc1.getHeight() / 30.0;
        double cot = Math.cos(0.0);
        double sit = Math.sin(0.0);
        double xl = xc + r1 * Math.cos(horzAngle) * cot - r2 * Math.sin(horzAngle) * sit;
        double yl = yc + r1 * Math.cos(horzAngle) * sit + r2 * Math.sin(horzAngle) * cot;
        return new double[]{xl, yl};
    }
}

