/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;

public class GJComponentPlot
extends GJAbstractPlot {
    private static final long serialVersionUID = 1L;
    private ArrayList<JComponent> componentArray = new ArrayList();
    private boolean upToDate = true;

    public static GJPlotInterface createInstance() {
        return GJAbstractPlot.createInstance(new GJComponentPlot());
    }

    public void setComponentsVisible(boolean flag) {
        for (JComponent c : this.componentArray) {
            c.setVisible(flag);
        }
    }

    public ArrayList<JComponent> getComponentArray() {
        return this.componentArray;
    }

    public final void setComponentArray(ArrayList<JComponent> c) {
        this.componentArray = c;
        this.upToDate = false;
    }

    public final JComponent getComponent(int index) {
        if (index < this.componentArray.size()) {
            return this.componentArray.get(index);
        }
        return null;
    }

    public final void setPreferredSize(int width, int height) {
        for (JComponent c : this.componentArray) {
            c.setPreferredSize(new Dimension(width, height));
        }
    }

    public final ArrayList<Dimension> getPreferredSize() {
        ArrayList<Dimension> szs = new ArrayList<Dimension>(this.componentArray.size());
        for (JComponent c : this.componentArray) {
            szs.add(c.getPreferredSize());
        }
        return szs;
    }

    public final void setPreferredSize(ArrayList<Dimension> arr) {
        int k = 0;
        for (Dimension d : arr) {
            this.componentArray.get(k).setPreferredSize(d);
            ++k;
        }
    }

    public void setComponents(JComponent c) {
        this.setComponents(c.getClass());
    }

    public final void setComponents(Class clzz) {
        ArrayList<JComponent> arr = new ArrayList<JComponent>();
        double[] theseXData = this.getXDataValues();
        double[] theseYData = this.getYDataValues();
        if (theseXData == null || theseYData == null) {
            return;
        }
        for (int k = 0; k < theseXData.length; ++k) {
            try {
                JComponent c = (JComponent)clzz.newInstance();
                c.setPreferredSize(new Dimension(15, 15));
                arr.add(c);
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        this.setComponentArray(arr);
        this.paintPlot(null);
    }

    public void removeComponents() {
        for (JComponent c : this.componentArray) {
            c.getParent().remove(c);
        }
        this.upToDate = false;
    }

    @Override
    public void paintPlot(Graphics2D g2) {
        if (!this.upToDate) {
            double[] theseXData = this.getXDataValues();
            double[] theseYData = this.getYDataValues();
            if (theseXData == null || theseYData == null || this.componentArray == null || this.getParentGraph() == null) {
                return;
            }
            int i = 0;
            for (JComponent c : this.componentArray) {
                if (c.getParent() == null) {
                    this.getParentGraph().add(c, theseXData[i], theseYData[i]);
                } else {
                    this.setPreferredSize(this.getPreferredSize());
                    this.getParentGraph().add(c, theseXData[i], theseYData[i]);
                    c.revalidate();
                }
                ++i;
            }
            ((JComponent)((Object)this.getParentGraph())).revalidate();
            this.upToDate = true;
        } else if (this.getParentGraph() != null) {
            ((JComponent)((Object)this.getParentGraph())).revalidate();
        }
    }

    @Override
    public boolean isMultiplexible() {
        return false;
    }
}

