/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.geom.Rectangle2D;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.GJPolarPlotInterface;
import kcl.waterloo.graphics.plots2D.PolarExtra;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.math.geom.Cartesian;
import kcl.waterloo.math.geom.Coordinates;

public abstract class GJAbstractPolarPlot
extends GJAbstractPlot
implements GJPolarPlotInterface {
    public GJAbstractPolarPlot() {
    }

    public GJAbstractPolarPlot(GJAbstractPlot p) {
        super(p);
    }

    @Override
    public Rectangle2D getDataRange() {
        if (this.getXDataValues() != null && this.getYDataValues() != null) {
            double[] yposition;
            double[] xposition;
            if (((PolarExtra)this.getDataModel().getExtraObject()).getDataMode() == PolarExtra.DATAMODE.POLAR) {
                Cartesian cart = Coordinates.polarToCartesian(this.getXDataValues(), this.getYDataValues());
                xposition = cart.getX();
                yposition = cart.getY();
            } else {
                xposition = this.getXDataValues();
                yposition = this.getYDataValues();
            }
            double[] x = ArrayMath.minmax(xposition);
            double[] y = ArrayMath.minmax(yposition);
            Rectangle2D r = new Rectangle2D.Double(x[0], y[0], x[1] - x[0], y[1] - y[0]);
            for (GJPlotInterface p : this.getPlotList()) {
                Rectangle2D r2 = (Rectangle2D)p.getDataRange();
                r = ((Rectangle2D)r).createUnion(r2);
            }
            return r;
        }
        return new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0);
    }
}

