/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.data;

import java.math.BigDecimal;
import java.util.AbstractList;
import kcl.waterloo.graphics.data.GJAbstractDataVector;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;

public final class GJBigDecimalDataVector
extends GJAbstractDataVector<BigDecimal[]> {
    private static final long serialVersionUID = 1L;

    public GJBigDecimalDataVector() {
        super(new BigDecimal[0]);
    }

    @Override
    public final void setDataBufferData(double[] v) {
        if (v != null) {
            BigDecimal[] buffer = new BigDecimal[v.length];
            for (int k = 0; k < v.length; ++k) {
                buffer[k] = new BigDecimal(v[k]);
            }
            this.setDataBuffer(buffer);
        } else {
            this.clearDataBufferData();
        }
    }

    @Override
    public final void setDataBufferData(int[] v) {
        if (v != null) {
            BigDecimal[] v2 = new BigDecimal[v.length];
            for (int k = 0; k < v.length; ++k) {
                v2[k] = new BigDecimal(v[k]);
            }
            this.setDataBuffer(v2);
        } else {
            this.clearDataBufferData();
        }
    }

    public final void setDataBufferData(BigDecimal[] v) {
        if (v != null) {
            BigDecimal[] v2 = new BigDecimal[v.length];
            for (int k = 0; k < v.length; ++k) {
                v2[k] = new BigDecimal(v[k].toString());
            }
            this.setDataBuffer(v2);
        } else {
            this.clearDataBufferData();
        }
    }

    @Override
    public final void setDataBufferData(AbstractList<? extends Number> v) {
        BigDecimal[] data = new BigDecimal[v.size()];
        for (int k = 0; k < v.size(); ++k) {
            data[k] = new BigDecimal(v.get(k).toString());
        }
        this.setDataBuffer(data);
    }

    @Override
    public final void setEntry(int index, double val) {
        this.setEntry(index, new BigDecimal(val));
    }

    public final void setEntry(int index, BigDecimal val) {
        BigDecimal old = ((BigDecimal[])this.getDataBuffer())[index];
        ((BigDecimal[])this.getDataBuffer())[index] = val;
        this.getPCS().fireIndexedPropertyChange("dataBuffer", index, old, ((BigDecimal[])this.getDataBuffer())[index]);
    }

    public final synchronized void setDataBuffer(BigDecimal[] buffer) {
        super.setDataBuffer(buffer);
    }

    @Override
    public final double[] getDataValues(GJDataTransformInterface transform) {
        if (this.getDataBuffer() == null) {
            return new double[0];
        }
        BigDecimal[] buffer = (BigDecimal[])this.getDataBuffer();
        double[] arr = new double[buffer.length];
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = buffer[k].doubleValue();
        }
        return transform.getData(arr);
    }

    @Override
    public final double[] getRawDataValues() {
        if (this.getDataBuffer() == null) {
            return new double[0];
        }
        BigDecimal[] buffer = (BigDecimal[])this.getDataBuffer();
        double[] arr = new double[buffer.length];
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = buffer[k].doubleValue();
        }
        return arr;
    }

    @Override
    public final int getDimension() {
        if (this.getDataBuffer() == null) {
            return 0;
        }
        return ((BigDecimal[])this.getDataBuffer()).length;
    }
}

