/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.data;

import java.beans.PropertyChangeEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import kcl.waterloo.graphics.data.Category;
import kcl.waterloo.graphics.data.GJDataVectorInterface;
import kcl.waterloo.graphics.data.PrimitiveDoubleBuffer;
import kcl.waterloo.graphics.transforms.NOPTransform;
import kcl.waterloo.observable.GJAbstractObservable;

public abstract class GJAbstractDataVector<T>
extends GJAbstractObservable
implements GJDataVectorInterface<T> {
    private T dataBuffer = null;
    protected LinkedHashMap<Double, Category> categories = null;
    private String name = "";

    GJAbstractDataVector(T dataBuffer) {
        this.dataBuffer = dataBuffer;
    }

    @Override
    public synchronized void clearDataBufferData() {
        T old = this.getDataBuffer();
        this.setDataBuffer(null);
        this.getPCS().firePropertyChange("dataBuffer", old, null);
    }

    @Override
    public final synchronized void setDataBuffer(Object buffer) {
        T old = this.getDataBuffer();
        this.dataBuffer = buffer;
        this.getPCS().firePropertyChange("dataBuffer", old, this.getDataBuffer());
    }

    @Override
    public final synchronized T getDataBuffer() {
        return this.dataBuffer;
    }

    @Override
    public final Object getEntry(int index) {
        if (this.getDataBuffer() instanceof PrimitiveDoubleBuffer) {
            PrimitiveDoubleBuffer v = (PrimitiveDoubleBuffer)this.getDataBuffer();
            return v.data[index];
        }
        Object[] obj = (Object[])this.getDataBuffer();
        return obj[index];
    }

    @Override
    public boolean isCategorical() {
        return this.categories != null;
    }

    @Override
    public void setCategory(double index, String val) {
        Category old;
        if (this.categories == null) {
            this.categories = new LinkedHashMap();
            old = Category.getEmptyInstance();
        } else {
            old = this.categories.get(index);
        }
        this.categories.put(index, new Category(val));
        this.getPCS().firePropertyChange("categories", old, this.categories);
    }

    @Override
    public LinkedHashMap<Double, Category> getCategories() {
        return this.categories;
    }

    @Override
    public Category getCategory(double val) {
        return this.categories.get(val);
    }

    @Override
    public void setCategories(LinkedHashMap<Double, Category> cat) {
        LinkedHashMap<Double, Category> old = this.categories;
        this.categories = cat;
        this.getPCS().firePropertyChange("categories", old, this.categories);
    }

    public void setCategories(String ... cat) {
        LinkedHashMap<Double, Category> map = new LinkedHashMap<Double, Category>();
        double[] values = this.getDataValues(NOPTransform.getInstance());
        if (cat == null) {
            LinkedHashMap<Double, Category> old = this.categories;
            this.categories = null;
            this.getPCS().firePropertyChange("categories", old, this.categories);
        } else {
            for (int k = 0; k < cat.length; ++k) {
                map.put(values[k], new Category(cat[k]));
            }
            this.setCategories(map);
        }
    }

    @Override
    public final Class getBufferClass() {
        return this.getDataBuffer().getClass();
    }

    @Override
    public void setDataBufferData(Map m) {
        T old = this.getDataBuffer();
        if (m.size() == 1) {
            Object[] start = m.keySet().toArray();
            Object[] stop = m.values().toArray();
            int s1 = Integer.parseInt(start[0].toString());
            int s2 = Integer.parseInt(stop[0].toString());
            int[] v = new int[s2 - s1 + 1];
            for (int k = 0; k < v.length; ++k) {
                v[k] = s1 + k;
            }
            this.setDataBufferData(v);
        }
        this.getPCS().firePropertyChange("dataBuffer", old, this.getDataBuffer());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
    }
}

