/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.geom.Path2D;

public final class GJUtilities {
    private static Color[] colorseries = new Color[]{Color.blue, new Color(0, 128, 0), Color.red, new Color(0, 192, 192), new Color(192, 0, 192), new Color(192, 192, 0), new Color(64, 64, 64)};

    private GJUtilities() {
    }

    public static Color getColor(int n) {
        return colorseries[n %= colorseries.length - 1];
    }

    public static void setColors(Color[] c) {
        colorseries = (Color[])c.clone();
    }

    public static void setGray() {
        colorseries = new Color[8];
        int v = 32;
        for (int k = 0; k < 8; k += 2) {
            GJUtilities.colorseries[k] = new Color(v, v, v);
            GJUtilities.colorseries[k] = new Color(v + 48, v + 48, v + 48);
            v += 32;
        }
    }

    public void setBlack() {
        colorseries = new Color[8];
        for (int k = 0; k < 8; ++k) {
            GJUtilities.colorseries[k] = Color.black;
        }
    }

    public static BasicStroke makeStroke(float w, String s) {
        BasicStroke strk;
        if (s == null || s.equals("-") || s.equals("Solid")) {
            strk = new BasicStroke(w, 0, 2);
        } else if (s.equals("--") || s.equals("Dashed")) {
            float[] dash = new float[]{4.0f * w};
            strk = new BasicStroke(w, 0, 2, w * 1.5f, dash, 0.0f);
        } else if (s.equals(":") || s.equals("Dotted")) {
            float[] dash = new float[]{w};
            strk = new BasicStroke(w, 0, 2, w * 1.5f, dash, 0.0f);
        } else if (s.equals(".-") || s.equals("Dot-Dash")) {
            float[] dash = new float[]{w, 2.5f * w, 4.0f * w, 2.5f * w};
            strk = new BasicStroke(w, 0, 2, w * 1.5f, dash, 0.0f);
        } else {
            strk = s.equals("none") ? null : new BasicStroke(w, 1, 2);
        }
        return strk;
    }

    public static RadialGradientPaint getRadialGradientPaint(double x, double y, Shape m, RadialGradientPaint p) {
        float radius = (float)m.getBounds2D().getWidth() / 2.0f;
        return new RadialGradientPaint((float)x, (float)y, radius, (float)p.getFocusPoint().getX(), (float)p.getFocusPoint().getY(), p.getFractions(), p.getColors(), p.getCycleMethod());
    }

    public static Path2D[] makePath2DArray(int n) {
        return new Path2D[n];
    }

    public static Path2D makePath2DDouble() {
        return new Path2D.Double();
    }

    public static String getSuperscripts(String s) {
        StringBuilder sb = new StringBuilder();
        block19: for (int k = 0; k < s.length(); ++k) {
            switch (s.charAt(k)) {
                case '0': {
                    sb.append("\u2070");
                    continue block19;
                }
                case '1': {
                    sb.append("\u00b9");
                    continue block19;
                }
                case '2': {
                    sb.append("\u00b2");
                    continue block19;
                }
                case '3': {
                    sb.append("\u00b3");
                    continue block19;
                }
                case '4': {
                    sb.append("\u2074");
                    continue block19;
                }
                case '5': {
                    sb.append("\u2075");
                    continue block19;
                }
                case '6': {
                    sb.append("\u2076");
                    continue block19;
                }
                case '7': {
                    sb.append("\u2077");
                    continue block19;
                }
                case '8': {
                    sb.append("\u2078");
                    continue block19;
                }
                case '9': {
                    sb.append("\u2079");
                    continue block19;
                }
                case '+': {
                    sb.append("\u207a");
                    continue block19;
                }
                case '-': {
                    sb.append("\u207b");
                    continue block19;
                }
                case '=': {
                    sb.append("\u207c");
                    continue block19;
                }
                case '(': {
                    sb.append("\u207d");
                    continue block19;
                }
                case ')': {
                    sb.append("\u207e");
                    continue block19;
                }
                case 'n': {
                    sb.append("\u207f");
                    continue block19;
                }
                case '.': {
                    sb.append("\u00b7");
                    continue block19;
                }
                default: {
                    sb.append(" ");
                }
            }
        }
        sb.trimToSize();
        return sb.toString();
    }
}

