/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kcl.waterloo.actions.GJEventManager;
import kcl.waterloo.common.deploy.AbstractDeployableGraphics2D;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.math.ArrayMath;
import kcl.waterloo.math.geom.Ellipse;

public final class GJGraph
extends GJAbstractGraph {
    private transient Stroke minorGridStroke;
    private transient Stroke localAxisStroke;
    private final ArrayList<Path2D> v = new ArrayList();
    private final ArrayList<Path2D> h = new ArrayList();

    public GJGraph() {
        this(0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.2, 4, 0.2, 4);
    }

    private GJGraph(double originX, double originY, double xleft, double xright, double ybottom, double ytop, double majorX, int minorCountX, double majorY, int minorCountY) {
        this.originX = originX;
        this.originY = originY;
        this.xLeft = xleft;
        this.xRight = xright;
        this.yBottom = ybottom;
        this.yTop = ytop;
        this.setMajorXHint(majorX);
        this.setMinorCountXHint(minorCountX);
        this.setMajorYHint(majorY);
        this.setMinorCountYHint(minorCountY);
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        this.getMainFormatter().setMaximumFractionDigits(2);
        this.setCurrentLayer(this);
    }

    public static GJGraph createInstance() {
        GJGraph gr = new GJGraph();
        gr.setLeftAxisPainted((Boolean)GJDefaults.getMap().get("GJGraph.leftAxisPainted"));
        gr.setRightAxisPainted((Boolean)GJDefaults.getMap().get("GJGraph.rightAxisPainted"));
        gr.setTopAxisPainted((Boolean)GJDefaults.getMap().get("GJGraph.topAxisPainted"));
        gr.setBottomAxisPainted((Boolean)GJDefaults.getMap().get("GJGraph.bottomAxisPainted"));
        gr.setLeftAxisLabelled((Boolean)GJDefaults.getMap().get("GJGraph.leftAxisLabelled"));
        gr.setRightAxisLabelled((Boolean)GJDefaults.getMap().get("GJGraph.rightAxisLabelled"));
        gr.setTopAxisLabelled((Boolean)GJDefaults.getMap().get("GJGraph.topAxisLabelled"));
        gr.setBottomAxisLabelled((Boolean)GJDefaults.getMap().get("GJGraph.bottomAxisLabelled"));
        gr.addMouseListener(GJEventManager.getInstance());
        gr.addListeners();
        gr.addPropertyChangeListener(gr);
        return gr;
    }

    private void drawGrid(Graphics2D g2) {
        Stroke stroke = g2.getStroke();
        this.minorGridStroke = new BasicStroke(this.minorGridStrokeWeight);
        BasicStroke majorGridStroke = new BasicStroke(this.majorGridStrokeWeight);
        this.localAxisStroke = new BasicStroke(this.getAxisStrokeWeight());
        if (this.isMajorGridPainted() || this.isMinorGridPainted() || this.isInnerAxisPainted()) {
            if (this.isPolar()) {
                this.polarDrawVerticalGrid(g2);
                this.polarDrawHorizontalGrid(g2);
            } else {
                this.drawVerticalGrid(g2);
                this.drawHorizontalGrid(g2);
                g2.setStroke(this.minorGridStroke);
                g2.setPaint(this.getMinorGridColor());
                g2.setColor(this.getMinorGridColor());
                this.v.get(0).append(this.h.get(0), false);
                g2.draw(this.v.get(0));
                this.v.get(1).append(this.h.get(1), false);
                g2.setStroke(majorGridStroke);
                g2.setPaint(this.getMajorGridColor());
                g2.draw(this.v.get(1));
                this.v.get(2).append(this.h.get(2), false);
                g2.setPaint(this.getForeground());
                g2.setStroke(this.localAxisStroke);
                g2.draw(this.v.get(2));
            }
        }
        g2.setStroke(stroke);
    }

    private void drawLabels(Graphics2D g2) {
        if (this.isInnerAxisLabelled()) {
            g2.setPaint(this.getForeground());
            this.drawHorizontalAxisLabels(g2);
            this.drawVerticalAxisLabels(g2);
        }
    }

    private void drawVerticalAxisLabels(Graphics2D g2) {
        if (this.isInnerAxisLabelled()) {
            ArrayList<Double> it;
            double axisV = this.xPositionToPixel(this.getOriginX());
            if (this.isPolar()) {
                it = this.getPolarAxisLabels();
            } else {
                double startY = Math.floor(this.getYMin() / this.getMajorYHint()) * this.getMajorYHint();
                it = this.getYTransform().getAxisTickPositions(startY, this.getYMax() + this.getMajorYHint(), this.getMajorYHint());
            }
            for (Double s : it) {
                double y = s;
                if (y - this.getMajorYHint() / 2.0 < this.getOriginY() && y + this.getMajorYHint() / 2.0 > this.getOriginY()) continue;
                int position = (int)this.yPositionToPixel(y);
                String str = this.format(y);
                FontMetrics metrics = g2.getFontMetrics();
                Shape clip = g2.getClip();
                if (clip == null) {
                    return;
                }
                if (!clip.contains(axisV + 5.0, position - metrics.getMaxAscent() / 2) || !clip.contains(axisV + 5.0, position + metrics.getMaxAscent() / 2 + metrics.getMaxDescent())) continue;
                g2.drawString(str, (int)axisV + 5, position + metrics.getMaxAscent() / 2);
            }
        }
    }

    private void drawHorizontalGrid(Graphics2D g2) {
        double y;
        int position;
        double axisV = this.xPositionToPixel(this.getOriginX());
        Rectangle clip = g2.getClipBounds();
        if (clip == null) {
            return;
        }
        Path2D.Double path0 = new Path2D.Double();
        Path2D.Double path1 = new Path2D.Double();
        Path2D.Double path2 = new Path2D.Double();
        if (this.isInnerAxisPainted()) {
            g2.setStroke(this.localAxisStroke);
            g2.setPaint(this.getAxisColor());
            position = (int)this.xPositionToPixel(this.getOriginX());
            if (position >= clip.x && position <= clip.x + clip.width) {
                g2.setColor(this.getMajorGridColor());
                g2.drawLine(position, clip.y, position, clip.y + clip.height);
            }
        }
        double myh = this.getMajorYHint();
        double startY = Math.floor(this.getYMin() / myh) * myh;
        if (this.isMinorGridPainted()) {
            ArrayList<Double> MinorGrid = this.getYTransform().getMinorGridPositions(startY, this.getYMax() + myh, myh, this.getMinorCountYHint());
            for (Double s : MinorGrid) {
                y = s;
                position = (int)this.yPositionToPixel(y);
                if (position < clip.y || position > clip.y + clip.height) continue;
                ((Path2D)path0).moveTo(clip.x, position);
                ((Path2D)path0).lineTo(clip.x + clip.width, position);
            }
        }
        if (this.isMajorGridPainted() || this.isInnerAxisPainted()) {
            ArrayList<Double> MajorGrid = this.getYTransform().getAxisTickPositions(startY, this.getYMax() + myh, myh);
            for (Double s : MajorGrid) {
                y = s;
                position = (int)this.yPositionToPixel(y);
                if (position < clip.y || position > clip.y + clip.height) continue;
                if (this.isMajorGridPainted()) {
                    ((Path2D)path1).moveTo(clip.x, position);
                    ((Path2D)path1).lineTo(clip.x + clip.width, position);
                }
                if (!this.isInnerAxisPainted()) continue;
                ((Path2D)path2).moveTo(axisV - 3.0, position);
                ((Path2D)path2).lineTo(axisV + 3.0, position);
            }
        }
        this.h.clear();
        this.h.add(path0);
        this.h.add(path1);
        this.h.add(path2);
    }

    private void drawHorizontalAxisLabels(Graphics2D g2) {
        ArrayList<Double> it;
        double axisH = this.yPositionToPixel(this.getOriginY());
        FontMetrics metrics = g2.getFontMetrics();
        double mxh = this.getMajorXHint();
        if (this.isPolar()) {
            it = this.getPolarAxisLabels();
        } else {
            double startX = Math.floor(this.getXMin() / mxh) * mxh;
            it = this.getXTransform().getAxisTickPositions(startX, this.getXMax() + mxh, mxh);
        }
        for (Double s : it) {
            double x = s;
            if (x - mxh / 2.0 < this.getOriginX() && x + mxh / 2.0 > this.getOriginX()) continue;
            int position = (int)this.xPositionToPixel(x);
            String str = this.formatXAxisLabel(x);
            Shape clip = g2.getClip();
            if (clip == null) {
                return;
            }
            if (clip.contains(position -= metrics.stringWidth(str) / 2, axisH + (double)metrics.getHeight()) && clip.contains(position + metrics.stringWidth(str), axisH + (double)metrics.getHeight())) {
                g2.drawString(str, position, (int)axisH + metrics.getHeight());
                continue;
            }
            if (!clip.contains(position, axisH - (double)metrics.getHeight()) || !clip.contains(position + metrics.stringWidth(str), axisH - (double)(2 * metrics.getDescent()))) continue;
            g2.drawString(str, position, (int)axisH - 2 * metrics.getDescent());
        }
    }

    private void drawVerticalGrid(Graphics2D g2) {
        double x;
        int position;
        double axisH = this.yPositionToPixel(this.getOriginY());
        Rectangle clip = g2.getClipBounds();
        if (clip == null) {
            return;
        }
        Path2D.Double path0 = new Path2D.Double();
        Path2D.Double path1 = new Path2D.Double();
        Path2D.Double path2 = new Path2D.Double();
        if (this.isInnerAxisPainted()) {
            g2.setStroke(this.localAxisStroke);
            g2.setPaint(this.getAxisColor());
            position = (int)this.yPositionToPixel(this.getOriginY());
            if (position >= clip.y && position <= clip.y + clip.height) {
                g2.drawLine(clip.x, position, clip.x + clip.width, position);
            }
        }
        double mxh = this.getMajorXHint();
        double startX = Math.floor(this.getXMin() / mxh) * mxh;
        if (this.isMinorGridPainted()) {
            ArrayList<Double> MinorGrid = this.getXTransform().getMinorGridPositions(startX, this.getXMax() + mxh, mxh, this.getMinorCountXHint());
            for (Double s : MinorGrid) {
                x = s;
                position = (int)this.xPositionToPixel(x);
                if (position < clip.x || position > clip.x + clip.width) continue;
                ((Path2D)path0).moveTo(position, clip.y);
                ((Path2D)path0).lineTo(position, clip.y + clip.height);
            }
        }
        if (this.isMajorGridPainted() || this.isInnerAxisPainted()) {
            ArrayList<Double> MajorGrid = this.getXTransform().getAxisTickPositions(startX, this.getXMax() + mxh, mxh);
            for (Double s : MajorGrid) {
                x = s;
                position = (int)this.xPositionToPixel(x);
                if (position < clip.x || position > clip.x + clip.width) continue;
                if (this.isMajorGridPainted()) {
                    ((Path2D)path1).moveTo(position, clip.y);
                    ((Path2D)path1).lineTo(position, clip.y + clip.height);
                }
                if (!this.isInnerAxisPainted()) continue;
                ((Path2D)path2).moveTo(position, (int)axisH - 3);
                ((Path2D)path2).lineTo(position, (int)axisH + 3);
            }
        }
        this.v.clear();
        this.v.add(path0);
        this.v.add(path1);
        this.v.add(path2);
    }

    private void drawAxis(Graphics2D g2) {
        if (this.isPolar()) {
            this.polarDrawAxis(g2);
        }
        if (this.isInnerAxisPainted()) {
            double axisH = this.yPositionToPixel(this.getOriginY());
            double axisV = this.xPositionToPixel(this.getOriginX());
            Rectangle clip = g2.getClipBounds();
            if (clip == null) {
                return;
            }
            g2.setPaint(this.getForeground());
            Stroke stroke = g2.getStroke();
            g2.setStroke(this.localAxisStroke);
            if (axisH >= (double)clip.y && axisH <= (double)(clip.y + clip.height)) {
                g2.drawLine(clip.x, (int)axisH, clip.x + clip.width, (int)axisH);
            }
            if (axisV >= (double)clip.x && axisV <= (double)(clip.x + clip.width)) {
                g2.drawLine((int)axisV, clip.y, (int)axisV, clip.y + clip.height);
            }
            g2.setStroke(stroke);
        }
    }

    private void polarDrawVerticalGrid(Graphics2D g2) {
        if (this.isMajorGridPainted()) {
            Shape clip = g2.getClip();
            if (clip == null) {
                return;
            }
            g2.clip(new Ellipse2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
            ArrayList<Double> it = this.getPolarAxisLabels();
            g2.setStroke(this.minorGridStroke);
            g2.setPaint(this.getMinorGridColor());
            for (Double s : it) {
                int y;
                int x;
                double position = s;
                if (position < 0.0) {
                    x = (int)this.xPositionToPixel(position);
                    y = (int)this.yPositionToPixel(-position);
                } else {
                    x = (int)this.xPositionToPixel(-position);
                    y = (int)this.yPositionToPixel(position);
                }
                int w = (int)(this.xPositionToPixel(position) - (double)x);
                int h = (int)(this.yPositionToPixel(-position) - (double)y);
                g2.drawOval(x, y, w, h);
            }
            g2.setClip(clip);
        }
    }

    private ArrayList<Double> getPolarAxisLabels() {
        double factor = this.getMajorXHint() % 2.0 == 0.0 ? 2.0 : 1.0;
        double start = ArrayMath.min(new double[]{-this.getYMax(), this.getYMin(), -this.getXMax(), this.getXMin()}) + this.getMajorYHint() / factor;
        double stop = ArrayMath.max(new double[]{this.getYMax(), -this.getYMin(), this.getXMax(), -this.getXMin()}) + this.getMajorYHint() / factor;
        start = Math.floor(start / this.getMajorYHint() * this.getMajorYHint());
        stop = Math.ceil(stop / this.getMajorYHint() * this.getMajorYHint());
        if (Math.abs(start) > stop) {
            stop = Math.abs(start);
        }
        start = 0.0;
        ArrayList<Double> arr = this.getXTransform().getAxisTickPositions(start, stop, this.getMajorXHint() / factor);
        ArrayList<Double> arr2 = new ArrayList<Double>();
        arr2.addAll(arr);
        for (Double x : arr2) {
            arr.add(-x.doubleValue());
        }
        return arr;
    }

    private void polarDrawHorizontalGrid(Graphics2D g2) {
    }

    private void polarDrawAxis(Graphics2D g2) {
        Paint paint = g2.getPaint();
        g2.setPaint(this.getMajorGridColor());
        Stroke stroke = g2.getStroke();
        g2.setStroke(this.minorGridStroke);
        Shape clip = g2.getClip();
        if (clip == null) {
            return;
        }
        g2.clip(new Ellipse2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        for (double theta = 0.0; theta < Math.PI * 2; theta += 0.5235987755982988) {
            g2.drawLine((int)this.xPositionToPixel(0.0), (int)this.yPositionToPixel(0.0), (int)this.xPositionToPixel(Math.cos(theta) * (double)this.getWidth() / 2.0), (int)this.yPositionToPixel(Math.sin(theta) * (double)this.getHeight() / 2.0));
        }
        g2.setClip(clip);
        g2.setStroke(stroke);
        g2.setPaint(paint);
    }

    HashMap<Point2D, Map.Entry<String, Double>> getPolarRayLabels(Graphics2D g) {
        HashMap<Point2D, Map.Entry<String, Double>> map = new HashMap<Point2D, Map.Entry<String, Double>>();
        Ellipse2D.Double e0 = new Ellipse2D.Double(-5.0, -5.0, this.getWidth() + 10, this.getHeight() + 10);
        double x0 = this.xPositionToPixel(0.0);
        double y0 = this.yPositionToPixel(0.0);
        for (double theta = 0.0; theta < Math.PI * 2; theta += 0.5235987755982988) {
            String s = String.format("%3.0f\u00b0", theta * 180.0 / Math.PI);
            double x1 = this.xPositionToPixel(Math.cos(theta) * (double)this.getWidth() / 2.0);
            double y1 = this.yPositionToPixel(Math.sin(theta) * (double)this.getHeight() / 2.0);
            Point2D xy = Ellipse.intersections(e0, x0, y0, x1, y1);
            map.put(xy, new AbstractMap.SimpleEntry<String, Double>(s, theta));
        }
        return map;
    }

    @Override
    public void paint(Graphics g) {
        this.paintComponent(g);
        this.paintBorder(g);
    }

    @Override
    public final void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        if (g2 instanceof AbstractDeployableGraphics2D) {
            ((AbstractDeployableGraphics2D)g2).setPaintObject(this);
        }
        this.setupGraphics(g2);
        this.paintBackground(g2);
        if (g2 instanceof AbstractDeployableGraphics2D) {
            ((AbstractDeployableGraphics2D)g).addComment("Painting grid");
        }
        this.drawGrid(g2);
        this.drawAxis(g2);
        if (this.getPlots() != null) {
            this.drawPlots(g2);
        }
        this.drawLabels(g2);
        if (this.getCurrentROI() != null && this.getCurrentROI().getWidth() > 0.0) {
            g2.setPaint(new Color(245, 222, 179, 100));
            Rectangle2D.Double r = this.getCurrentROI();
            int x1 = (int)this.xPositionToPixel(((RectangularShape)r).getX());
            int y1 = (int)this.yPositionToPixel(((RectangularShape)r).getY());
            int w1 = (int)(((RectangularShape)r).getWidth() / this.getPixelWidth());
            int h1 = (int)(((RectangularShape)r).getHeight() / this.getPixelHeight());
            g2.fillRect(x1, y1, w1, h1);
            g2.setPaint(Color.DARK_GRAY);
            g2.drawRect(x1, y1, w1, h1);
        }
        if (this.getAvailableROI() != null) {
            for (Rectangle2D r : this.getAvailableROI()) {
                if (!(r.getWidth() > 0.0)) continue;
                g2.setPaint(new Color(0.0f, 1.0f, 1.0f, 0.3f));
                int x1 = (int)this.xPositionToPixel(r.getX());
                int y1 = (int)this.yPositionToPixel(r.getY());
                int w1 = (int)(r.getWidth() / this.getPixelWidth());
                int h1 = (int)(r.getHeight() / this.getPixelHeight());
                g2.fillRect(x1, y1, w1, h1);
                g2.setPaint(Color.BLACK);
                g2.drawRect(x1, y1, w1, h1);
            }
        }
        this.paintChildren(g2);
        g2.dispose();
    }

    public void paintGrid() {
        if (!this.isVisible()) {
            return;
        }
        Graphics g = this.getGraphics();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setClip(0, 0, this.getWidth(), this.getHeight());
        super.paintBackground(g2);
        super.paintComponent(g2);
        if (g2 instanceof AbstractDeployableGraphics2D) {
            ((AbstractDeployableGraphics2D)g).setPaintObject(this);
        }
        this.setupGraphics(g2);
        this.paintBackground(g2);
        if (g2 instanceof AbstractDeployableGraphics2D) {
            ((AbstractDeployableGraphics2D)g).addComment("Painting grid");
        }
        this.drawGrid(g2);
        this.drawAxis(g2);
    }

    @Override
    public GJBasicPanel.LocalTransferable getTransferable() {
        if (this.getGraphContainer() != null) {
            return this.getGraphContainer().getTransferable();
        }
        return super.getTransferable();
    }
}

