/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import kcl.waterloo.common.deploy.AbstractDeployableGraphics2D;
import kcl.waterloo.graphics.AxisLayout;
import kcl.waterloo.graphics.GJBasicPanel;
import kcl.waterloo.graphics.GJGraphInterface;
import org.jdesktop.swingx.JXLabel;

public final class GJAxisPanel
extends GJBasicPanel
implements PropertyChangeListener {
    private static final int minimumMargin = 30;
    private static final int interAxisSpace = 10;
    private JLabel label = new JXLabel("");
    private Position position;
    private int offset = 0;
    private int majorTickLength = 5;
    private boolean ticksOutward = false;
    private boolean tickLabelsPainted = false;
    private GJGraphInterface parentGraph = null;
    private Dimension dim = new Dimension();
    private double dynamicExtent = 20.0;
    private int extent;

    static GJAxisPanel createInstance(GJGraphInterface gr, Position pos) {
        GJAxisPanel ax = new GJAxisPanel(gr, pos);
        if (gr.getGraphContainer() != null) {
            gr.getGraphContainer().add(ax);
            ax.addMouseMotionListener(gr.getGraphContainer().getContainerMouseHandler());
            ax.addMouseListener(gr.getGraphContainer().getContainerMouseHandler());
        }
        return ax;
    }

    public GJAxisPanel() {
        super(true);
        this.setOpaque(true);
        this.setPreferredSize(this.dim);
        this.setLayout(new AxisLayout());
        this.add(this.label);
        this.label.setVisible(this.tickLabelsPainted);
        this.setLabelFont(this.getFont());
    }

    private GJAxisPanel(GJGraphInterface source, Position pos) {
        this();
        this.setForeground(((JComponent)((Object)source)).getForeground());
        this.setParentGraph(source);
        this.setPosition(pos);
    }

    public final void setParentGraph(GJGraphInterface source) {
        this.parentGraph = source;
    }

    public final GJGraphInterface getParentGraph() {
        return this.parentGraph;
    }

    public final void setPosition(Position pos) {
        this.position = pos;
        switch (pos) {
            case LEFT: {
                this.setTickLabelsPainted(true);
                this.setTextRotation(this.label, 4.71238898038469);
                this.dim = new Dimension(this.extent, Short.MAX_VALUE);
                break;
            }
            case RIGHT: {
                this.dim = new Dimension(this.extent, Short.MAX_VALUE);
                this.setTextRotation(this.label, 4.71238898038469);
                break;
            }
            case TOP: {
                this.dim = new Dimension(Short.MAX_VALUE, this.extent);
                break;
            }
            case BOTTOM: {
                this.setTickLabelsPainted(true);
                this.dim = new Dimension(Short.MAX_VALUE, this.extent);
                break;
            }
        }
    }

    private void setTextRotation(Object label, double theta) {
        try {
            Method m = label.getClass().getMethod("setTextRotation", Double.TYPE);
            try {
                m.invoke(label, theta);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public Position getPosition() {
        return this.position;
    }

    public Orientation getOrientation() {
        switch (this.position) {
            case LEFT: 
            case RIGHT: {
                return Orientation.Y;
            }
            case TOP: 
            case BOTTOM: {
                return Orientation.X;
            }
        }
        return Orientation.Z;
    }

    public final MouseAdapter getMouseHandler() {
        return this.parentGraph.getAxisMouseHandler();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public final void setLabelFont(Font f) {
        Font old = this.label.getFont();
        this.label.setFont(f);
        this.localValidate();
        this.firePropertyChange("Font", old, this.label.getFont());
    }

    public final void setText(String s) {
        if (this.label != null) {
            String old = this.label.getText();
            this.label.setText(s);
            this.localValidate();
            this.firePropertyChange("text", old, this.label.getText());
        }
    }

    public final String getText() {
        return this.label.getText();
    }

    public final void setTickLabelsPainted(boolean flag) {
        boolean old = this.tickLabelsPainted;
        if (flag) {
            if (this.label.getParent() != this) {
                this.add(this.label);
            }
        } else {
            this.remove(this.label);
        }
        this.tickLabelsPainted = flag;
        this.label.setVisible(flag);
        this.localValidate();
        this.firePropertyChange("tickLabelsPainted", old, this.tickLabelsPainted);
    }

    public final boolean isTickLabelsPainted() {
        return this.tickLabelsPainted;
    }

    public final JLabel getLabel() {
        return this.label;
    }

    public final void setLabel(JLabel lbl) {
        JLabel old = this.label;
        this.remove(this.label);
        this.label = lbl;
        this.add(this.label);
        this.setPosition(this.position);
        this.firePropertyChange("label", old, this.label);
    }

    @Override
    public final void revalidate() {
        if (EventQueue.isDispatchThread()) {
            if (this.getLayout() instanceof AxisLayout) {
                AxisLayout layout = (AxisLayout)this.getLayout();
                layout.localRevalidate(this);
            }
            super.revalidate();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GJAxisPanel.this.revalidate();
                }
            });
        }
    }

    private void localValidate() {
        if (this.getParent() != null) {
            this.getParent().validate();
        } else {
            super.validate();
        }
    }

    public final void setTitleRotation(double theta) {
        if (this.label != null) {
            this.setTextRotation(this.label, theta);
        }
    }

    public final void setTicksOutward(boolean flag) {
        this.ticksOutward = flag;
    }

    public final boolean getTicksOutward() {
        return this.ticksOutward;
    }

    public final void setMajorTickLength(int x) {
        this.majorTickLength = x;
    }

    public final int getMajorTickLength() {
        return this.majorTickLength;
    }

    public final void setMinorTickLength(int x) {
        this.majorTickLength = x;
    }

    public final int getMinorTickLength() {
        return this.majorTickLength;
    }

    final int getOffset() {
        return this.offset;
    }

    final void setOffset(int offset) {
        double old = this.offset;
        this.offset = offset;
        this.firePropertyChange("offset", old, (double)offset);
    }

    public final Dimension getDim() {
        return this.dim;
    }

    final int getExtent() {
        if (this.isTickLabelsPainted()) {
            return this.extent;
        }
        return 5;
    }

    final void setExtent(int extent) {
        this.extent = extent;
    }

    public static int getInterAxisSpace() {
        return 10;
    }

    public static int getMinimumMargin() {
        return 30;
    }

    public double getDynamicExtent() {
        return this.dynamicExtent;
    }

    public void setDynamicExtent(double dynamicExtent) {
        this.dynamicExtent = dynamicExtent;
    }

    final void draw(Graphics2D g2) {
        Paint p = g2.getPaint();
        g2.setPaint(this.getForeground());
        if (g2 instanceof AbstractDeployableGraphics2D) {
            ((AbstractDeployableGraphics2D)g2).setPaintObject(this);
        }
        this.paintBackground(g2);
        switch (this.position) {
            case LEFT: {
                this.drawVerticalAxisLeft(g2);
                break;
            }
            case BOTTOM: {
                this.drawHorizontalAxisBottom(g2);
                break;
            }
            case RIGHT: {
                this.drawVerticalAxisRight(g2);
                break;
            }
            case TOP: {
                this.drawHorizontalAxisTop(g2);
                break;
            }
        }
        g2.setPaint(p);
    }

    private void drawHorizontalAxisBottom(Graphics2D g2) {
        Path2D.Double ax = new Path2D.Double();
        FontMetrics metrics = g2.getFontMetrics();
        int tick = this.majorTickLength;
        if (!this.ticksOutward) {
            tick = -tick;
        }
        ((Path2D)ax).moveTo(this.getX(), this.getY());
        ((Path2D)ax).lineTo(this.getX() + this.getWidth(), this.getY());
        double thisMin = this.getParentGraph().getXMin();
        double thisMax = this.getParentGraph().getXMax();
        double startX = Math.floor(thisMin / this.getParentGraph().getMajorXHint()) * this.getParentGraph().getMajorXHint();
        ArrayList<Double> it = this.getParentGraph().getXTransform().getAxisTickPositions(startX, thisMax + this.getParentGraph().getMajorXHint(), this.getParentGraph().getMajorXHint());
        int y = this.getY();
        g2.setPaint(this.getParentGraph().getAxisColor());
        for (Double s : it) {
            double x2 = s;
            int xpixel = (int)this.getParentGraph().xPositionToPixel(x2);
            if (!(x2 >= thisMin) || !(x2 <= thisMax)) continue;
            Point point = SwingUtilities.convertPoint(this, xpixel, 0, this.getParentGraph().getGraphContainer());
            ((Path2D)ax).moveTo(point.getX(), y);
            ((Path2D)ax).lineTo(point.getX(), y + tick);
            if (!this.isTickLabelsPainted()) continue;
            String str = this.getParentGraph().formatXAxisLabel(x2);
            double pos = point.getX() - (double)metrics.stringWidth(str) / 2.0;
            if (this.getParentGraph().isCategorical(Orientation.X)) {
                AffineTransform af = g2.getTransform();
                double r = this.getParentGraph().getXAxisLabelRotation(x2);
                g2.rotate(r, pos + (double)metrics.stringWidth(str) / 2.0, y + 10);
                g2.drawString(str, (int)(pos - (double)metrics.stringWidth(str) / 2.0), y + 10);
                g2.setTransform(af);
                continue;
            }
            g2.drawString(str, (int)pos, y + metrics.getAscent() + this.majorTickLength);
        }
        g2.setPaint(this.getParentGraph().getAxisColor());
        g2.setStroke(new BasicStroke(this.getParentGraph().getAxisStrokeWeight()));
        g2.draw(ax);
    }

    private void drawHorizontalAxisTop(Graphics2D g2) {
        Path2D.Double ax = new Path2D.Double();
        FontMetrics metrics = g2.getFontMetrics();
        int tick = this.majorTickLength;
        if (this.ticksOutward) {
            tick = -tick;
        }
        ((Path2D)ax).moveTo(this.getX(), this.getY() + this.getHeight());
        ((Path2D)ax).lineTo(this.getX() + this.getWidth(), this.getY() + this.getHeight());
        double startX = Math.floor(this.getParentGraph().getXMin() / this.getParentGraph().getMajorXHint()) * this.getParentGraph().getMajorXHint();
        ArrayList<Double> it = this.getParentGraph().getXTransform().getAxisTickPositions(startX, this.getParentGraph().getXMax() + this.getParentGraph().getMajorXHint(), this.getParentGraph().getMajorXHint());
        int y = this.getY() + this.getHeight();
        g2.setPaint(this.getParentGraph().getAxisColor());
        for (Double s : it) {
            double x2 = s;
            int xpixel = (int)this.getParentGraph().xPositionToPixel(x2);
            if (!(x2 >= this.getParentGraph().getXMin()) || !(x2 <= this.getParentGraph().getXMax())) continue;
            Point point = SwingUtilities.convertPoint(this, xpixel, 0, this.getParentGraph().getGraphContainer());
            ((Path2D)ax).moveTo(point.getX(), y);
            ((Path2D)ax).lineTo(point.getX(), y + tick);
            if (!this.isTickLabelsPainted()) continue;
            String str = this.getParentGraph().formatXAxisLabel(x2);
            double pos = point.getX() - (double)metrics.stringWidth(str) / 2.0;
            if (this.getParentGraph().isCategorical(Orientation.X)) {
                AffineTransform af = g2.getTransform();
                double r = this.getParentGraph().getXAxisLabelRotation(x2);
                g2.rotate(r, pos + (double)metrics.stringWidth(str) / 2.0, y - 2);
                g2.drawString(str, (int)(pos + (double)metrics.stringWidth(str) / 2.0), y - 2);
                g2.setTransform(af);
                continue;
            }
            g2.drawString(str, (int)pos, y - metrics.getDescent() - this.majorTickLength);
        }
        g2.setPaint(this.getParentGraph().getAxisColor());
        g2.setStroke(new BasicStroke(this.getParentGraph().getAxisStrokeWeight()));
        g2.draw(ax);
    }

    private void drawVerticalAxisLeft(Graphics2D g2) {
        Path2D.Double ax = new Path2D.Double();
        FontMetrics metrics = g2.getFontMetrics();
        int tick = this.majorTickLength;
        if (this.ticksOutward) {
            tick = -tick;
        }
        ((Path2D)ax).moveTo(this.getX() + this.getWidth(), this.getY());
        ((Path2D)ax).lineTo(this.getX() + this.getWidth(), this.getY() + this.getHeight());
        double startY = Math.floor(this.getParentGraph().getYMin() / this.getParentGraph().getMajorYHint()) * this.getParentGraph().getMajorYHint();
        int x = this.getX() + this.getWidth();
        ArrayList<Double> it = this.getParentGraph().getYTransform().getAxisTickPositions(startY, this.getParentGraph().getYMax() + this.getParentGraph().getMajorYHint(), this.getParentGraph().getMajorYHint());
        g2.setPaint(this.getParentGraph().getAxisColor());
        for (Double s : it) {
            double y2 = s;
            int ypixel = (int)this.getParentGraph().yPositionToPixel(y2);
            if (!(y2 >= this.getParentGraph().getYMin()) || !(y2 <= this.getParentGraph().getYMax())) continue;
            Point point = SwingUtilities.convertPoint(this, 0, ypixel, this.getParentGraph().getGraphContainer());
            ((Path2D)ax).moveTo(x, point.getY());
            ((Path2D)ax).lineTo(x + tick, (int)point.getY());
            if (!this.isTickLabelsPainted()) continue;
            String str = this.getParentGraph().formatYAxisLabel(y2);
            double pos = point.getY() + (double)(2 * metrics.getDescent());
            g2.drawString(str, x - metrics.stringWidth(str) - this.majorTickLength, (int)pos);
        }
        g2.setPaint(this.getParentGraph().getAxisColor());
        g2.setStroke(new BasicStroke(this.getParentGraph().getAxisStrokeWeight()));
        g2.draw(ax);
    }

    private void drawVerticalAxisRight(Graphics2D g2) {
        Path2D.Double ax = new Path2D.Double();
        FontMetrics metrics = g2.getFontMetrics();
        int tick = this.majorTickLength;
        if (!this.ticksOutward) {
            tick = -tick;
        }
        ((Path2D)ax).moveTo(this.getX(), this.getY());
        ((Path2D)ax).lineTo(this.getX(), this.getY() + this.getHeight());
        double startY = Math.floor(this.getParentGraph().getYMin() / this.getParentGraph().getMajorYHint()) * this.getParentGraph().getMajorYHint();
        int x = this.getX();
        ArrayList<Double> it = this.getParentGraph().getYTransform().getAxisTickPositions(startY, this.getParentGraph().getYMax() + this.getParentGraph().getMajorYHint(), this.getParentGraph().getMajorYHint());
        g2.setPaint(this.getParentGraph().getAxisColor());
        for (Double s : it) {
            double y2 = s;
            int ypixel = (int)this.getParentGraph().yPositionToPixel(y2);
            if (!(y2 >= this.getParentGraph().getYMin()) || !(y2 <= this.getParentGraph().getYMax())) continue;
            Point point = SwingUtilities.convertPoint(this, 0, ypixel, this.getParentGraph().getGraphContainer());
            ((Path2D)ax).moveTo(x, point.getY());
            ((Path2D)ax).lineTo(x + tick, point.getY());
            if (!this.isTickLabelsPainted()) continue;
            String str = this.getParentGraph().formatYAxisLabel(y2);
            double pos = point.getY() + (double)(2 * metrics.getDescent());
            g2.drawString(str, x + this.majorTickLength, (int)pos);
        }
        g2.setPaint(this.getParentGraph().getAxisColor());
        g2.setStroke(new BasicStroke(this.getParentGraph().getAxisStrokeWeight()));
        g2.draw(ax);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
    }

    public static enum Orientation {
        X,
        Y,
        Z;

    }

    public static enum Position {
        RIGHT,
        TOP,
        LEFT,
        BOTTOM;

    }
}

