/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJContainerMouseHandler;
import kcl.waterloo.graphics.GJGraphInterface;

public final class GJAddedComponentMouseHandler
extends MouseAdapter {
    private Point swingPoint = null;
    private Component swingComponent = null;
    private Component clickedComponent = null;
    private Point2D xyCoord = null;
    private GJAbstractGraphContainer parentComponent;

    public final void setParentComponent(GJAbstractGraphContainer c) {
        this.parentComponent = c;
    }

    public final GJAbstractGraphContainer getParentComponent() {
        return this.parentComponent;
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        MouseAdapter m;
        Component old = this.getSwingComponent();
        this.setSwingPoint(e);
        if ((this.getSwingComponent() != null || old != null && !old.equals(this.swingComponent)) && (m = this.getComponentMouseAdapter(this.getSwingComponent())) != null) {
            MouseEvent e2 = this.convertEvent(e);
            m.mouseEntered(e2);
        }
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        MouseAdapter m;
        Component old = this.getSwingComponent();
        this.setSwingPoint(e);
        if (old != null && this.getSwingComponent() != null && !old.equals(this.swingComponent) && (m = this.getComponentMouseAdapter(old)) != null) {
            MouseEvent e2 = this.convertEvent(e);
            m.mouseExited(e2);
        }
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        MouseEvent e2;
        MouseAdapter m;
        Component old = this.getSwingComponent();
        this.setSwingPoint(e);
        if (old != null && this.getSwingComponent() != null && !old.equals(this.swingComponent)) {
            m = this.getComponentMouseAdapter(old);
            if (m != null) {
                e2 = this.convertEvent(e);
                m.mouseExited(e2);
            }
            if ((m = this.getComponentMouseAdapter(this.getSwingComponent())) != null) {
                e2 = this.convertEvent(e);
                m.mouseEntered(e2);
            }
        }
        if ((m = this.getComponentMouseAdapter()) != null) {
            e2 = this.convertEvent(e);
            m.mouseMoved(e2);
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        this.setSwingPoint(e);
        MouseAdapter m = this.getComponentMouseAdapter();
        if (m != null) {
            MouseEvent e2 = this.convertEvent(e);
            m.mousePressed(e2);
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        this.setSwingPoint(e);
        MouseAdapter m = this.getComponentMouseAdapter();
        if (m != null) {
            MouseEvent e2 = this.convertEvent(e);
            m.mouseReleased(e2);
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
        this.setSwingPoint(e);
        this.setClickedComponent(this.getSwingComponent());
        MouseAdapter m = this.getComponentMouseAdapter();
        if (m != null) {
            MouseEvent e2 = this.convertEvent(e);
            m.mouseClicked(e2);
        }
        GJContainerMouseHandler.setLastMouseClick(e);
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        this.setSwingPoint(e);
        MouseAdapter m = this.getComponentMouseAdapter();
        if (m != null) {
            MouseEvent e2 = this.convertEvent(e);
            m.mouseDragged(e2);
        }
    }

    private MouseEvent convertEvent(MouseEvent e) {
        MouseEvent e2 = SwingUtilities.convertMouseEvent((Component)e.getSource(), e, this.getParentComponent());
        e2.getPoint().setLocation(this.getSwingPoint());
        e2 = SwingUtilities.convertMouseEvent(this.getParentComponent(), e2, this.getSwingComponent());
        return e2;
    }

    private MouseAdapter getComponentMouseAdapter() {
        return this.getComponentMouseAdapter(this.getSwingComponent());
    }

    private MouseAdapter getComponentMouseAdapter(Component comp) {
        Method method;
        if (comp == null) {
            return null;
        }
        try {
            method = comp.getClass().getMethod("getMouseHandler", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        MouseAdapter m = null;
        if (method != null) {
            try {
                m = (MouseAdapter)method.invoke((Object)comp, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            catch (InvocationTargetException ex) {
                return null;
            }
        }
        return m;
    }

    Point getSwingPoint() {
        return this.swingPoint;
    }

    Component getSwingComponent() {
        return this.swingComponent;
    }

    Component getClickedComponent() {
        return this.clickedComponent;
    }

    Point2D getXYCoord() {
        return this.xyCoord;
    }

    void setSwingPoint(MouseEvent e) {
        Point p = !e.getSource().equals(this.parentComponent) ? SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.getParentComponent()) : e.getPoint();
        this.setSwingPoint(p);
    }

    void setSwingPoint(Point p) {
        this.swingPoint = (Point)this.getParentComponent().inverseTransform(p);
        if (this.swingPoint == null) {
            this.setSwingComponent(null);
            this.setXYCoord(null);
        } else {
            this.setSwingComponent(this.getParentComponent().findComponentAt(this.swingPoint));
            if (this.getSwingComponent() != null && this.getSwingComponent().getClass().getSuperclass().equals(GJAbstractGraph.class)) {
                this.setSwingComponent((Component)this.getParentComponent().getView().getCurrentLayer());
                this.getParentComponent().getView().setCurrentLayer(this.getParentComponent().getView().getCurrentLayer());
            }
            Point p2 = SwingUtilities.convertPoint(this.getParentComponent(), this.swingPoint, (Component)((Object)this.getParentComponent().getView()));
            this.setXYCoord(new Point2D.Double(((GJGraphInterface)this.getParentComponent().getView().getCurrentLayer()).xPixelToPosition(p2.getX()), ((GJGraphInterface)this.getParentComponent().getView().getCurrentLayer()).yPixelToPosition(p2.getY())));
        }
    }

    public void setSwingComponent(Component swingComponent) {
        this.swingComponent = swingComponent;
    }

    public void setClickedComponent(Component clickedComponent) {
        this.clickedComponent = clickedComponent;
    }

    public void setXYCoord(Point2D xyCoord) {
        this.xyCoord = xyCoord;
    }
}

