/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.SpringLayout;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJAbstractGraphContainer;
import kcl.waterloo.graphics.GJAxisPanel;
import kcl.waterloo.graphics.data.Category;

public class AxisLayout
extends SpringLayout {
    final void localRevalidate(GJAxisPanel panel) {
        int textOffset = (int)panel.getDynamicExtent() + 2;
        GJAbstractGraphContainer parent = (GJAbstractGraphContainer)panel.getParent();
        if (parent != null) {
            SpringLayout layout1 = (SpringLayout)parent.getLayout();
            SpringLayout layout2 = (SpringLayout)panel.getLayout();
            GJAbstractGraph thisView = (GJAbstractGraph)parent.getView();
            JLabel label = panel.getLabel();
            switch (panel.getPosition()) {
                case LEFT: {
                    if (label != null) {
                        panel.setExtent(textOffset + 2 + label.getWidth());
                        panel.setPreferredSize(new Dimension(panel.getExtent(), Short.MAX_VALUE));
                        layout1.putConstraint("East", (Component)panel, -panel.getOffset(), "West", (Component)thisView);
                        panel.setPreferredSize(new Dimension(panel.getExtent(), Short.MAX_VALUE));
                        layout1.putConstraint("North", (Component)panel, 0, "North", (Component)thisView);
                        layout1.putConstraint("South", (Component)panel, 0, "South", (Component)thisView);
                        layout2.putConstraint("North", (Component)label, panel.getHeight() / 2 - label.getHeight() / 2, "North", (Component)panel);
                        layout2.putConstraint("East", (Component)label, -textOffset, "East", (Component)panel);
                    }
                    this.revalidateAxisLeft(panel);
                    break;
                }
                case RIGHT: {
                    if (label != null) {
                        panel.setExtent(textOffset + 2 + label.getWidth());
                        layout1.putConstraint("West", (Component)panel, panel.getOffset(), "East", (Component)thisView);
                        panel.setPreferredSize(new Dimension(panel.getExtent(), Short.MAX_VALUE));
                        layout1.putConstraint("North", (Component)panel, 0, "North", (Component)thisView);
                        layout1.putConstraint("South", (Component)panel, 0, "South", (Component)thisView);
                        layout2.putConstraint("North", (Component)label, panel.getHeight() / 2 - label.getHeight() / 2, "North", (Component)panel);
                        layout2.putConstraint("East", (Component)label, 0, "East", (Component)panel);
                    }
                    this.revalidateAxisRight(panel);
                    break;
                }
                case BOTTOM: {
                    if (label != null) {
                        panel.setExtent((int)panel.getDynamicExtent() + label.getHeight() + 2);
                        layout1.putConstraint("North", (Component)panel, panel.getOffset(), "South", (Component)thisView);
                        panel.setPreferredSize(new Dimension(Short.MAX_VALUE, panel.getExtent()));
                        layout1.putConstraint("East", (Component)panel, 0, "East", (Component)thisView);
                        layout1.putConstraint("West", (Component)panel, 0, "West", (Component)thisView);
                        layout2.putConstraint("West", (Component)label, panel.getWidth() / 2 - label.getWidth() / 2, "West", (Component)panel);
                        layout2.putConstraint("South", (Component)label, 0, "South", (Component)panel);
                    }
                    this.revalidateAxisBottom(panel);
                    break;
                }
                case TOP: {
                    if (label != null) {
                        panel.setExtent((int)panel.getDynamicExtent() + label.getHeight() + 2);
                        layout1.putConstraint("South", (Component)panel, -panel.getOffset(), "North", (Component)thisView);
                        panel.setPreferredSize(new Dimension(Short.MAX_VALUE, panel.getExtent()));
                        layout1.putConstraint("East", (Component)panel, 0, "East", (Component)thisView);
                        layout1.putConstraint("West", (Component)panel, 0, "West", (Component)thisView);
                        layout2.putConstraint("West", (Component)label, panel.getWidth() / 2 - label.getWidth() / 2, "West", (Component)panel);
                        layout2.putConstraint("North", (Component)label, 0, "North", (Component)panel);
                    }
                    this.revalidateAxisTop(panel);
                    break;
                }
            }
        }
    }

    private void revalidateAxisTop(GJAxisPanel panel) {
        Graphics2D g2 = (Graphics2D)((Component)((Object)panel.getParentGraph())).getGraphics();
        if (!panel.isTickLabelsPainted()) {
            panel.setDynamicExtent(10.0);
        } else if (g2 != null) {
            FontMetrics metrics = g2.getFontMetrics();
            if (panel.getParentGraph().isCategorical(GJAxisPanel.Orientation.X)) {
                ArrayList<Category> labels = panel.getParentGraph().getCategoricalLabels(GJAxisPanel.Orientation.X);
                double len = 0.0;
                for (Category s : labels) {
                    if (!((double)metrics.stringWidth(s.getText()) > len)) continue;
                    len = metrics.stringWidth(s.getText());
                }
                panel.setDynamicExtent(len + (double)panel.getMajorTickLength());
            } else {
                panel.setDynamicExtent(metrics.getHeight() + panel.getMajorTickLength());
            }
        }
    }

    private void revalidateAxisLeft(GJAxisPanel panel) {
        if (!panel.isTickLabelsPainted()) {
            panel.setDynamicExtent(10.0);
        } else {
            Graphics2D g2 = (Graphics2D)((Component)((Object)panel.getParentGraph())).getGraphics();
            if (g2 != null) {
                FontMetrics metrics = g2.getFontMetrics();
                panel.setDynamicExtent(Double.NEGATIVE_INFINITY);
                double startY = Math.floor(panel.getParentGraph().getYMin() / panel.getParentGraph().getMajorYHint()) * panel.getParentGraph().getMajorYHint();
                ArrayList<Double> it = panel.getParentGraph().getYTransform().getAxisTickPositions(startY, panel.getParentGraph().getYMax() + panel.getParentGraph().getMajorYHint(), panel.getParentGraph().getMajorYHint());
                for (Double s : it) {
                    double y2 = s;
                    if (!(y2 >= panel.getParentGraph().getYMin()) || !(y2 <= panel.getParentGraph().getYMax())) continue;
                    String str = panel.getParentGraph().formatYAxisLabel(y2);
                    panel.setDynamicExtent(Math.max((double)(metrics.stringWidth(str) + panel.getMajorTickLength()), panel.getDynamicExtent()));
                }
            }
        }
    }

    private void revalidateAxisRight(GJAxisPanel panel) {
        if (!panel.isTickLabelsPainted()) {
            panel.setDynamicExtent(10.0);
        } else {
            Graphics2D g2 = (Graphics2D)((Component)((Object)panel.getParentGraph())).getGraphics();
            if (g2 != null) {
                FontMetrics metrics = g2.getFontMetrics();
                panel.setDynamicExtent(Double.NEGATIVE_INFINITY);
                double startY = Math.floor(panel.getParentGraph().getYMin() / panel.getParentGraph().getMajorYHint()) * panel.getParentGraph().getMajorYHint();
                ArrayList<Double> it = panel.getParentGraph().getYTransform().getAxisTickPositions(startY, panel.getParentGraph().getYMax() + panel.getParentGraph().getMajorYHint(), panel.getParentGraph().getMajorYHint());
                for (Double s : it) {
                    double y2 = s;
                    if (!(y2 >= panel.getParentGraph().getYMin()) || !(y2 <= panel.getParentGraph().getYMax())) continue;
                    String str = panel.getParentGraph().formatYAxisLabel(y2);
                    panel.setDynamicExtent(Math.max((double)(metrics.stringWidth(str) + panel.getMajorTickLength()), panel.getDynamicExtent()));
                }
            }
        }
    }

    private void revalidateAxisBottom(GJAxisPanel panel) {
        Graphics2D g2 = (Graphics2D)((Component)((Object)panel.getParentGraph())).getGraphics();
        if (!panel.isTickLabelsPainted()) {
            panel.setDynamicExtent(10.0);
        } else if (g2 != null) {
            FontMetrics metrics = g2.getFontMetrics();
            if (panel.getParentGraph().isCategorical(GJAxisPanel.Orientation.X)) {
                ArrayList<Category> labels = panel.getParentGraph().getCategoricalLabels(GJAxisPanel.Orientation.X);
                double len = 0.0;
                for (Category s : labels) {
                    if (!((double)metrics.stringWidth(s.getText()) > len)) continue;
                    len = metrics.stringWidth(s.getText());
                }
                panel.setDynamicExtent(len + (double)panel.getMajorTickLength());
            } else {
                panel.setDynamicExtent(metrics.getHeight() + panel.getMajorTickLength());
            }
        }
    }
}

