/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.deploy.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import kcl.waterloo.common.deploy.AbstractDeployableGraphics2D;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.Element;

public class WSVGGraphics2D
extends AbstractDeployableGraphics2D {
    String svgNS = "http://www.w3.org/2000/svg";
    private Element lastAddedElement;
    private String title = "Title";
    private String description = "Description:";

    public WSVGGraphics2D(SVGGraphics2D g) {
        super((Graphics2D)g);
    }

    @Override
    public void append(Component c, int elapsedTime) {
    }

    @Override
    public void append(Component c) {
    }

    @Override
    public void setPaintObject(Object referenceObject) {
        Element element = ((SVGGraphics2D)this.parentGraphics).getDOMFactory().createElementNS(this.svgNS, "g");
        element.setAttribute("id", String.format("id%x_%x", (int)(System.currentTimeMillis() - this.startTime), referenceObject.hashCode()));
        element.setAttribute("class", String.format("%s", referenceObject.getClass().toString()));
        Element desc = ((SVGGraphics2D)this.parentGraphics).getDOMFactory().createElementNS(this.svgNS, "desc");
        desc.setTextContent("wgraphic");
        element.appendChild(desc);
        if (this.lastAddedElement == null) {
            ((SVGGraphics2D)this.parentGraphics).getDOMTreeManager().appendGroup(element, null);
            this.lastAddedElement = element;
        } else {
            this.lastAddedElement.appendChild(element);
            ((SVGGraphics2D)this.parentGraphics).getDOMTreeManager().appendGroup(element, null);
            this.lastAddedElement = element;
        }
    }

    @Override
    public void addComment(String comment) {
        ((SVGGraphics2D)this.parentGraphics).getDOMFactory().createComment(comment);
    }

    @Override
    public void prependCode(String code) {
    }

    @Override
    public void addCode(String code) {
    }

    @Override
    public void appendCode(String code) {
    }

    @Override
    public boolean copyImage(Image img, int dx, int dy, int sx, int sy, int width, int height, Color bgcolor, ImageObserver observer) {
        return true;
    }

    public Object clone() {
        WSVGGraphics2D g = new WSVGGraphics2D((SVGGraphics2D)this.parentGraphics.create());
        g.startTime = this.startTime;
        g.lastAddedElement = this.lastAddedElement;
        return g;
    }

    @Override
    public Graphics create() {
        return (Graphics)this.clone();
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        WSVGGraphics2D g = new WSVGGraphics2D((SVGGraphics2D)this.parentGraphics.create(x, y, width, height));
        g.startTime = this.startTime;
        g.lastAddedElement = this.lastAddedElement;
        return g;
    }

    public static void deploy(File f, String svgCode, Dimension dim, boolean inline, String jsLoc, String cssLoc, boolean httpdFlag) throws IOException {
        WSVGGraphics2D.deploy(f, svgCode, dim, inline, jsLoc, cssLoc, httpdFlag, null, "Title", "Description");
    }

    public static void deploy(File f, String svgCode, Dimension dim, boolean inline, String jsLoc, String cssLoc, boolean httpdFlag, ArrayList<String> keyWords, String title, String description) throws IOException {
        InputStream css;
        int n;
        byte[] buffer;
        byte[] buffer2;
        if (!f.getName().endsWith(".svg") && !f.getName().endsWith(".svg.gz")) {
            throw new IOException("Not an svg file");
        }
        File folder = new File(f.getPath().replace(".svg", ""));
        if (!folder.isDirectory()) {
            folder.mkdir();
        }
        if (jsLoc.equals("canvg-min.js") || jsLoc.equals("./canvg-min.js")) {
            int n2;
            InputStream js = AbstractDeployableGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/common/deploy/canvg/canvg-min.js");
            FileOutputStream output = new FileOutputStream(folder.getPath().concat(File.separator).concat("canvg-min.js"));
            while (js.available() > 0) {
                buffer2 = new byte[js.available()];
                n2 = js.read(buffer2, 0, js.available());
                output.write(buffer2, 0, n2);
            }
            output.close();
            js.close();
            js = AbstractDeployableGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/common/deploy/canvg/rgbcolor-min.js");
            output = new FileOutputStream(folder.getPath().concat(File.separator).concat("rgbcolor-min.js"));
            while (js.available() > 0) {
                buffer2 = new byte[js.available()];
                n2 = js.read(buffer2, 0, js.available());
                output.write(buffer2, 0, n2);
            }
            output.close();
            js.close();
            InputStream lic = AbstractDeployableGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/common/deploy/canvg/MIT-LICENSE.txt");
            FileOutputStream output2 = new FileOutputStream(folder.getPath().concat(File.separator).concat("CANVG-LICENSE.TXT"));
            while (lic.available() > 0) {
                buffer = new byte[lic.available()];
                n = lic.read(buffer, 0, lic.available());
                output2.write(buffer, 0, n);
            }
            output2.close();
            lic.close();
        }
        Formatter cssFormatter = new Formatter(new StringBuilder(512));
        if (cssLoc.equals("WSVGGraphics2D.css") || cssLoc.equals("./WSVGGraphics2D.css")) {
            css = WSVGGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/svg/WSVGGraphics2D.css");
            FileOutputStream cssFile = new FileOutputStream(folder.getPath().concat(File.separator).concat("WSVGGraphics2D.css"));
            OutputStreamWriter cssStream = new OutputStreamWriter((OutputStream)cssFile, "UTF-8");
            while (css.available() > 0) {
                buffer = new byte[css.available()];
                n = css.read(buffer, 0, css.available());
                String s = new String(buffer);
                s = s.replaceAll("1111111111", Integer.valueOf(dim.width).toString());
                s = s.replaceAll("2222222222", Integer.valueOf(dim.height).toString());
                cssFile.write(s.getBytes("UTF-8"));
            }
            css.close();
            cssFile.close();
            cssStream.close();
        } else if (cssLoc.equals("index.html") || cssLoc.equals("./index.html")) {
            css = WSVGGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/svg/WSVGGraphics2D.css");
            while (css.available() > 0) {
                buffer2 = new byte[css.available()];
                int n3 = css.read(buffer2, 0, css.available());
                cssFormatter.format("%s", new String(buffer2, 0, n3));
            }
        }
        if (httpdFlag) {
            InputStream py = WSVGGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/svg/httpd.py");
            FileOutputStream output = new FileOutputStream(folder.getPath().concat(File.separator).concat("httpd.py"));
            while (py.available() > 0) {
                byte[] buffer3 = new byte[py.available()];
                int n4 = py.read(buffer3, 0, py.available());
                output.write(buffer3, 0, n4);
            }
            output.close();
        }
        Formatter keyWordString = new Formatter(new StringBuilder(512));
        keyWordString.format("<meta name=\"keywords\" content=\"Waterloo, WSVGGraphics2D, ", new Object[0]);
        if (keyWords != null) {
            Iterator<String> it = keyWords.iterator();
            while (it.hasNext()) {
                String word = it.next();
                if (it.hasNext()) {
                    keyWordString.format("%s, ", word);
                    continue;
                }
                keyWordString.format("%s", word);
            }
        }
        keyWordString.format("\">%n", new Object[0]);
        String userHTML = "";
        InputStream index = !userHTML.isEmpty() && new File(userHTML).isFile() ? new FileInputStream(new File(userHTML)) : WSVGGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/svg/index.html");
        FileOutputStream indexFile = new FileOutputStream(folder.getPath().concat(File.separator).concat("index.html"));
        OutputStreamWriter indexStream = new OutputStreamWriter((OutputStream)indexFile, "UTF-8");
        while (index.available() > 0) {
            byte[] buffer4 = new byte[index.available()];
            int n5 = index.read(buffer4, 0, index.available());
            String s = new String(buffer4);
            if (s.contains("<!-- CODE -->")) {
                if (inline) {
                    int i = svgCode.indexOf("<svg xmlns:xlink=");
                    String code = svgCode.substring(i);
                    s = s.replace("<!-- CODE -->", String.format("<div id=\"%s\">%n%s</div>", f.getName().replace(".svg", ""), code));
                } else {
                    s = jsLoc.isEmpty() ? s.replace("<!-- CODE -->", String.format("<object id=\"%s\" data=\"%s\" type=\"image/svg+xml\"></object>", f.getName().replace(".svg", ""), f.getName())) : s.replace("<!-- CODE -->", String.format("<canvas id=\"%s\"></canvas>", f.getName().replace(".svg", "")));
                }
            }
            if (s.contains("<!-- KEYWORDS -->")) {
                s = s.replace("<!-- KEYWORDS -->", keyWordString.toString());
            }
            if (s.contains("cccccccccc")) {
                s = s.replaceAll("cccccccccc", "./" + f.getName());
            }
            if (s.contains("ididididid")) {
                s = s.replaceAll("ididididid", f.getName().replace(".svg", ""));
            }
            if (s.contains("<!-- TITLE -->")) {
                s = s.replace("<!-- TITLE -->", title);
            }
            if (s.contains("<!-- DESCRIPTION -->")) {
                s = s.replace("<!-- DESCRIPTION -->", description);
            }
            if (s.contains("tttttttttt")) {
                s = s.replaceAll("tttttttttt", String.format("%s", title));
            }
            if (s.contains("dddddddddd")) {
                s = s.replaceAll("dddddddddd", String.format("%s", description));
            }
            if (s.contains("canvgcanvg")) {
                s = s.replaceAll("canvgcanvg", jsLoc);
            }
            if (s.contains("rgbrgbrgb")) {
                s = s.replaceAll("rgbrgbrgb", jsLoc.replace("canvg-min.js", "rgbcolor-min.js"));
            }
            if (s.contains("1111111111")) {
                s = s.replaceAll("1111111111", Integer.valueOf(dim.width).toString());
            }
            if (s.contains("2222222222")) {
                s = s.replaceAll("2222222222", Integer.valueOf(dim.height).toString());
            }
            if (cssLoc.equals("index.html") || cssLoc.equals("./index.html")) {
                String cssText = cssFormatter.toString();
                cssText = cssText.replaceAll("1111111111", Integer.valueOf(dim.width).toString());
                cssText = cssText.replaceAll("2222222222", Integer.valueOf(dim.height).toString());
                s = s.replace("<!-- optional styling -->", String.format("<style type=\"text/css\">%n%s%n</style>", cssText));
            } else {
                s = s.replace("<!-- optional styling -->", String.format("<link href=\"%s\" rel=\"stylesheet\" type=\"text/css\">", cssLoc));
            }
            indexFile.write(s.getBytes("UTF-8"));
        }
        index.close();
        indexFile.close();
        indexStream.close();
        if (!inline) {
            File f2 = new File(folder.getPath().concat(File.separator).concat(f.getName()));
            if (f2.getName().endsWith(".svg")) {
                OutputStreamWriter outSVG = new OutputStreamWriter((OutputStream)new FileOutputStream(f2), "UTF-8");
                outSVG.write(svgCode);
                outSVG.close();
            } else if (f2.getName().endsWith(".svg.gz")) {
                GZIPOutputStream outSVG = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(f2)));
                outSVG.write(svgCode.getBytes());
                outSVG.close();
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

