/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.deploy.pde;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.image.renderable.RenderableImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kcl.waterloo.common.deploy.AbstractDeployableGraphics2D;
import kcl.waterloo.logging.CommonLogger;

public class PDEGraphics2D
extends AbstractDeployableGraphics2D
implements Cloneable {
    private boolean textAsShapes = false;
    private static final BasicStroke glyphStroke = new BasicStroke(0.5f);
    private float strokeLineWidth = -1.0f;
    private int strokeEndCap = -1;
    private int strokeJoin = -1;
    private ArrayList<String> customShapes = new ArrayList();
    private LinkedHashMap<String, Integer> code = new LinkedHashMap();
    private Dimension dimension;
    private LinkedHashMap<Integer, ImageIcon> images = new LinkedHashMap();
    private LinkedHashMap<Integer, Rectangle2D> imageDim = new LinkedHashMap();
    private Font baseFont = null;
    private LinkedHashMap<String, Font> fontList = new LinkedHashMap();
    String prependedCode = "";
    String appendedCode = "";
    private ArrayList<String> keyWords = new ArrayList();
    private String title = "Title";
    private String description = "Description:";
    private static String userHTML = "";
    public static final int aquaJButton = 1;
    public static final int aquaFixes = 1;
    private int lfFixes = UIManager.getLookAndFeel().getName().contains("Mac") ? 1 : 0;
    private boolean verbose = true;
    private static String colorString = null;
    private static final CommonLogger logger = new CommonLogger(PDEGraphics2D.class);

    private PDEGraphics2D(Graphics2D g) {
        super(g);
    }

    public PDEGraphics2D(Graphics2D g, int w, int h) {
        this(g, new Dimension(w, h));
    }

    public PDEGraphics2D(Graphics2D g, Dimension d) {
        super(g);
        this.pictures.add(0, new Formatter(new StringBuilder(1024)));
        this.initialise(d);
    }

    private void initialise(Dimension d) {
        if (this.parentGraphics != null && this.getFont() != null) {
            this.baseFont = this.getFont();
            this.fontList.put(this.getFont().getName(), this.getFont());
        }
        this.dimension = d;
    }

    public static PDEGraphics2D paint(Component c) {
        PDEGraphics2D g = new PDEGraphics2D((Graphics2D)c.getGraphics(), c.getSize());
        c.paint(g);
        return g;
    }

    public static PDEGraphics2D paint(JComponent c) {
        PDEGraphics2D g = new PDEGraphics2D((Graphics2D)c.getGraphics(), c.getSize());
        c.paint(g);
        return g;
    }

    public static PDEGraphics2D paint(Window c) {
        PDEGraphics2D g = new PDEGraphics2D((Graphics2D)c.getGraphics(), c.getSize());
        c.paint(g);
        return g;
    }

    public static PDEGraphics2D paint(JApplet c) {
        PDEGraphics2D g = new PDEGraphics2D((Graphics2D)c.getGraphics(), c.getSize());
        c.paint(g);
        return g;
    }

    public int getLFFixes() {
        return this.lfFixes;
    }

    public ArrayList<String> getKeyWords() {
        return new ArrayList<String>(this.keyWords);
    }

    public void setKeyWords(ArrayList<String> keyWords) {
        this.keyWords = keyWords;
    }

    public void addKeyWord(String word) {
        this.keyWords.add(word);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isTextAsShapes() {
        return this.textAsShapes;
    }

    public void setTextAsShapes(boolean textAsShapes) {
        this.textAsShapes = textAsShapes;
    }

    @Override
    public Graphics create() {
        return (Graphics)this.clone();
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        PDEGraphics2D g = new PDEGraphics2D((Graphics2D)this.parentGraphics.create(x, y, width, height));
        g.customShapes = this.customShapes;
        g.pictures = this.pictures;
        g.setTextAsShapes(this.isTextAsShapes());
        g.images = this.images;
        g.imageDim = this.imageDim;
        g.dimension = this.dimension;
        g.lfFixes = this.lfFixes;
        g.fontList = this.fontList;
        g.code = this.code;
        g.strokeEndCap = this.strokeEndCap;
        g.strokeJoin = this.strokeJoin;
        g.strokeLineWidth = this.strokeLineWidth;
        g.parentGraphics.setColor(this.getColor());
        return g;
    }

    @Override
    public void append(Component c, int elapsedTime) {
        this.pictures.add(new Formatter(new StringBuilder(1024)));
        this.latency.add(elapsedTime);
        c.paint(this);
    }

    @Override
    public void append(Component c) {
        this.append(c, (int)(System.currentTimeMillis() - this.startTime));
    }

    @Override
    public void write(String fileName) throws IOException {
        this.write(fileName, true, "./processing.js", "./PDEGraphics2D.css", true);
    }

    public void write(String fileName, boolean htmlFlag) throws IOException {
        this.write(fileName, htmlFlag, "./processing.js", "./PDEGraphics2D.css", true);
    }

    public void write(String fileName, boolean htmlFlag, String jsLoc) throws IOException {
        this.write(fileName, htmlFlag, jsLoc, "./PDEGraphics2D.css", true);
    }

    public void write(String fileName, boolean htmlFlag, String jsLoc, String cssLoc, boolean httpdFlag) throws IOException {
        if (!fileName.endsWith(".pde")) {
            fileName = fileName.concat(".pde");
        }
        File f = new File(fileName);
        String path = f.toURI().getPath().replace(f.getName(), "");
        String pdeFile = path.concat(f.getName().replace(".pde", File.separator));
        pdeFile = pdeFile.concat(f.getName());
        this.write(new File(pdeFile), htmlFlag, jsLoc, cssLoc, httpdFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f, boolean htmlFlag, String jsLoc, String cssLoc, boolean httpdFlag) throws IOException {
        String f2;
        if (!f.getName().endsWith(".pde")) {
            throw new IOException("Not a pde file");
        }
        File folder = f.getParentFile() != null && f.getParentFile().toString().endsWith(f.getName().replace(".pde", "")) ? new File(f.getParentFile().toString()) : new File(f.getPath().replace(f.getName(), ""));
        if (!folder.isDirectory()) {
            folder.mkdir();
        }
        if (!(f2 = folder.getPath().concat(File.separator).concat(f.getName())).endsWith(".pde")) {
            f2 = f2.concat(".pde");
        }
        super.write(f2);
        if (this.images.size() > 0) {
            InputStream image_lic = PDEGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/NOTICE.TXT");
            try (FileOutputStream output3 = new FileOutputStream(folder.getPath().concat(File.separator).concat("NOTICE.TXT"));){
                while (image_lic.available() > 0) {
                    byte[] buffer = new byte[image_lic.available()];
                    int n = image_lic.read(buffer, 0, image_lic.available());
                    output3.write(buffer, 0, n);
                }
            }
            image_lic.close();
            File dataFolder = new File(folder.getPath().concat(File.separator).concat("data"));
            if (!dataFolder.isDirectory()) {
                dataFolder.mkdir();
            }
            for (Integer k : this.images.keySet()) {
                ImageIcon icon = this.images.get(k);
                Image img = icon.getImage();
                String name = String.format("image_%d_%x.png", k, icon.hashCode());
                File fi = new File(dataFolder.toString() + File.separator + name);
                if (icon.getImageLoadStatus() == 8) {
                    if (img instanceof RenderedImage) {
                        ImageIO.write((RenderedImage)((Object)img), "png", fi);
                        continue;
                    }
                    if (img instanceof VolatileImage) {
                        ImageIO.write((RenderedImage)((VolatileImage)img).getSnapshot(), "png", fi);
                        continue;
                    }
                    try {
                        BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight());
                        icon.paintIcon(null, buffer.createGraphics(), 0, 0);
                        ImageIO.write((RenderedImage)buffer, "png", fi);
                    }
                    catch (IOException ex) {
                        logger.error(String.format("Image format not supported yet: %s%n", img.getClass().toString()));
                    }
                    continue;
                }
                logger.error(String.format("Image not complete: %s [%s]%n", name, img.getClass().toString()));
            }
            File xml = new File(dataFolder.toString() + File.separator + "image.xml");
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(xml), "UTF-8");){
                out.write("<?xml version=\"1.0\"?>%n<images>%n");
                for (Integer k : this.images.keySet()) {
                    ImageIcon icon = this.images.get(k);
                    Rectangle2D r = this.imageDim.get(k);
                    out.write(String.format("<image id=\"%d\" hashCode=\"%x\" x=\"%g\" y=\"%g\" width=\"%g\" height=\"%g\"> </image>%n", k, icon.hashCode(), r.getX(), r.getY(), r.getWidth(), r.getHeight()));
                }
            }
        }
        if (htmlFlag) {
            String s;
            InputStream css;
            byte[] buffer;
            byte[] buffer2;
            FileOutputStream output;
            Formatter fileFormatter = new Formatter(new StringBuilder(1024));
            fileFormatter.format("<!DOCTYPE html>%n", new Object[0]);
            fileFormatter.format("<head>%n", new Object[0]);
            fileFormatter.format("<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />%n", new Object[0]);
            fileFormatter.format("<title>%s</title>%n", this.title);
            fileFormatter.format("<!--Please leave the PDEGraphics2D keyword in place - they can be indexed by search engines and assist furture development -->%n", new Object[0]);
            Formatter keyWordString = new Formatter(new StringBuilder(512));
            keyWordString.format("<meta name=\"keywords\" content=\"PDEGraphics2D, ", new Object[0]);
            Iterator<String> it = this.keyWords.iterator();
            while (it.hasNext()) {
                String word = it.next();
                if (it.hasNext()) {
                    keyWordString.format("%s, ", word);
                    continue;
                }
                keyWordString.format("%s", word);
            }
            keyWordString.format("\">%n", new Object[0]);
            fileFormatter.format("%s", keyWordString.toString());
            fileFormatter.format("<script src=\"%s\" type=\"text/javascript\"></script>%n", jsLoc);
            fileFormatter.format("</head>%n", new Object[0]);
            fileFormatter.format("<body>%n<div>%n", new Object[0]);
            fileFormatter.format("<!--%n", new Object[0]);
            fileFormatter.format("%s%n", this.description);
            fileFormatter.format("-->%n", new Object[0]);
            fileFormatter.format("<canvas id=\"%s\" data-processing-sources=\"%s\" width=\"%d\" height=\"%d\">%n<p>%nYour browser does not support the canvas tag.%n</p>%n", f.getName().replace(".pde", ""), f.getName(), (int)this.dimension.getWidth(), (int)this.dimension.getHeight());
            fileFormatter.format("</canvas>%n", new Object[0]);
            fileFormatter.format("</div>%n", new Object[0]);
            fileFormatter.format("</body>%n", new Object[0]);
            fileFormatter.format("</html>%n", new Object[0]);
            File html = new File(folder.getPath().concat(File.separator).concat(f.getName().replace(".pde", ".html")));
            OutputStreamWriter outHTML = new OutputStreamWriter((OutputStream)new FileOutputStream(html), "UTF-8");
            outHTML.write(fileFormatter.toString());
            outHTML.close();
            if (jsLoc.equals("processing.js") || jsLoc.equals("./processing.js")) {
                InputStream js = PDEGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/pde/processing-1.4.1.min.js");
                output = new FileOutputStream(folder.getPath().concat(File.separator).concat("processing.js"));
                while (js.available() > 0) {
                    buffer2 = new byte[js.available()];
                    int n = js.read(buffer2, 0, js.available());
                    output.write(buffer2, 0, n);
                }
                output.close();
                js.close();
                InputStream lic = PDEGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/pde/PROCESSING-JS-LICENSE");
                FileOutputStream output2 = new FileOutputStream(folder.getPath().concat(File.separator).concat("PROCESSINGJS-LICENSE.TXT"));
                while (lic.available() > 0) {
                    buffer = new byte[lic.available()];
                    int n = lic.read(buffer, 0, lic.available());
                    output2.write(buffer, 0, n);
                }
                output2.close();
                lic.close();
            }
            if (httpdFlag) {
                InputStream py = PDEGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/pde/httpd.py");
                output = new FileOutputStream(folder.getPath().concat(File.separator).concat("httpd.py"));
                while (py.available() > 0) {
                    buffer2 = new byte[py.available()];
                    int n = py.read(buffer2, 0, py.available());
                    output.write(buffer2, 0, n);
                }
                output.close();
            }
            Formatter cssFormatter = new Formatter(new StringBuilder(512));
            if (cssLoc.equals("PDEGraphics2D.css") || cssLoc.equals("./PDEGraphics2D.css")) {
                css = PDEGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/pde/PDEGraphics2D.css");
                FileOutputStream cssFile = new FileOutputStream(folder.getPath().concat(File.separator).concat("PDEGraphics2D.css"));
                OutputStreamWriter cssStream = new OutputStreamWriter((OutputStream)cssFile, "UTF-8");
                while (css.available() > 0) {
                    buffer = new byte[css.available()];
                    int n = css.read(buffer, 0, css.available());
                    s = new String(buffer);
                    s = s.replaceAll("1111111111", Integer.valueOf(this.dimension.width).toString());
                    s = s.replaceAll("2222222222", Integer.valueOf(this.dimension.height).toString());
                    cssFile.write(s.getBytes("UTF-8"));
                }
                css.close();
                cssFile.close();
                cssStream.close();
            } else if (cssLoc.equals("index.html") || cssLoc.equals("./index.html")) {
                css = PDEGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/pde/PDEGraphics2D.css");
                while (css.available() > 0) {
                    buffer2 = new byte[css.available()];
                    int n = css.read(buffer2, 0, css.available());
                    cssFormatter.format("%s", new String(buffer2, 0, n));
                }
            }
            InputStream index = !userHTML.isEmpty() && new File(userHTML).isFile() ? new FileInputStream(new File(userHTML)) : PDEGraphics2D.class.getClassLoader().getResourceAsStream("kcl/waterloo/deploy/pde/index.html");
            FileOutputStream indexFile = new FileOutputStream(folder.getPath().concat(File.separator).concat("index.html"));
            OutputStreamWriter indexStream = new OutputStreamWriter((OutputStream)indexFile, "UTF-8");
            while (index.available() > 0) {
                buffer = new byte[index.available()];
                int n = index.read(buffer, 0, index.available());
                s = new String(buffer);
                if (s.contains("<!-- KEYWORDS -->")) {
                    s = s.replace("<!-- KEYWORDS -->", keyWordString.toString());
                }
                if (s.contains("cccccccccc")) {
                    s = s.replaceAll("cccccccccc", f.getName().replace(".pde", ""));
                }
                if (s.contains("<!-- TITLE -->")) {
                    s = s.replace("<!-- TITLE -->", this.title);
                }
                if (s.contains("<!-- DESCRIPTION -->")) {
                    s = s.replace("<!-- DESCRIPTION -->", this.description);
                }
                if (s.contains("tttttttttt")) {
                    s = s.replaceAll("tttttttttt", String.format("%s", this.title));
                }
                if (s.contains("dddddddddd")) {
                    s = s.replaceAll("dddddddddd", String.format("%s", this.description));
                }
                if (s.contains("ssssssssss")) {
                    s = s.replaceAll("ssssssssss", jsLoc);
                }
                if (s.contains("1111111111")) {
                    s = s.replaceAll("1111111111", Integer.valueOf(this.dimension.width).toString());
                }
                if (s.contains("2222222222")) {
                    s = s.replaceAll("2222222222", Integer.valueOf(this.dimension.height).toString());
                }
                if (cssLoc.equals("index.html") || cssLoc.equals("./index.html")) {
                    String cssText = cssFormatter.toString();
                    cssText = cssText.replaceAll("1111111111", Integer.valueOf(this.dimension.width).toString());
                    cssText = cssText.replaceAll("2222222222", Integer.valueOf(this.dimension.height).toString());
                    s = s.replace("<!-- optional styling -->", String.format("<style type=\"text/css\">%n%s%n</style>", cssText));
                } else {
                    s = s.replace("<!-- optional styling -->", String.format("<link href=\"%s\" rel=\"stylesheet\" type=\"text/css\">", cssLoc));
                }
                indexFile.write(s.getBytes("UTF-8"));
            }
            index.close();
            indexFile.close();
            indexStream.close();
        }
    }

    private Formatter getFormatter() {
        return (Formatter)this.pictures.get(this.pictures.size() - 1);
    }

    @Override
    public void setStroke(Stroke s2) {
        super.setStroke(s2);
        BasicStroke s = (BasicStroke)s2;
        if (this.strokeLineWidth != s.getLineWidth()) {
            this.strokeLineWidth = s.getLineWidth();
            this.getFormatter().format("strokeWeight(strkS(%3.1f));%n", Float.valueOf(this.strokeLineWidth));
        }
        if (s.getEndCap() != this.strokeEndCap) {
            this.strokeEndCap = s.getEndCap();
            switch (s.getEndCap()) {
                case 0: {
                    this.getFormatter().format("strokeCap(PROJECT);%n", new Object[0]);
                    break;
                }
                case 1: {
                    this.getFormatter().format("strokeCap(ROUND);%n", new Object[0]);
                    break;
                }
                case 2: {
                    this.getFormatter().format("strokeCap(SQUARE);%n", new Object[0]);
                }
            }
        }
        if (s.getLineJoin() != this.strokeJoin) {
            this.strokeJoin = s.getLineJoin();
            switch (s.getLineJoin()) {
                case 2: {
                    this.getFormatter().format("strokeJoin(BEVEL);%n", new Object[0]);
                    break;
                }
                case 0: {
                    this.getFormatter().format("strokeJoin(MITER);%n", new Object[0]);
                    break;
                }
                case 1: {
                    this.getFormatter().format("strokeJoin(ROUND);%n", new Object[0]);
                }
            }
        }
    }

    private void localSetFont(Font font) {
        if (font != null && this.getFont() != null) {
            if (!font.getName().equals(this.getFont().getName()) || font.getSize2D() != this.getFont().getSize2D()) {
                this.getFormatter().format("textFont(%s, txtS(%5.2f));%n", font.getName().replaceAll("[. -]", "_"), Float.valueOf(font.getSize2D()));
            }
            super.setFont(font);
            if (!this.fontList.containsKey(font.getName())) {
                this.fontList.put(font.getName(), font);
            }
        }
    }

    @Override
    public void draw(Shape s) {
        if (s == null) {
            return;
        }
        if (this.verbose) {
            this.getFormatter().format("// Rendering %s%n", s.getClass().toString());
        }
        super.draw(s);
        if (this.getPaint() instanceof GradientPaint || this.getPaint() instanceof MultipleGradientPaint) {
            BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(s.getBounds().width, s.getBounds().height, 3);
            Graphics2D g4 = buffer.createGraphics();
            g4.setComposite(this.getComposite());
            g4.setPaint(this.getPaint());
            g4.translate(-s.getBounds().x, -s.getBounds().y);
            g4.draw(s);
            this.processImage(buffer, this.getTransform(), true, s.getBounds().x, s.getBounds().y, null);
            return;
        }
        if (this.preProcessShape(s, this.getFormatter())) {
            return;
        }
        Formatter localFormatter = this.startFunction();
        if ((s = this.processShape(s, localFormatter)) == null) {
            this.insertDraw(localFormatter);
            return;
        }
        boolean closed = false;
        ArrayList<AbstractDeployableGraphics2D.GJPathSegmentInfo> segments = new ArrayList<AbstractDeployableGraphics2D.GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new AbstractDeployableGraphics2D.GJPathSegmentInfo(type, d));
            it.next();
        }
        double startX = Double.NaN;
        double startY = Double.NaN;
        Iterator it2 = segments.iterator();
        while (it2.hasNext()) {
            AbstractDeployableGraphics2D.GJPathSegmentInfo segment = (AbstractDeployableGraphics2D.GJPathSegmentInfo)it2.next();
            switch (segment.getType()) {
                case 0: {
                    closed = false;
                    startX = segment.getData()[0];
                    startY = segment.getData()[1];
                    break;
                }
                case 1: {
                    localFormatter.format("line(%5.2f, %5.2f, %5.2f, %5.2f);%n", startX, startY, segment.getData()[0], segment.getData()[1]);
                    startX = segment.getData()[0];
                    startY = segment.getData()[1];
                    break;
                }
                case 2: {
                    QuadCurve2D.Double curve = new QuadCurve2D.Double(startX, startY, segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3]);
                    FlatteningPathIterator f = new FlatteningPathIterator(curve.getPathIterator(null), 0.5);
                    this.draw(f, localFormatter);
                    break;
                }
                case 3: {
                    localFormatter.format("bezier(%5.2f, %5.2f, %5.2f, %5.2f, %5.2f, %5.2f, %5.2f, %5.2f);%n", startX, startY, segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3], segment.getData()[4], segment.getData()[5]);
                    startX = segment.getData()[4];
                    startY = segment.getData()[5];
                    break;
                }
                case 4: {
                    if (it2.hasNext()) break;
                    startX = Double.NaN;
                    startY = Double.NaN;
                    localFormatter = this.endFunction(localFormatter, true, false);
                    closed = true;
                }
            }
        }
        if (!closed) {
            this.endFunction(localFormatter, true, false);
        }
    }

    private void draw(FlatteningPathIterator f, Formatter localFormatter) {
        if (this.verbose) {
            localFormatter.format("// Flattened quadTo%n", new Object[0]);
        }
        ArrayList<AbstractDeployableGraphics2D.GJPathSegmentInfo> segments = new ArrayList<AbstractDeployableGraphics2D.GJPathSegmentInfo>();
        double[] d = new double[6];
        FlatteningPathIterator it = f;
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new AbstractDeployableGraphics2D.GJPathSegmentInfo(type, d));
            it.next();
        }
        if (this.verbose) {
            localFormatter.format("// Flattened quadTo [%d x lines]%n", segments.size());
        }
        double startX = Double.NaN;
        double startY = Double.NaN;
        Iterator it2 = segments.iterator();
        while (it2.hasNext()) {
            AbstractDeployableGraphics2D.GJPathSegmentInfo segment = (AbstractDeployableGraphics2D.GJPathSegmentInfo)it2.next();
            switch (segment.getType()) {
                case 0: {
                    startX = segment.getData()[0];
                    startY = segment.getData()[1];
                    break;
                }
                case 1: {
                    localFormatter.format("line(%5.2f, %5.2f, %5.2f, %5.2f);%n", startX, startY, segment.getData()[0], segment.getData()[1]);
                    startX = segment.getData()[0];
                    startY = segment.getData()[1];
                    break;
                }
                case 4: {
                    if (it2.hasNext()) break;
                    startX = Double.NaN;
                    startY = Double.NaN;
                }
            }
        }
    }

    @Override
    public void fill(Shape s) {
        if (s == null) {
            return;
        }
        if (this.verbose) {
            this.getFormatter().format("// Rendering %s%n", s.getClass().toString());
        }
        Formatter localFormatter = this.startFunction();
        if (this.getPaint() instanceof GradientPaint || this.getPaint() instanceof MultipleGradientPaint) {
            BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(s.getBounds().width, s.getBounds().height, 3);
            Graphics2D g4 = buffer.createGraphics();
            g4.setComposite(this.getComposite());
            g4.setPaint(this.getPaint());
            g4.translate(-s.getBounds().x, -s.getBounds().y);
            g4.fill(s);
            this.processImage(buffer, this.getTransform(), true, s.getBounds().x, s.getBounds().y, null);
            return;
        }
        if (this.preProcessShape(s, this.getFormatter())) {
            return;
        }
        if ((s = this.processShape(s, localFormatter)) == null) {
            this.insertFill(localFormatter);
            return;
        }
        boolean closed = false;
        ArrayList<AbstractDeployableGraphics2D.GJPathSegmentInfo> segments = new ArrayList<AbstractDeployableGraphics2D.GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new AbstractDeployableGraphics2D.GJPathSegmentInfo(type, d));
            it.next();
        }
        int count = -1;
        double xo = 0.0;
        double yo = 0.0;
        double startX = Double.NaN;
        double startY = Double.NaN;
        for (AbstractDeployableGraphics2D.GJPathSegmentInfo segment : segments) {
            ++count;
            switch (segment.getType()) {
                case 0: {
                    if (!closed && count > 0) {
                        localFormatter.format("endShape();%n", new Object[0]);
                        localFormatter = this.endFunction(localFormatter, false, true, xo, yo);
                    }
                    closed = false;
                    xo = segment.getData()[0];
                    yo = segment.getData()[1];
                    localFormatter.format("beginShape();%n", new Object[0]);
                    localFormatter.format("vertex(xo + %5.2f, yo + %5.2f);%n", segment.getData()[0] - xo, segment.getData()[1] - yo);
                    startX = segment.getData()[0];
                    startY = segment.getData()[1];
                    break;
                }
                case 1: {
                    localFormatter.format("vertex(xo + %5.2f, yo + %5.2f);%n", segment.getData()[0] - xo, segment.getData()[1] - yo);
                    startX = segment.getData()[0];
                    startY = segment.getData()[1];
                    break;
                }
                case 2: {
                    QuadCurve2D.Double curve = new QuadCurve2D.Double(startX, startY, segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3]);
                    FlatteningPathIterator f = new FlatteningPathIterator(curve.getPathIterator(null), 0.5);
                    this.fill(f, localFormatter, xo, yo);
                    startX = segment.getData()[2];
                    startY = segment.getData()[3];
                    break;
                }
                case 3: {
                    localFormatter.format("bezierVertex(xo + %5.2f, yo + %5.2f,xo + %5.2f, yo + %5.2f, xo + %5.2f, yo + %5.2f);%n", segment.getData()[0] - xo, segment.getData()[1] - yo, segment.getData()[2] - xo, segment.getData()[3] - yo, segment.getData()[4] - xo, segment.getData()[5] - yo);
                    startX = segment.getData()[4];
                    startY = segment.getData()[5];
                    break;
                }
                case 4: {
                    localFormatter.format("endShape();%n", new Object[0]);
                    localFormatter = this.endFunction(localFormatter, false, true, xo, yo);
                    closed = true;
                    startX = Double.NaN;
                    startY = Double.NaN;
                }
            }
        }
        if (!closed) {
            localFormatter.format("endShape();%n", new Object[0]);
            this.endFunction(localFormatter, false, true, xo, yo);
        }
    }

    private void fill(FlatteningPathIterator f, Formatter localFormatter, double xo, double yo) {
        ArrayList<AbstractDeployableGraphics2D.GJPathSegmentInfo> segments = new ArrayList<AbstractDeployableGraphics2D.GJPathSegmentInfo>();
        double[] d = new double[6];
        FlatteningPathIterator it = f;
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new AbstractDeployableGraphics2D.GJPathSegmentInfo(type, d));
            it.next();
        }
        if (this.verbose) {
            localFormatter.format("// Flattened [%d x segments]%n", segments.size());
        }
        for (AbstractDeployableGraphics2D.GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: 
                case 1: {
                    localFormatter.format("vertex(xo + %5.2f, yo + %5.2f);%n", segment.getData()[0] - xo, segment.getData()[1] - yo);
                    break;
                }
            }
        }
    }

    private boolean preProcessShape(Shape s, Formatter formatter) {
        if (s instanceof Point2D) {
            Point2D p = (Point2D)((Object)s);
            if (this.getClip().contains(p)) {
                this.getTransform().transform(p, p);
                formatter.format("noSmooth();%npoint(%5.2f, %5.2f);%nsmooth()%n", p.getX(), p.getY());
            }
            return true;
        }
        if (s instanceof Line2D) {
            Line2D line = (Line2D)s;
            double theta = Math.atan2(line.getY2() - line.getY1(), line.getX2() - line.getX1());
            boolean posSlope = theta > -1.5707963267948966 && theta <= 0.0 || theta > 1.5707963267948966 && theta < Math.PI;
            BasicStroke stk = new BasicStroke(1.0f);
            s = stk.createStrokedShape(line);
            Area area = new Area(s);
            area.intersect(new Area(this.getClip()));
            s = this.getTransform().createTransformedShape(area);
            if (posSlope) {
                formatter.format("line(%5.2f, %5.2f, %5.2f, %5.2f);%n", s.getBounds2D().getMinX(), s.getBounds().getMaxY(), s.getBounds().getMaxX(), s.getBounds().getMinY());
            } else {
                formatter.format("line(%5.2f, %5.2f, %5.2f, %5.2f);%n", s.getBounds2D().getMinX(), s.getBounds().getMinY(), s.getBounds().getMaxX(), s.getBounds().getMaxY());
            }
            return true;
        }
        return false;
    }

    private Shape processShape(Shape s, Formatter localFormatter) {
        if (s instanceof Rectangle2D) {
            Shape s2 = this.doClip(s, localFormatter);
            if (s2 != null && new Area(s2).isRectangular()) {
                s2 = this.getTransform().createTransformedShape(s2);
                localFormatter.format("rect(%5.2f, %5.2f, %5.2f, %5.2f);//from processShape%n", s2.getBounds2D().getX(), s2.getBounds2D().getY(), s2.getBounds2D().getWidth(), s2.getBounds2D().getHeight());
                return null;
            }
        } else if (!(s instanceof RoundRectangle2D)) {
            if (s instanceof Ellipse2D) {
                Rectangle r = s.getBounds();
                Shape s2 = this.doClip(s, localFormatter);
                if (s2.getBounds().equals(r)) {
                    s2 = this.getTransform().createTransformedShape(s);
                    localFormatter.format("ellipse(%5.2f, %5.2f, %5.2f, %5.2f);%n", s2.getBounds2D().getX(), s2.getBounds2D().getY(), s2.getBounds2D().getWidth(), s2.getBounds2D().getHeight());
                    return null;
                }
            } else if (new Area(s).isPolygonal()) {
                // empty if block
            }
        }
        if ((s = this.doClip(s, localFormatter)) != null) {
            return new Path2D.Double(s, this.getTransform());
        }
        return null;
    }

    private Shape doClip(Shape s, Formatter localFormatter) {
        if (this.getClip() != null) {
            Area area = new Area(s);
            Area clipArea = new Area(this.getClip());
            if (clipArea.contains(s.getBounds2D())) {
                return s;
            }
            if (area.intersects(clipArea.getBounds2D())) {
                area.intersect(clipArea);
                if (!area.isEmpty()) {
                    if (area.isRectangular()) {
                        s = this.getTransform().createTransformedShape(area);
                        localFormatter.format("rect(%5.2f, %5.2f, %5.2f, %5.2f);%n", s.getBounds2D().getX(), s.getBounds2D().getY(), s.getBounds2D().getWidth(), s.getBounds2D().getHeight());
                        return null;
                    }
                    if (s instanceof Path2D) {
                        Path2D.Double p = new Path2D.Double(area);
                        p.setWindingRule(((Path2D)s).getWindingRule());
                        s = p;
                    } else {
                        s = area;
                    }
                } else {
                    return null;
                }
            }
        }
        return s;
    }

    private Formatter startFunction() {
        StringBuilder str = new StringBuilder();
        return new Formatter(str);
    }

    private Formatter endFunction(Formatter localFormatter, boolean drawFlag, boolean fillFlag) {
        return this.endFunction(localFormatter, drawFlag, fillFlag, 0.0, 0.0);
    }

    private Formatter endFunction(Formatter localFormatter, boolean drawFlag, boolean fillFlag, double xo, double yo) {
        String codeBody = localFormatter.toString();
        if (this.code.containsKey(codeBody = codeBody.replaceAll("\\+ -", "- "))) {
            if (fillFlag) {
                this.getFormatter().format("fillShape_%x(%5.2f, %5.2f);%n", this.code.get(codeBody), xo, yo);
            } else {
                this.getFormatter().format("drawShape_%x();%n", this.code.get(codeBody));
            }
        } else {
            String s;
            if (fillFlag) {
                s = String.format("void fillShape_%x(float xo, float yo) {%n", localFormatter.hashCode());
                s = s.concat(String.format("pushStyle();%nnoStroke();%n", new Object[0]));
                s = s.concat(codeBody);
                s = s.concat(String.format("popStyle();%n}%n%n", new Object[0]));
                this.customShapes.add(s);
                this.getFormatter().format("fillShape_%x(%5.2f, %5.2f);%n", localFormatter.hashCode(), xo, yo);
            }
            if (drawFlag) {
                s = String.format("void drawShape_%x() {%n", localFormatter.hashCode());
                s = s.concat(String.format("pushStyle();%nnoFill();%n", new Object[0]));
                s = s.concat(codeBody);
                s = s.concat(String.format("popStyle();%n}%n%n", new Object[0]));
                this.customShapes.add(s);
                this.getFormatter().format("drawShape_%x();%n", localFormatter.hashCode());
            }
            this.code.put(codeBody, localFormatter.hashCode());
        }
        localFormatter.close();
        return this.startFunction();
    }

    private void insertFill(Formatter f) {
        String codeBody = String.format("pushStyle();%nnoStroke();%n%s%npopStyle();%n}%n", f.toString());
        if (this.code.containsKey(codeBody)) {
            this.getFormatter().format("fillShape_%x();%n", this.code.get(codeBody));
        } else {
            String s = String.format("void fillShape_%x() {%n", f.hashCode());
            s = s.concat(codeBody);
            this.customShapes.add(s);
            this.code.put(codeBody, f.hashCode());
            this.getFormatter().format("fillShape_%x();%n", f.hashCode());
        }
        f.close();
    }

    private void insertDraw(Formatter f) {
        String codeBody = String.format("pushStyle();%nnoFill();%n%s%npopStyle();%n}%n", f.toString());
        if (this.code.containsKey(codeBody)) {
            this.getFormatter().format("drawShape_%x();%n", this.code.get(codeBody));
        } else {
            String s = String.format("void drawShape_%x() {%n", f.hashCode());
            s = s.concat(codeBody);
            this.customShapes.add(s);
            this.code.put(codeBody, f.hashCode());
            this.getFormatter().format("drawShape_%x();%n", f.hashCode());
        }
        f.close();
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        this.fill(rect);
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        this.draw(rect);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (this.textAsShapes) {
            this.drawTextAsShapes(str, x, y);
        } else if ((this.getTransform().getType() & 0x10) != 0 || (this.getTransform().getType() & 8) != 0 || (this.getTransform().getType() & 0x40) != 0) {
            FontRenderContext ctx = new FontRenderContext(this.getFontRenderContext().getTransform(), true, true);
            new TextLayout(str, this.getFont(), ctx).draw(this, x, y);
        } else {
            this.localSetFont(this.getFont());
            super.drawString(str, x, y);
            Point2D.Float p = new Point2D.Float();
            this.getTransform().transform(new Point2D.Float(x, y), p);
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            if (this.getClipBounds() != null) {
                for (str = str.replace("\"", "\\\""); str != null && str.length() > 2 && (double)(p.x + (float)metrics.stringWidth(str)) > this.getTransform().getTranslateX() + (double)this.getClipBounds().width; str = str.substring(0, str.length() - 1)) {
                }
            }
            this.setColor(this.getColor());
            this.getFormatter().format("text(\"%s\", %5.2f, %5.2f);%n", str, Float.valueOf(p.x), Float.valueOf(p.y));
        }
    }

    private void drawTextAsShapes(String str, float x, float y) {
        GlyphVector vec = this.getFont().createGlyphVector(this.getFontRenderContext(), str);
        Shape glyphOutline = vec.getOutline(x, y);
        Stroke old = this.getStroke();
        this.setStroke(glyphStroke);
        this.draw(glyphOutline);
        this.setStroke(old);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        char[] next = new char[iterator.getEndIndex() - iterator.getBeginIndex()];
        for (int k = iterator.getBeginIndex(); k < iterator.getEndIndex() - 1; ++k) {
            next[k] = iterator.current();
            iterator.next();
        }
        this.drawString(new String(next), x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector vec, float x, float y) {
        if (this.verbose) {
            this.getFormatter().format("// Rendering text as image%n", new Object[0]);
        }
        Shape glyphOutline = vec.getOutline(x, y);
        Path2D.Double glyphs = new Path2D.Double(glyphOutline, this.getTransform());
        BufferedImage buffer = super.getDeviceConfiguration().createCompatibleImage(glyphs.getBounds().width, glyphs.getBounds().height, 3);
        Graphics2D g4 = buffer.createGraphics();
        g4.setRenderingHints(this.getRenderingHints());
        g4.setPaint(this.getPaint());
        g4.translate(-glyphs.getBounds2D().getX(), -glyphs.getBounds2D().getY());
        g4.fill(glyphs);
        this.writeImage((Image)buffer, (int)glyphs.getBounds2D().getX(), (int)glyphs.getBounds2D().getY(), buffer.getWidth(), buffer.getHeight(), (this.getTransform().getType() & 0x40) != 0);
        super.fill(glyphOutline);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.draw(line);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.getFormatter().format("fill(%s);%n", this.colorToString(this.getBackground()));
        this.fillRect(x, y, width, height);
        this.getFormatter().format("fill(%s);%n", this.colorToString(this.getColor()));
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float arc = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(arc);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float arc = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2);
        this.fill(arc);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        for (int k = 1; k < xPoints.length; ++k) {
            this.drawLine(xPoints[k - 1], yPoints[k - 1], xPoints[k], yPoints[k]);
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void setColor(Color c) {
        String s = this.colorToString(c);
        if (colorString == null || !s.equals(colorString)) {
            this.getFormatter().format("fill(%s);%n", s);
            this.getFormatter().format("stroke(%s);%n", s);
            colorString = s;
        }
        super.setColor(c);
    }

    @Override
    public void setPaint(Paint p) {
        if (p instanceof Color) {
            this.setColor((Color)p);
        } else {
            super.setPaint(p);
        }
    }

    private String colorToString(Color c) {
        float alpha = ((AlphaComposite)this.getComposite()).getAlpha();
        return String.format("%d,%d,%d,%d", c.getRed(), c.getGreen(), c.getBlue(), (int)((float)c.getAlpha() * alpha));
    }

    @Override
    public boolean copyImage(Image img, int dx, int dy, int sx, int sy, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, dx, dy, dx + width, dy + height, sx, sy, sx + width, sy + height, bgcolor, observer);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        super.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        super.drawBytes(data, offset, length, x, y);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer, this.getTransform());
        return super.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    private void drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer, AffineTransform xform) {
        BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(img.getWidth(observer), img.getHeight(observer), 3);
        Graphics2D g4 = buffer.createGraphics();
        g4.setComposite(this.getComposite());
        g4.setRenderingHints(this.getRenderingHints());
        g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g4.drawImage(img, null, null);
        buffer = buffer.getSubimage(sx1, sy1, sx2 - sx1, sy2 - sy1);
        Image img2 = buffer.getScaledInstance(dx2 - dx1, dy2 - dy1, 4);
        this.processImage(img2, xform, dx1, dy1, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (observer != null && observer instanceof JButton && (this.lfFixes & 1) == 1) {
            JButton button = (JButton)observer;
            BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(button.getWidth(), button.getHeight(), 3);
            Graphics2D g4 = buffer.createGraphics();
            g4.setComposite(this.getComposite());
            g4.setRenderingHints(this.getRenderingHints());
            g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            button.paint(g4);
            this.processImage(buffer, this.getTransform(), 0, 0, observer);
        } else {
            BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            Graphics2D g4 = buffer.createGraphics();
            g4.setComposite(this.getComposite());
            g4.setRenderingHints(this.getRenderingHints());
            g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g4.drawImage(img, 0, 0, width, height, bgcolor, null);
            this.processImage(buffer, this.getTransform(), x, y, observer);
        }
        return super.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver observer) {
        if (this.verbose && observer != null) {
            this.getFormatter().format("// ImageObserver = %s%n", observer.getClass().toString());
        }
        if (img == null) {
            return true;
        }
        if (xform == null || xform.isIdentity()) {
            return this.drawImage(img, 0, 0, img.getWidth(observer), img.getHeight(observer), observer);
        }
        if (xform.getDeterminant() != 0.0) {
            if (xform.equals(this.getTransform())) {
                this.processImage(img, xform, 0, 0, observer);
            } else {
                AffineTransform xform2 = (AffineTransform)xform.clone();
                xform2.concatenate(this.getTransform());
                this.processImage(img, xform, 0, 0, observer);
            }
        }
        return super.drawImage(img, xform, observer);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(img.getWidth(), img.getHeight(), 3);
        Graphics2D g4 = buffer.createGraphics();
        g4.setRenderingHints(this.getRenderingHints());
        g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g4.drawImage(img, op, 0, 0);
        this.writeImage((Image)buffer, (int)this.getTransform().getTranslateX() + x, (int)this.getTransform().getTranslateY() + y, buffer.getWidth(), buffer.getHeight(), false);
        super.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(img.getWidth(), img.getHeight(), 3);
        Graphics2D g4 = buffer.createGraphics();
        g4.setRenderingHints(this.getRenderingHints());
        g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g4.drawRenderedImage(img, new AffineTransform());
        this.processImage(buffer, xform, 0, 0, null);
        super.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage((int)img.getWidth(), (int)img.getHeight(), 3);
        Graphics2D g4 = buffer.createGraphics();
        g4.setRenderingHints(this.getRenderingHints());
        g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g4.drawRenderableImage(img, new AffineTransform());
        this.processImage(buffer, xform, 0, 0, null);
        super.drawRenderableImage(img, xform);
    }

    @Override
    public String getCode() {
        String s2;
        Formatter lF = new Formatter(new StringBuilder(1024));
        lF.format("/*%n* Processing script created using PDEGraphics2D which is part of%n* Project Waterloo%n", new Object[0]);
        lF.format("*             http://sigtool.sourceforge.net%n", new Object[0]);
        lF.format("* Project Waterloo and Waterloo Scientific Graphics are King's College London projects%n", new Object[0]);
        lF.format("* Author: Malcolm Lidierth, Wolfson Centre for Age-Related Diseases%n*%n", new Object[0]);
        lF.format("*%n* This file was created: %s%n", new Date().toString());
        lF.format("*%n* Display area size was %d x %d pixels when created but may be edited%n", this.dimension.width, this.dimension.height);
        lF.format("* within the setup() function below.%n", new Object[0]);
        lF.format("*%n* Coordinates are in pixels. To scale and move the drawing in the drawing area,%n", new Object[0]);
        lF.format("* alter the scaling and translate factors set in the draw() function below.%n", new Object[0]);
        lF.format("*%n* All displayed co-ordinates will be derived as (original script value*scale)+translation offset.%n", new Object[0]);
        lF.format("* This for crisp lines:%n", new Object[0]);
        lF.format("* @pjs crisp=\"true\";%n", new Object[0]);
        String lastImage = "";
        if (this.images.size() > 0) {
            lF.format("* @pjs preload=\"", new Object[0]);
            Iterator<Object> it = this.images.keySet().iterator();
            while (it.hasNext()) {
                Integer k = it.next();
                ImageIcon icon = this.images.get(k);
                lF.format("./data/image_%d_%x.png", (int)k, icon.hashCode());
                if (it.hasNext()) {
                    lF.format(",", new Object[0]);
                    continue;
                }
                lastImage = String.format("img_%d_%x", (int)k, icon.hashCode());
            }
            lF.format("\";%n", new Object[0]);
        }
        lF.format("*/%n", new Object[0]);
        lF.format("%n/**%n* %s%n*%n* %s%n*/%n", this.title, this.description);
        if (this.fontList.size() > 0) {
            lF.format("// Font creation: the default font will be used if these are not available%n", new Object[0]);
            for (String fontname : this.fontList.keySet()) {
                lF.format("PFont %s = createFont(\"%s\", 48, true);%n", this.fontList.get(fontname).getName().replaceAll("[. -]", "_"), this.fontList.get(fontname).getName());
            }
        }
        double shortestDelay = Double.MAX_VALUE;
        lF.format("%n// User-definable function to set text sizes%nfloat txtS(float sz) {return sz;}%n// User-definable function so set line widths%nfloat strkS(float w) {return w;}%n", new Object[0]);
        if (this.pictures.size() > 1) {
            for (int k = 0; k < this.latency.size() - 1; ++k) {
                shortestDelay = Math.min(shortestDelay, (double)((Integer)this.latency.get(k + 1) - (Integer)this.latency.get(k)));
            }
            lF.format("%nint counter=0;%n%s%nvoid setup() {%ncounter=millis();%n", this.prependedCode);
        } else {
            lF.format("%n%s%nvoid setup() {%n", this.prependedCode);
        }
        lF.format("size(%d,%d);%nellipseMode(CORNER);%n", this.dimension.width, this.dimension.height);
        if (this.title != null && !this.title.isEmpty() && !this.title.equals("Title")) {
            lF.format("try {%nframe.setTitle(\"%s\");%n}%ncatch (Exception ex) {%n//javascript: frame not defined}%n}%n", this.title);
        }
        lF.format("}%n%n%nvoid draw() {%nsmooth();%nscale(1,1);%ntranslate(0,0);%ntextAlign(LEFT,BOTTOM);%n", new Object[0]);
        if (this.baseFont != null) {
            lF.format("textFont(%s, txtS(%5.2f));%n", this.baseFont.getName().replaceAll("[. -]", "_"), Float.valueOf(this.baseFont.getSize2D()));
        }
        if (this.pictures.size() > 1) {
            lF.format("%nif (millis() - counter < %d) {%n", (Integer)this.latency.get(1) + this.getActionDelay());
        }
        if ((s2 = super.getCode()).length() > 65535) {
            logger.warn("Warning: this script is too long for use in Processing.%n");
        }
        s2 = lF.toString().concat(s2);
        if (!lastImage.isEmpty() && this.pictures.size() <= 1) {
            s2 = s2.concat(String.format("if (%s.width > 0) {%nnoLoop();%n}%n} //EOF DRAW%n", lastImage));
        } else if (this.pictures.size() <= 1) {
            s2 = s2.concat(String.format("noLoop();%n}//EOF DRAW%n%n", new Object[0]));
        }
        if (this.pictures.size() > 1) {
            for (int k = 1; k < this.pictures.size() - 1; ++k) {
                s2 = s2.concat(String.format("} else if ((millis() - counter) > %d && (millis() - counter) <= %d) {%npicture%d();%n", (Integer)this.latency.get(k) + this.getActionDelay(), (Integer)this.latency.get(k + 1) + this.getActionDelay(), k));
            }
            s2 = s2.concat(String.format("} else if ((millis() - counter) > %d && (millis() - counter) <= %d) {%npicture%d();%n", (Integer)this.latency.get(this.pictures.size() - 1) + this.getActionDelay(), (Integer)this.latency.get(this.pictures.size() - 1) + (Integer)this.latency.get(1) + this.getActionDelay(), this.pictures.size() - 1));
            s2 = s2.concat(String.format("} else {%ncounter=millis();%n}%n", new Object[0]));
            s2 = s2.concat(String.format("frameRate(%5.2f);%n", 1000.0 / shortestDelay * 2.0));
            s2 = s2.concat(String.format("}//EOF[DRAW]%n%n", new Object[0]));
        }
        if (this.images.size() > 0) {
            String declarations = String.format("/** Images */%n", new Object[0]);
            String loadcalls = "";
            for (Integer k : this.images.keySet()) {
                ImageIcon icon = this.images.get(k);
                declarations = declarations.concat(String.format("PImage img_%d_%x;%n", (int)k, icon.hashCode()));
                loadcalls = loadcalls.concat(String.format("img_%d_%x=loadImage(\"./data/image_%d_%x.png\");%n", (int)k, icon.hashCode(), (int)k, icon.hashCode()));
            }
            s2 = s2.replace("void setup() {", String.format("%s%nvoid setup() {%n%s", declarations, loadcalls));
        }
        for (String s3 : this.customShapes) {
            s2 = s2.concat(s3);
        }
        for (int k = 1; k < this.pictures.size(); ++k) {
            Formatter f3 = (Formatter)this.pictures.get(k);
            String s3 = String.format("%nvoid picture%d() {%n", k);
            s3 = s3.concat(f3.toString());
            s3 = s3.concat(String.format("}//EOF[PICTURE][%d]%n", k));
            s2 = s2.concat(s3);
        }
        if (this.images.size() > 0) {
            for (Integer k : this.imageDim.keySet()) {
                Rectangle2D r = this.imageDim.get(k);
                if (r.getX() != 0.0 || r.getY() != 0.0 || r.getWidth() != this.dimension.getWidth() || r.getHeight() != this.dimension.getHeight()) continue;
                String target = String.format("rect(%5.2f, %5.2f, %5.2f, %5.2f);", Float.valueOf(0.0f), Float.valueOf(0.0f), this.dimension.getWidth(), this.dimension.getHeight());
                s2 = s2.replaceAll(target, "//" + target);
            }
        }
        s2 = s2.concat(String.format("%n%s%n", this.appendedCode));
        return s2;
    }

    @Override
    public void setPaintObject(Object referenceObject) {
        if (referenceObject != null) {
            if (referenceObject instanceof Component) {
                Component c = (Component)referenceObject;
                this.getFormatter().format("/* Painting %s : %x */%n", c.getName() == null || c.getName().isEmpty() ? c.getClass().toString() : c.getName(), c.hashCode());
            } else {
                this.getFormatter().format("/* Painting %s : %x */%n", referenceObject.getClass().toString(), referenceObject.hashCode());
            }
        }
    }

    @Override
    public void addComment(String comment) {
        if (comment.startsWith("/")) {
            this.getFormatter().format("%s", comment);
        } else if (comment.length() < 40) {
            this.getFormatter().format("/* %s */%n", comment);
        } else {
            this.getFormatter().format("/**%n* %s%n*/%n", comment);
        }
    }

    @Override
    public void addCode(String code) {
        this.getFormatter().format("%s", code);
    }

    @Override
    public void prependCode(String code) {
        this.prependedCode = this.prependedCode.concat(code);
    }

    @Override
    public void appendCode(String code) {
        this.appendedCode = this.appendedCode.concat(code);
    }

    protected Object clone() {
        PDEGraphics2D g = new PDEGraphics2D((Graphics2D)this.parentGraphics.create());
        g.customShapes = this.customShapes;
        g.pictures = this.pictures;
        g.setTextAsShapes(this.isTextAsShapes());
        g.images = this.images;
        g.imageDim = this.imageDim;
        g.dimension = this.dimension;
        g.lfFixes = this.lfFixes;
        g.fontList = this.fontList;
        g.code = this.code;
        g.strokeEndCap = this.strokeEndCap;
        g.strokeJoin = this.strokeJoin;
        g.strokeLineWidth = this.strokeLineWidth;
        g.parentGraphics.setColor(this.getColor());
        return g;
    }

    private void writeImage(Image img, int x, int y, int width, int height, boolean flag) {
        this.writeImage(img, (float)x, (float)y, (float)width, (float)height, flag);
    }

    private void writeImage(Image img, float x, float y, float width, float height, boolean flag) {
        ImageIcon icon = new ImageIcon(img);
        this.images.put(this.images.size(), icon);
        this.imageDim.put(this.images.size() - 1, new Rectangle2D.Float(x, y, width, height));
        this.getFormatter().format("image(img_%d_%x,%5.2f, %5.2f, %5.2f, %5.2f);//Flip=%b%n", this.images.size() - 1, icon.hashCode(), Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height), flag);
    }

    private void processImage(Image img, AffineTransform xform, int x, int y, ImageObserver obs) {
        this.processImage(img, xform, true, x, y, obs);
    }

    private void processImage(Image img, AffineTransform xform, boolean canDoWrite, int x, int y, ImageObserver obs) {
        if (xform == null) {
            xform = new AffineTransform();
        }
        if ((xform.getType() & 0x10) != 0 || (xform.getType() & 8) != 0 || (xform.getType() & 0x40) != 0) {
            Shape r = xform.createTransformedShape(new Rectangle2D.Double(0.0, 0.0, img.getWidth(obs), img.getHeight(obs)));
            if (r.getBounds().width > 0 && r.getBounds().height > 0) {
                BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(this.dimension.width, this.dimension.height, 3);
                Graphics2D g4 = buffer.createGraphics();
                g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g4.drawImage(img, xform, obs);
                buffer = buffer.getSubimage(r.getBounds().x, r.getBounds().y, r.getBounds().width, r.getBounds().height);
                if (canDoWrite) {
                    if ((xform.getType() & 0x40) != 0) {
                        int tmp = x;
                        x = y;
                        y = tmp;
                    }
                    this.writeImage((Image)buffer, r.getBounds().x + x, r.getBounds().y + y, buffer.getWidth(), buffer.getHeight(), (xform.getType() & 0x40) != 0);
                }
            }
        } else {
            Shape r = xform.createTransformedShape(new Rectangle2D.Double(0.0, 0.0, img.getWidth(obs), img.getHeight(obs)));
            if (r.getBounds().width > 0 && r.getBounds().height > 0) {
                BufferedImage buffer = this.getDeviceConfiguration().createCompatibleImage(r.getBounds().width, r.getBounds().height, 3);
                Graphics2D g4 = buffer.createGraphics();
                g4.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                AffineTransform af = (AffineTransform)xform.clone();
                af.translate(-r.getBounds().x, -r.getBounds().y);
                g4.drawImage(img, af, obs);
                if (canDoWrite) {
                    this.writeImage((Image)buffer, (float)xform.getTranslateX() + (float)x, (float)xform.getTranslateY() + (float)y, (float)buffer.getWidth(obs), (float)buffer.getHeight(obs), (xform.getType() & 0x40) != 0);
                }
            }
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static String getUserHTML() {
        return userHTML;
    }

    public static void setUserHTML(String aUserHTML) {
        userHTML = aUserHTML;
    }
}

