/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.deploy.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import kcl.waterloo.deploy.image.ImageSupport;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;

public class ImagePanel
extends JPanel {
    static final boolean isQuartz = System.getProperty("os.name").matches("Mac OS X") && System.getProperty("apple.awt.graphics.UseQuartz").matches("true");
    static boolean isQuality = true;

    public ImagePanel(String s) {
        this(new File(s));
    }

    public ImagePanel(File file) {
        this.setLayout(new BorderLayout());
        if (file.getName().endsWith(".svg")) {
            JSVGCanvas canvas;
            JSVGCanvas svgCanvas = canvas = new JSVGCanvas();
            svgCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

                public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                }

                public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                }
            });
            svgCanvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

                public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                }

                public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                }
            });
            svgCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

                public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                }

                public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                }
            });
            svgCanvas.setRecenterOnResize(true);
            svgCanvas.setURI(file.toURI().toString());
            this.add((Component)svgCanvas, "Center");
            svgCanvas.validate();
        } else if (ImageSupport.isImageFormatSupported(file)) {
            ImageCanvas canvas = new ImageCanvas(file);
            canvas.addComponentListener(canvas);
            this.add((Component)canvas, "Center");
            this.repaint();
        }
    }

    private class ImageCanvas
    extends JPanel
    implements ComponentListener {
        private File file;
        private BufferedImage image;
        double aspectRatio = -1.0;
        private BufferedImage buffer = null;
        private int requiredHeight = -1;
        private int requiredWidth = -1;

        public ImageCanvas(File file) {
            this.file = file;
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            this.rescale();
        }

        @Override
        public void componentMoved(ComponentEvent ce) {
        }

        @Override
        public void componentShown(ComponentEvent ce) {
            this.rescale();
        }

        @Override
        public void componentHidden(ComponentEvent ce) {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.buffer, (this.getWidth() - this.requiredWidth) / 2, (this.getHeight() - this.requiredHeight) / 2, this.requiredWidth, this.requiredHeight, this);
        }

        public final void rescale() {
            if (this.image == null) {
                try {
                    this.image = ImageIO.read(this.file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.image.getWidth() != -1) {
                this.aspectRatio = (double)this.image.getWidth() / (double)this.image.getHeight();
            }
            this.requiredHeight = (int)((double)this.getWidth() / this.aspectRatio);
            this.requiredWidth = (int)((double)this.requiredHeight * this.aspectRatio);
            if (this.requiredHeight > this.getHeight() || this.requiredWidth > this.getWidth()) {
                this.requiredWidth = (int)((double)this.getHeight() * this.aspectRatio);
                this.requiredHeight = (int)((double)this.requiredWidth / this.aspectRatio);
            }
            if (!(isQuartz || this.buffer != null && this.requiredWidth >= this.buffer.getWidth() / 2 && this.requiredWidth <= this.buffer.getWidth() * 2)) {
                try {
                    this.image = ImageIO.read(this.file);
                    this.buffer = this.getGraphicsConfiguration().createCompatibleImage(this.requiredWidth, this.requiredHeight, 3);
                    Graphics2D g = this.buffer.createGraphics();
                    g.drawImage(this.image.getScaledInstance(this.requiredWidth, this.requiredHeight, 4), 0, 0, this.requiredWidth, this.requiredHeight, this);
                    g.dispose();
                    this.image = this.buffer;
                    this.repaint();
                    return;
                }
                catch (IOException g) {
                    // empty catch block
                }
            }
            this.buffer = this.getGraphicsConfiguration().createCompatibleImage(this.requiredWidth, this.requiredHeight, 3);
            Graphics2D g = this.buffer.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.drawImage(this.image, 0, 0, this.requiredWidth, this.requiredHeight, this);
            g.dispose();
            this.repaint();
        }
    }
}

