/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.defaults;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kcl.waterloo.defaults.Colors;
import kcl.waterloo.graphics.GJAbstractGraph;
import kcl.waterloo.graphics.GJGraph;
import kcl.waterloo.graphics.GJGraphContainer;
import kcl.waterloo.graphics.GJUtilities;
import kcl.waterloo.graphics.data.GJDoubleDataVector;
import kcl.waterloo.graphics.plots2D.GJLine;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.GJScatter;
import kcl.waterloo.gui.PreferencesDialog;
import kcl.waterloo.logging.CommonLogger;
import kcl.waterloo.marker.GJMarker;
import kcl.waterloo.widget.GJColorComboBox;
import kcl.waterloo.xml.GJEncoder;
import org.jdesktop.swingx.painter.effects.GlowPathEffect;

public class GJDefaults {
    private static Class dataClass = GJDoubleDataVector.class;
    private static LinkedHashMap<String, Object> map = new LinkedHashMap(64);
    private static final LinkedHashMap<String, Object> map2 = new LinkedHashMap(16);
    private static final AtomicBoolean Deserializing = new AtomicBoolean(false);
    private static final GlowPathEffect glow = new GlowPathEffect();
    private static final GJDefaults instance = new GJDefaults();
    private static CommonLogger logger = new CommonLogger(GJDefaults.class);

    private GJDefaults() {
        map = GJDefaults.getDefaultDefaults();
        GJDefaults.setMap2();
        try {
            SecurityManager manager = System.getSecurityManager();
            if (manager != null) {
                manager.checkPermission(new FilePermission(GJDefaults.getPreferencesFolder(), "read"));
            }
        }
        catch (SecurityException ex) {
            logger.warn("Security Exception: System files are not available to read");
            return;
        }
        File f = GJDefaults.getDefaultsFile();
        if (f.isFile()) {
            LinkedHashMap<String, Object> filedMap = GJDefaults.readPreferencesFile(f, true);
            for (String key : filedMap.keySet()) {
                if (!map.containsKey(key) || !filedMap.get(key).getClass().isAssignableFrom(map.get(key).getClass())) continue;
                map.put(key, filedMap.get(key));
            }
        }
    }

    public static GJDefaults getInstance() {
        return instance;
    }

    private static LinkedHashMap<String, Object> getDefaultDefaults() {
        LinkedHashMap<String, Object> localMap = new LinkedHashMap<String, Object>();
        localMap.put("GJBasicPanel.backgroundColor", Color.white);
        localMap.put("GJAbstractGraphContainer.backgroundColor", Color.white);
        localMap.put("GJAbstractGraphContainer.backgroundPainted", Boolean.TRUE);
        localMap.put("GJAbstractGraphContainer.font", new Font("SansSerif", 1, 10));
        localMap.put("GJAbstractGraph.axisStroke", Float.valueOf(1.5f));
        localMap.put("GJAbstractGraph.minorGridStrokeWeight", Float.valueOf(0.6f));
        localMap.put("GJAbstractGraph.majorGridStrokeWeight", Float.valueOf(1.0f));
        localMap.put("GJAbstractGraph.minorCountXHint", 4);
        localMap.put("GJAbstractGraph.minorCountYHint", 4);
        localMap.put("GJAbstractGraph.majorGridPainted", Boolean.FALSE);
        Color COLOR = Colors.getColor("CORNFLOWERBLUE");
        localMap.put("GJAbstractGraph.majorGridColor", COLOR);
        localMap.put("GJAbstractGraph.minorGridPainted", Boolean.FALSE);
        localMap.put("GJAbstractGraph.minorGridColor", COLOR);
        localMap.put("GJAbstractGraph.backgroundColor", Color.white);
        localMap.put("GJAbstractGraph.backgroundPainted", Boolean.FALSE);
        localMap.put("GJAbstractGraph.axisColor", Color.black);
        localMap.put("GJAbstractGraph.innerAxisPainted", Boolean.FALSE);
        localMap.put("GJAbstractGraph.innerAxisLabelled", Boolean.FALSE);
        localMap.put("GJAbstractGraph.mouseTextAsInverse", Boolean.TRUE);
        localMap.put("GJAbstractGraph.mainFormatter", NumberFormat.getInstance());
        localMap.put("GJAbstractGraph.secondFormatter", new DecimalFormat("0.##E0"));
        localMap.put("GJAbstractGraph.mousePositionTextFormat", "x= %.3f, y= %.3f ");
        localMap.put("GJAbstractGraph.axesPadding", 0.05);
        localMap.put("GJAbstractGraph.tightAxes", Boolean.FALSE);
        localMap.put("GJGraph.leftAxisPainted", Boolean.TRUE);
        localMap.put("GJGraph.rightAxisPainted", Boolean.FALSE);
        localMap.put("GJGraph.topAxisPainted", Boolean.FALSE);
        localMap.put("GJGraph.bottomAxisPainted", Boolean.TRUE);
        localMap.put("GJGraph.leftAxisLabelled", Boolean.TRUE);
        localMap.put("GJGraph.rightAxisLabelled", Boolean.FALSE);
        localMap.put("GJGraph.topAxisLabelled", Boolean.FALSE);
        localMap.put("GJGraph.bottomAxisLabelled", Boolean.TRUE);
        localMap.put("GJAbstractPlot.markerSymbol", "Circle");
        localMap.put("GJAbstractPlot.markerSize", 5.0);
        localMap.put("GJAbstractPlot.edgeColor", Colors.getColors().get("BLACK"));
        localMap.put("GJAbstractPlot.edgeStrokeWidth", Float.valueOf(1.5f));
        localMap.put("GJAbstractPlot.lineStyle", "Solid");
        localMap.put("GJAbstractPlot.lineColor", Colors.getColors().get("BLACK"));
        localMap.put("GJAbstractPlot.lineStrokeWidth", Float.valueOf(1.5f));
        localMap.put("GJAbstractPlot.fill", Color.lightGray);
        localMap.put("GJAbstractPlot.antiAliasing", Boolean.TRUE);
        glow.setBrushColor(Colors.getColor("ORANGERED"));
        localMap.put("GJAbstractPlot.selection", glow);
        localMap.put("GJAnnotation.lineColor", Color.black);
        localMap.put("GJAnnotation.textColor", Color.black);
        localMap.put("GJAnnotation.textBackground", Color.lightGray);
        localMap.put("GJAnnotation.fill", Color.lightGray);
        localMap.put("Clipboard.formatSVG", Boolean.TRUE);
        localMap.put("Clipboard.formatSVGAsText", Boolean.TRUE);
        localMap.put("Clipboard.formatPS", Boolean.FALSE);
        localMap.put("Clipboard.formatEPS", Boolean.FALSE);
        localMap.put("Clipboard.formatPDF", Boolean.TRUE);
        localMap.put("SVG.inline", Boolean.FALSE);
        localMap.put("SVG.jsLocation", "./canvg-min.js");
        localMap.put("SVG.cssLocation", "./WSVGGraphics2D.css");
        localMap.put("SVG.httpd", Boolean.TRUE);
        localMap.put("SVG.canvg", Boolean.TRUE);
        localMap.put("SVG.userHTML", "");
        localMap.put("Processing.jsLocation", "./processing.js");
        localMap.put("Processing.cssLocation", "./PDEGraphics2D.css");
        localMap.put("Processing.httpd", Boolean.TRUE);
        localMap.put("Processing.userHTML", "");
        return localMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDeserializing(Boolean flag) {
        GJDefaults gJDefaults = instance;
        synchronized (gJDefaults) {
            Deserializing.set(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDeserializing() {
        GJDefaults gJDefaults = instance;
        synchronized (gJDefaults) {
            return Deserializing.get();
        }
    }

    private static void setMap2() {
        map2.put("GJAbstractGraphContainer.keyAntialiasing", RenderingHints.VALUE_ANTIALIAS_ON);
        map2.put("GJAbstractGraphContainer.textAntialiasing", RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        map2.put("GJAbstractGraph.keyAntialiasing", map2.get("GJAbstractGraphContainer.keyAntialiasing"));
        map2.put("GJAbstractGraph.textAntialiasing", map2.get("GJAbstractGraphContainer.textAntialiasing"));
        map2.put("GJAbstractVisualModel.keyAntialiasing", map2.get("GJAbstractGraphContainer.keyAntialiasing"));
        map2.put("GJAbstractVisualModel.textAntialiasing", map2.get("GJAbstractGraphContainer.textAntialiasing"));
        map2.put("DeployMode", "svg");
        map2.put("DeveloperMode", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getDataClass() {
        GJDefaults gJDefaults = instance;
        synchronized (gJDefaults) {
            return dataClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDataClass(Class aDataClass) {
        GJDefaults gJDefaults = instance;
        synchronized (gJDefaults) {
            dataClass = aDataClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<String, Object> getMap() {
        GJDefaults gJDefaults = instance;
        synchronized (gJDefaults) {
            return new LinkedHashMap<String, Object>(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMap(LinkedHashMap<String, Object> input) {
        GJDefaults gJDefaults = instance;
        synchronized (gJDefaults) {
            map = new LinkedHashMap<String, Object>(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyEntries(LinkedHashMap<String, Object> input) {
        GJDefaults gJDefaults = instance;
        synchronized (gJDefaults) {
            for (String key : input.keySet()) {
                if (!map.containsKey(key) || !input.get(key).getClass().isAssignableFrom(map.get(key).getClass())) continue;
                map.put(key, input.get(key));
            }
        }
    }

    public static LinkedHashMap<String, Object> getMap2() {
        return new LinkedHashMap<String, Object>(map2);
    }

    public static String getPreferencesFolder() {
        String USER_HOME = System.getProperty("user.home");
        String PREFS_FILENAME = USER_HOME + File.separator + ".jehep" + File.separator + "waterlooSettings" + File.separator;
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("windows") > -1 || OS.indexOf("nt") > -1) {
            PREFS_FILENAME = USER_HOME + File.separator + "jehep" + File.separator + "waterlooSettings" + File.separator;
        }
        return PREFS_FILENAME;
    }

    private static boolean createPreferencesFolder(File folder) {
        String s = "<html>Waterloo wants to create folder<br>" + folder.getPath() + "<br>Is that OK?</html>";
        int ok = JOptionPane.showConfirmDialog(null, s, "Create Preferences Folder", 0);
        boolean TF = false;
        if (ok == 0) {
            TF = folder.mkdir();
        }
        if (ok == 0 && !TF) {
            JOptionPane.showMessageDialog(null, "Folder creation failed", "Create Preferences Folder", 0);
        }
        return TF;
    }

    public static void editDefaults() {
        PreferencesDialog dialog = PreferencesDialog.getInstance();
        LocalActionListener.getInstance().setDialog(dialog);
        dialog.getApplyButton().addActionListener(LocalActionListener.getInstance());
        dialog.getCancelButton().addActionListener(LocalActionListener.getInstance());
        dialog.getSaveButton().addActionListener(LocalActionListener.getInstance());
        dialog.getLoadButton().addActionListener(LocalActionListener.getInstance());
        dialog.getResetButton().addActionListener(LocalActionListener.getInstance());
        GJDefaults.setupDialog(dialog);
        dialog.setVisible(true);
    }

    private static void setupDialog(PreferencesDialog dialog) {
        GJGraphContainer gr = GJGraphContainer.createInstance(GJGraph.createInstance());
        gr.setAspectRatio(1.0);
        gr.getView().setAxesBounds(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        GJPlotInterface scatter = GJScatter.createInstance();
        scatter.setXData(new double[]{-0.5, -0.25, 0.0, 0.25, 0.5});
        scatter.setYData(new double[]{-0.5, -0.25, 0.0, 0.25, 0.5});
        gr.getView().add(scatter);
        GJPlotInterface line = GJLine.createInstance();
        scatter.add(line);
        gr.getView().autoScale();
        LocalActionListener.getInstance().setPreview(gr);
        dialog.getPreviewPanel().add((Component)gr, "Center");
        GJDefaults.initDialog(dialog);
        GJDefaults.installDialogListeners(dialog);
    }

    private static void initDialog(PreferencesDialog dialog) {
        dialog.getAxesColorCombo().setMap(Colors.getColors());
        dialog.getAxesColorCombo().setSelectedColor((Color)map.get("GJAbstractGraph.axisColor"));
        dialog.getAxisWeightCombo().setSelectedItem(map.get("GJAbstractGraph.axisStroke"));
        dialog.getMajorGridColorCombo().setMap(Colors.getColors());
        dialog.getMajorGridColorCombo().setSelectedColor((Color)map.get("GJAbstractGraph.majorGridColor"));
        dialog.getMajorGridWeigthCombo().setSelectedItem(map.get("GJAbstractGraph.majorGridStrokeWeight"));
        dialog.getMinorGridColorCombo().setMap(Colors.getColors());
        dialog.getMinorGridColorCombo().setSelectedColor((Color)map.get("GJAbstractGraph.minorGridColor"));
        dialog.getMinorGridWeigthCombo().setSelectedItem(map.get("GJAbstractGraph.minorGridStrokeWeight"));
        dialog.getLeftAxisPainted().setSelected((Boolean)map.get("GJGraph.leftAxisPainted"));
        dialog.getRightAxisPainted().setSelected((Boolean)map.get("GJGraph.rightAxisPainted"));
        dialog.getTopAxisPainted().setSelected((Boolean)map.get("GJGraph.topAxisPainted"));
        dialog.getBottomAxisPainted().setSelected((Boolean)map.get("GJGraph.bottomAxisPainted"));
        dialog.getLeftAxisLabelled().setSelected((Boolean)map.get("GJGraph.leftAxisLabelled"));
        dialog.getRightAxisLabelled().setSelected((Boolean)map.get("GJGraph.rightAxisLabelled"));
        dialog.getTopAxisLabelled().setSelected((Boolean)map.get("GJGraph.topAxisLabelled"));
        dialog.getBottomAxisLabelled().setSelected((Boolean)map.get("GJGraph.bottomAxisLabelled"));
        dialog.getInnerAxisPainted().setSelected((Boolean)map.get("GJAbstractGraph.innerAxisPainted"));
        dialog.getMinorGridPainted().setSelected((Boolean)map.get("GJAbstractGraph.minorGridPainted"));
        dialog.getMajorGridPainted().setSelected((Boolean)map.get("GJAbstractGraph.majorGridPainted"));
        dialog.getInnerAxisLabelled().setSelected((Boolean)map.get("GJAbstractGraph.innerAxisLabelled"));
        dialog.getXDivSpinner().setValue((int)((Integer)map.get("GJAbstractGraph.minorCountXHint")));
        dialog.getXDivSpinner().addChangeListener(LocalStateChangeListener.getInstance());
        dialog.getYDivSpinner().setValue((int)((Integer)map.get("GJAbstractGraph.minorCountYHint")));
        dialog.getYDivSpinner().addChangeListener(LocalStateChangeListener.getInstance());
        dialog.getContainerBackground().setMap(Colors.getColors());
        dialog.getContainerBackground().setSelectedColor((Color)map.get("GJAbstractGraphContainer.backgroundColor"));
        dialog.getContainerBackgroundPainted().setSelected((Boolean)map.get("GJAbstractGraphContainer.backgroundPainted"));
        dialog.getViewBackground().setMap(Colors.getColors());
        dialog.getViewBackground().setSelectedColor((Color)map.get("GJAbstractGraph.backgroundColor"));
        dialog.getViewBackgroundPainted().setSelected((Boolean)map.get("GJAbstractGraph.backgroundPainted"));
        dialog.getPadAxes().setSelected((Boolean)map.get("GJAbstractGraph.tightAxes"));
        dialog.getAxisPadding().setSelectedItem((Double)map.get("GJAbstractGraph.axesPadding") * 100.0);
        dialog.getMarkerSymbol().setSelectedItem(map.get("GJAbstractPlot.markerSymbol"));
        dialog.getMarkerFill().setMap(Colors.getColors());
        dialog.getMarkerFill().setSelectedColor((Color)map.get("GJAbstractPlot.fill"));
        dialog.getMarkerEdgeColor().setMap(Colors.getColors());
        dialog.getMarkerEdgeColor().setSelectedColor((Color)map.get("GJAbstractPlot.edgeColor"));
        dialog.getMarkerSize().setSelectedItem(map.get("GJAbstractPlot.markerSize"));
        dialog.getMarkerEdgeWeight().setSelectedItem(map.get("GJAbstractPlot.edgeStrokeWidth"));
        dialog.getLineWeight().setSelectedItem(map.get("GJAbstractPlot.lineStrokeWidth"));
        dialog.getLineColor().setMap(Colors.getColors());
        dialog.getLineColor().setSelectedColor((Color)map.get("GJAbstractPlot.lineColor"));
        Color color = ((GlowPathEffect)map.get("GJAbstractPlot.selection")).getBrushColor();
        dialog.getHighlightColor().setMap(Colors.getColors());
        dialog.getHighlightColor().setSelectedColor(color);
        dialog.getAntialiased().setSelected((Boolean)map.get("GJAbstractPlot.antiAliasing"));
        dialog.getFormatEPS().setSelected((Boolean)map.get("Clipboard.formatEPS"));
        dialog.getFormatPS().setSelected((Boolean)map.get("Clipboard.formatPS"));
        dialog.getFormatSVG().setSelected((Boolean)map.get("Clipboard.formatSVG"));
        dialog.getFormatSVGAsText().setSelected((Boolean)map.get("Clipboard.formatSVGAsText"));
        dialog.getFormatPDF().setSelected((Boolean)map.get("Clipboard.formatPDF"));
        dialog.getSvgCSSLoc().setSelectedItem(map.get("SVG.cssLocation"));
        dialog.getSvgJSLoc().setSelectedItem(map.get("SVG.jsLocation"));
        dialog.getSvgHTTPD().setSelected((Boolean)map.get("SVG.httpd"));
        dialog.getInline().setSelected((Boolean)map.get("SVG.inline"));
        dialog.getCanvg().setSelected((Boolean)map.get("SVG.canvg"));
        dialog.getCssLocation().setSelectedItem(map.get("Processing.cssLocation"));
        dialog.getJavaScriptLocation().setSelectedItem(map.get("Processing.jsLocation"));
        dialog.getHttpd().setSelected((Boolean)map.get("Processing.httpd"));
    }

    private static void installDialogListeners(PreferencesDialog dialog) {
        LocalActionListener listener = LocalActionListener.getInstance();
        dialog.getAxesColorCombo().addActionListener(listener);
        dialog.getAxisWeightCombo().addActionListener(listener);
        dialog.getMajorGridColorCombo().addActionListener(listener);
        dialog.getMajorGridWeigthCombo().addActionListener(listener);
        dialog.getMinorGridColorCombo().addActionListener(listener);
        dialog.getMinorGridWeigthCombo().addActionListener(listener);
        dialog.getLeftAxisPainted().addActionListener(listener);
        dialog.getRightAxisPainted().addActionListener(listener);
        dialog.getTopAxisPainted().addActionListener(listener);
        dialog.getBottomAxisPainted().addActionListener(listener);
        dialog.getLeftAxisLabelled().addActionListener(listener);
        dialog.getRightAxisLabelled().addActionListener(listener);
        dialog.getTopAxisLabelled().addActionListener(listener);
        dialog.getBottomAxisLabelled().addActionListener(listener);
        dialog.getInnerAxisPainted().addActionListener(listener);
        dialog.getMinorGridPainted().addActionListener(listener);
        dialog.getMajorGridPainted().addActionListener(listener);
        dialog.getInnerAxisLabelled().addActionListener(listener);
        dialog.getContainerBackground().addActionListener(listener);
        dialog.getContainerBackgroundPainted().addActionListener(listener);
        dialog.getViewBackground().addActionListener(listener);
        dialog.getViewBackgroundPainted().addActionListener(listener);
        dialog.getPadAxes().addActionListener(listener);
        dialog.getAxisPadding().addActionListener(listener);
        dialog.getMarkerSymbol().addActionListener(listener);
        dialog.getMarkerSize().addActionListener(listener);
        dialog.getMarkerFill().addActionListener(listener);
        dialog.getMarkerEdgeColor().addActionListener(listener);
        dialog.getMarkerEdgeWeight().addActionListener(listener);
        dialog.getHighlightColor().addActionListener(listener);
        dialog.getLineColor().addActionListener(listener);
        dialog.getLineWeight().addActionListener(listener);
        dialog.getLineStyle().addActionListener(listener);
        dialog.getAntialiased().addActionListener(listener);
        dialog.getFormatEPS().addActionListener(listener);
        dialog.getFormatPS().addActionListener(listener);
        dialog.getFormatSVG().addActionListener(listener);
        dialog.getFormatSVGAsText().addActionListener(listener);
        dialog.getFormatPDF().addActionListener(listener);
        dialog.getSvgCSSLoc().addActionListener(listener);
        dialog.getSvgHTTPD().addActionListener(listener);
        dialog.getSvgJSLoc().addActionListener(listener);
        dialog.getInline().addActionListener(listener);
        dialog.getCssLocation().addActionListener(listener);
        dialog.getJavaScriptLocation().addActionListener(listener);
        dialog.getHttpd().addActionListener(listener);
        dialog.getXDivSpinner().addChangeListener(LocalStateChangeListener.getInstance());
        dialog.getYDivSpinner().addChangeListener(LocalStateChangeListener.getInstance());
    }

    private static File getDefaultsFile() {
        File newFile;
        String s = GJDefaults.getPreferencesFolder();
        String USER_HOME = System.getProperty("user.home");
        String PREFS_FILENAME = USER_HOME + File.separator + ".jehep" + File.separator + "waterlooSettings" + File.separator + "waterloo-preferences.xml";
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("windows") > -1 || OS.indexOf("nt") > -1) {
            PREFS_FILENAME = USER_HOME + File.separator + "jehep" + File.separator + "waterlooSettings" + File.separator + "waterloo-preferences.xml";
        }
        if (!(newFile = new File(PREFS_FILENAME)).canWrite()) {
            newFile.setWritable(true);
        }
        return newFile;
    }

    private static void saveMap(File file, LinkedHashMap<String, Object> localMap) {
        int ok;
        if (file.isFile()) {
            ok = JOptionPane.showConfirmDialog(null, "Overwrite existing file", "Create Preferences File", 0);
            file.renameTo(new File(file.getPath().concat(".backup")));
        } else {
            ok = JOptionPane.showConfirmDialog(null, "<html>Create preferences file<br>" + file.getPath() + "</html>", "Create Preferences File", 0);
        }
        if (ok == 0) {
            FileOutputStream buffer;
            try {
                buffer = new FileOutputStream(file);
            }
            catch (FileNotFoundException ex) {
                logger.error(ex.getMessage());
                return;
            }
            Thread.currentThread().setContextClassLoader(GJDefaults.class.getClassLoader());
            XMLEncoder e = new XMLEncoder(buffer);
            GJEncoder.addDelegates(e);
            e.writeObject(localMap);
            e.close();
            try {
                buffer.close();
            }
            catch (IOException ex) {
                logger.error("Buffer closure failed");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LinkedHashMap<String, Object> readPreferencesFile(File file, boolean silent) {
        FileInputStream buffer;
        int ok;
        if (!silent) {
            if (!file.isFile()) {
                JOptionPane.showMessageDialog(null, "File does not exist", "Load Preferences File", 1);
                return GJDefaults.getMap();
            }
            ok = JOptionPane.showConfirmDialog(null, "Load existing file", "Load Preferences File", 0);
        } else {
            ok = 0;
        }
        if (ok != 0) return GJDefaults.getMap();
        try {
            buffer = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            logger.error(ex.getMessage());
            return null;
        }
        Thread.currentThread().setContextClassLoader(GJDefaults.class.getClassLoader());
        XMLDecoder e = new XMLDecoder(buffer);
        LinkedHashMap localMap = (LinkedHashMap)e.readObject();
        e.close();
        try {
            buffer.close();
            return localMap;
        }
        catch (IOException ex) {
            logger.error("Buffer closure failed");
            return null;
        }
    }

    private static class LocalActionListener
    implements ActionListener {
        private static LocalActionListener instance = new LocalActionListener();
        private GJGraphContainer preview;
        private LinkedHashMap<String, Object> localMap = GJDefaults.getMap();
        private PreferencesDialog dialog;

        private LocalActionListener() {
        }

        static LocalActionListener getInstance() {
            return instance;
        }

        private void setPreview(GJGraphContainer preview) {
            this.preview = preview;
        }

        private void setDialog(PreferencesDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("leftAxisPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJGraph.leftAxisPainted", thisComponent.isSelected());
                this.localMap.put("GJGraph.leftAxisLabelled", thisComponent.isSelected());
                this.dialog.getLeftAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setLeftAxisPainted(thisComponent.isSelected());
                this.preview.getView().setLeftAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("rightAxisPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJGraph.rightAxisPainted", thisComponent.isSelected());
                this.localMap.put("GJGraph.rightAxisLabelled", thisComponent.isSelected());
                this.dialog.getRightAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setRightAxisPainted(thisComponent.isSelected());
                this.preview.getView().setRightAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("topAxisPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJGraph.topAxisPainted", thisComponent.isSelected());
                this.localMap.put("GJGraph.topAxisLabelled", thisComponent.isSelected());
                this.dialog.getTopAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setTopAxisPainted(thisComponent.isSelected());
                this.preview.getView().setTopAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("bottomAxisPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJGraph.bottomAxisPainted", thisComponent.isSelected());
                this.localMap.put("GJGraph.bottomAxisLabelled", thisComponent.isSelected());
                this.dialog.getBottomAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setBottomAxisPainted(thisComponent.isSelected());
                this.preview.getView().setBottomAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("leftAxisLabelled")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJGraph.leftAxisLabelled", thisComponent.isSelected());
                this.dialog.getLeftAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setLeftAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("rightAxisLabelled")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJGraph.rightAxisLabelled", thisComponent.isSelected());
                this.dialog.getRightAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setRightAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("topAxisLabelled")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJGraph.topAxisLabelled", thisComponent.isSelected());
                this.dialog.getTopAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setTopAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("bottomAxisLabelled")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJGraph.bottomAxisLabelled", thisComponent.isSelected());
                this.dialog.getBottomAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setBottomAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("axisColor")) {
                GJColorComboBox thisComponent = (GJColorComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.axisColor", thisComponent.getSelectedColor());
                this.preview.getView().setAxisColor(thisComponent.getSelectedColor());
            } else if (command.equals("axisWeight")) {
                JComboBox thisComponent = (JComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.axisStroke", thisComponent.getSelectedItem());
                this.preview.getView().setAxisStrokeWeight(((Float)thisComponent.getSelectedItem()).floatValue());
            } else if (command.equals("majorGridColor")) {
                GJColorComboBox thisComponent = (GJColorComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.majorGridColor", thisComponent.getSelectedColor());
                this.preview.getView().setMajorGridColor(thisComponent.getSelectedColor());
            } else if (command.equals("minorGridColor")) {
                GJColorComboBox thisComponent = (GJColorComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.minorGridColor", thisComponent.getSelectedColor());
                this.preview.getView().setMinorGridColor(thisComponent.getSelectedColor());
            } else if (command.equals("minorGridStrokeWeight")) {
                JComboBox thisComponent = (JComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.minorGridStrokeWeight", thisComponent.getSelectedItem());
                this.preview.getView().setMinorGridStrokeWeight(((Float)thisComponent.getSelectedItem()).floatValue());
            } else if (command.equals("majorGridStrokeWeight")) {
                JComboBox thisComponent = (JComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.majorGridStrokeWeight", thisComponent.getSelectedItem());
                this.preview.getView().setMajorGridStrokeWeight(((Float)thisComponent.getSelectedItem()).floatValue());
            } else if (command.equals("innerAxisPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.innerAxisPainted", thisComponent.isSelected());
                this.preview.getView().setInnerAxisPainted(thisComponent.isSelected());
                this.dialog.getInnerAxisLabelled().setSelected(thisComponent.isSelected());
                this.preview.getView().setInnerAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("innerAxisLabelled")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.innerAxisLabelled", thisComponent.isSelected());
                this.preview.getView().setInnerAxisLabelled(thisComponent.isSelected());
            } else if (command.equals("majorGridPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.majorGridPainted", thisComponent.isSelected());
                this.preview.getView().setMajorGridPainted(thisComponent.isSelected());
            } else if (command.equals("minorGridPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.minorGridPainted", thisComponent.isSelected());
                this.preview.getView().setMinorGridPainted(thisComponent.isSelected());
            } else if (command.equals("containerBackground")) {
                GJColorComboBox thisComponent = (GJColorComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraphContainer.backgroundColor", thisComponent.getSelectedColor());
                this.preview.setBackground(thisComponent.getSelectedColor());
            } else if (command.equals("containerBackgroundPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJAbstractGraphContainer.containerBackgroundPainted", thisComponent.isSelected());
                this.preview.setBackgroundPainted(thisComponent.isSelected());
            } else if (command.equals("viewBackground")) {
                GJColorComboBox thisComponent = (GJColorComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.backgroundColor", thisComponent.getSelectedColor());
                ((GJAbstractGraph)this.preview.getView()).setBackground(thisComponent.getSelectedColor());
            } else if (command.equals("viewBackgroundPainted")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.viewBackgroundPainted", thisComponent.isSelected());
                this.preview.getView().setBackgroundPainted(thisComponent.isSelected());
            } else if (command.equals("padAxes")) {
                JToggleButton thisComponent = (JToggleButton)ae.getSource();
                this.localMap.put("GJAbstractGraph.tightAxes", Boolean.valueOf(thisComponent.isSelected()) == false);
                ((GJAbstractGraph)this.preview.getView()).setTightAxes(!thisComponent.isSelected());
                this.preview.getView().autoScale();
            } else if (command.equals("axesPadding")) {
                JComboBox thisComponent = (JComboBox)ae.getSource();
                this.localMap.put("GJAbstractGraph.axesPadding", (Double)thisComponent.getSelectedItem() / 100.0);
                ((GJAbstractGraph)this.preview.getView()).setAxesPadding((Double)thisComponent.getSelectedItem() / 100.0);
                this.preview.getView().autoScale();
            } else if (command.equals("markerSymbol") || command.equals("markerSize") || command.equals("markerEdgeWeight") || command.equals("markerEdgeColor") || command.equals("markerFill")) {
                JComboBox<String> symbolCombo = this.dialog.getMarkerSymbol();
                String symbol = (String)symbolCombo.getSelectedItem();
                JComboBox<Double> sizeCombo = this.dialog.getMarkerSize();
                double markerWidth = (Double)sizeCombo.getSelectedItem();
                if (symbol.equals("Dot")) {
                    markerWidth = 0.5;
                }
                JComboBox<Float> edgeCombo = this.dialog.getMarkerEdgeWeight();
                float edgeWeight = ((Float)edgeCombo.getSelectedItem()).floatValue();
                GJColorComboBox edgeColorCombo = this.dialog.getMarkerEdgeColor();
                Color edgeColor = edgeColorCombo.getSelectedColor();
                GJColorComboBox markerFillCombo = this.dialog.getMarkerFill();
                Color fill = markerFillCombo.getSelectedColor();
                if (command.equals("markerSymbol")) {
                    this.localMap.put("GJAbstractPlot.markerSymbol", symbolCombo.getSelectedItem());
                    this.preview.getView().getPlots().get(0).setMarker(0, GJMarker.getMarker(symbol, markerWidth));
                } else if (command.equals("markerEdgeWeight")) {
                    this.localMap.put("GJAbstractPlot.edgeStrokeWidth", Float.valueOf(edgeWeight));
                    this.preview.getView().getPlots().get(0).setEdgeStroke(new BasicStroke(edgeWeight));
                } else if (command.equals("markerSize")) {
                    this.localMap.put("GJAbstractPlot.markerSize", markerWidth);
                    this.preview.getView().getPlots().get(0).setMarker(0, GJMarker.getMarker(symbol, markerWidth));
                } else if (command.equals("markerFill")) {
                    this.localMap.put("GJAbstractPlot.fill", fill);
                    this.preview.getView().getPlots().get(0).setFill(fill);
                } else if (command.equals("markerEdgeColor")) {
                    this.localMap.put("GJAbstractPlot.edgeColor", edgeColor);
                    this.preview.getView().getPlots().get(0).setEdgeColor(edgeColor);
                }
                this.preview.getView().autoScale();
            } else if (command.equals("highlightColor")) {
                Color highlightColor = this.dialog.getHighlightColor().getSelectedColor();
                ((GlowPathEffect)this.localMap.get("GJAbstractPlot.selection")).setBrushColor(highlightColor);
            } else if (command.equals("lineColor") || command.equals("lineWeight") || command.equals("lineStyle")) {
                GJColorComboBox colorCombo = this.dialog.getLineColor();
                Color lineColor = colorCombo.getSelectedColor();
                JComboBox<Float> lineWeightCombo = this.dialog.getLineWeight();
                float weight = ((Float)lineWeightCombo.getSelectedItem()).floatValue();
                JComboBox<String> lineStyleCombo = this.dialog.getLineStyle();
                String lineStyle = (String)lineStyleCombo.getSelectedItem();
                if (command.equals("lineColor")) {
                    this.localMap.put("GJAbstractPlot.lineColor", lineColor);
                    this.preview.getView().getPlots().get(0).getNode().get(1).setLineColor(lineColor);
                } else if (command.equals("lineWeight")) {
                    this.localMap.put("GJAbstractPlot.lineStrokeWidth", Float.valueOf(weight));
                    this.preview.getView().getPlots().get(0).getNode().get(1).setLineStroke(GJUtilities.makeStroke(weight, lineStyle));
                } else if (command.equals("lineStyle")) {
                    this.localMap.put("GJAbstractPlot.lineStyle", lineStyle);
                    this.preview.getView().getPlots().get(0).getNode().get(1).setLineStroke(GJUtilities.makeStroke(weight, lineStyle));
                }
            } else if (command.equals("antiAliased")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                if (thisComponent.isSelected()) {
                    this.preview.getView().getPlots().get(0).getNode().get(1).setAntialiasing(true);
                    this.preview.getView().getPlots().get(0).setAntialiasing(true);
                    this.localMap.put("GJAbstractPlot.antiAliasing", Boolean.TRUE);
                } else {
                    this.preview.getView().getPlots().get(0).getNode().get(1).setAntialiasing(false);
                    this.preview.getView().getPlots().get(0).setAntialiasing(false);
                    this.localMap.put("GJAbstractPlot.antiAliasing", Boolean.FALSE);
                }
            } else if (command.equals("formatSVG")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("Clipboard.formatSVG", thisComponent.isSelected());
                this.dialog.getFormatPDF().setSelected(thisComponent.isSelected());
                this.localMap.put("Clipboard.formatPDF", thisComponent.isSelected());
                this.dialog.getFormatSVGAsText().setSelected(thisComponent.isSelected());
                this.localMap.put("Clipboard.formatSVGAsText", thisComponent.isSelected());
            } else if (command.equals("formatSVGAsText")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("Clipboard.formatSVGAsText", thisComponent.isSelected());
            } else if (command.equals("formatEPS")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("Clipboard.formatEPS", thisComponent.isSelected());
            } else if (command.equals("formatPS")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("Clipboard.formatPS", thisComponent.isSelected());
            } else if (command.equals("formatPDF")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("Clipboard.formatPDF", thisComponent.isSelected());
            } else if (command.equals("httpd")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("Processing.httpd", thisComponent.isSelected());
            } else if (command.equals("cssLocation")) {
                JComboBox thisComponent = (JComboBox)ae.getSource();
                this.localMap.put("Processing.cssLocation", thisComponent.getSelectedItem());
            } else if (command.equals("javaScriptLocation")) {
                JComboBox thisComponent = (JComboBox)ae.getSource();
                this.localMap.put("Processing.jsLocation", thisComponent.getSelectedItem());
            } else if (command.equals("svgInline")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("SVG.inline", thisComponent.isSelected());
            } else if (command.equals("canvg")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("SVG.canvg", thisComponent.isSelected());
            } else if (command.equals("svgHTTPD")) {
                JCheckBox thisComponent = (JCheckBox)ae.getSource();
                this.localMap.put("SVG.httpd", thisComponent.isSelected());
            } else if (command.equals("svgCSSLoc")) {
                JComboBox thisComponent = (JComboBox)ae.getSource();
                this.localMap.put("SVG.cssLocation", thisComponent.getSelectedItem());
            } else if (command.equals("canvgLoc")) {
                JComboBox thisComponent = (JComboBox)ae.getSource();
                this.localMap.put("SVG.jsLocation", thisComponent.getSelectedItem());
            } else if (command.equals("Apply")) {
                GJDefaults.copyEntries(this.localMap);
            } else if (command.equals("Save")) {
                GJDefaults.copyEntries(this.localMap);
                GJDefaults.saveMap(GJDefaults.getDefaultsFile(), map);
            } else if (command.equals("Cancel")) {
                this.dialog.dispose();
            } else if (command.equals("Reset")) {
                map = GJDefaults.getDefaultDefaults();
                GJDefaults.initDialog(this.dialog);
            } else if (command.equals("Load")) {
                GJDefaults.copyEntries(GJDefaults.readPreferencesFile(GJDefaults.getDefaultsFile(), false));
                GJDefaults.initDialog(this.dialog);
            }
            this.preview.revalidate();
            this.preview.repaint();
        }
    }

    private static class LocalStateChangeListener
    implements ChangeListener {
        private static final LocalStateChangeListener instance = new LocalStateChangeListener();

        private LocalStateChangeListener() {
        }

        static LocalStateChangeListener getInstance() {
            return instance;
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            String command = ((Component)ce.getSource()).getName();
            if (command.equals("$XDivSpinner")) {
                JSpinner thisComponent = (JSpinner)ce.getSource();
                LocalActionListener.instance.localMap.put("GJAbstractGraph.minorCountXHint", thisComponent.getValue());
                LocalActionListener.instance.preview.getView().setMinorCountXHint((Integer)thisComponent.getValue());
            } else if (command.equals("$YDivSpinner")) {
                JSpinner thisComponent = (JSpinner)ce.getSource();
                LocalActionListener.instance.localMap.put("GJAbstractGraph.minorCountYHint", thisComponent.getValue());
                LocalActionListener.instance.preview.getView().setMinorCountYHint((Integer)thisComponent.getValue());
            }
        }
    }
}

