/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.annotation;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kcl.waterloo.annotation.GJAnnotationInterface;
import kcl.waterloo.defaults.GJDefaults;
import kcl.waterloo.graphics.GJGraphInterface;
import kcl.waterloo.marker.GJMarker;

public abstract class GJAnnotation
implements GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font> {
    private GJGraphInterface parentGraph = null;
    private String text = "";
    private GJMarker marker = null;
    private GJMarker extra = null;
    private Stroke lineStroke = null;
    private Paint lineColor = (Paint)GJDefaults.getMap().get("GJAnnotation.lineColor");
    private Paint textColor = (Paint)GJDefaults.getMap().get("GJAnnotation.textColor");
    private Paint textBackground = (Paint)GJDefaults.getMap().get("GJAnnotation.textBackground");
    private Paint fill = (Paint)GJDefaults.getMap().get("GJAnnotation.fill");
    private double xData = 0.0;
    private double yData = 0.0;
    private String name = "";
    private Font font = new Font("Sans Serif", 0, 10);
    private int lineTextPosition = 1;

    @Override
    public Path2D getPath() {
        if (this.marker == null) {
            return null;
        }
        return this.getMarker().getPath();
    }

    @Override
    public void setPath(Path2D p) {
        this.setMarker(new GJMarker(p));
    }

    @Override
    public GJGraphInterface getParentGraph() {
        return this.parentGraph;
    }

    @Override
    public void setExtra(GJMarker p) {
        this.extra = p;
    }

    @Override
    public GJMarker getExtra() {
        return this.extra;
    }

    @Override
    public void setParentGraph(GJGraphInterface gr) {
        this.parentGraph = gr;
    }

    @Override
    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    @Override
    public void setLineStroke(Stroke LineStroke) {
        this.lineStroke = LineStroke;
    }

    @Override
    public Paint getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Paint LineColor) {
        this.lineColor = LineColor;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font Font2) {
        this.font = Font2;
    }

    @Override
    public Paint getFill() {
        return this.fill;
    }

    @Override
    public void setFill(Paint Fill) {
        this.fill = Fill;
    }

    @Override
    public GJMarker getMarker() {
        return this.marker;
    }

    @Override
    public void setMarker(GJMarker Marker2) {
        this.marker = Marker2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String Name) {
        this.name = Name;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String Text) {
        this.text = Text;
    }

    @Override
    public double getXData() {
        return this.xData;
    }

    @Override
    public void setXData(double X) {
        this.xData = X;
    }

    @Override
    public double getYData() {
        return this.yData;
    }

    @Override
    public void setYData(double Y) {
        this.yData = Y;
    }

    @Override
    public Paint getTextColor() {
        return this.textColor;
    }

    @Override
    public void setTextColor(Paint TextColor) {
        this.textColor = TextColor;
    }

    public int getLineTextPosition() {
        return this.lineTextPosition;
    }

    public void setLineTextPosition(int pos) {
        this.lineTextPosition = pos;
    }

    @Override
    public void remove() {
        if (this.getParentGraph() != null && this.getParentGraph().getGraphContainer() != null) {
            this.getParentGraph().getGraphContainer().getAnnotations().remove(this);
        }
    }

    @Override
    public void remove(String name) {
        if (this.getParentGraph() != null && this.getParentGraph().getGraphContainer() != null) {
            for (GJAnnotationInterface<Path2D, GJGraphInterface, Stroke, Paint, Font> a : this.getParentGraph().getGraphContainer().getAnnotations()) {
                if (!a.getName().matches(name)) continue;
                a.remove();
            }
        }
    }

    @Override
    public void paintAnnotation(Graphics2D g2, AffineTransform af) {
        if (this.lineStroke == null) {
            this.lineStroke = new BasicStroke(1.0f);
        }
        float X = 0.0f;
        float Y = 0.0f;
        if (this instanceof TextAnnotation) {
            if (!this.text.isEmpty()) {
                g2.setFont(this.font);
                FontMetrics metrics = g2.getFontMetrics(this.font);
                Rectangle2D lineBounds = metrics.getStringBounds(this.text, g2);
                Point2D pt = af.transform(new Point2D.Double(this.getXData(), this.getYData()), null);
                if (this.textBackground != null || this.lineColor != null) {
                    Rectangle2D.Double r = new Rectangle2D.Double(pt.getX() - 5.0, pt.getY() - lineBounds.getBounds2D().getHeight() - 3.0, lineBounds.getBounds2D().getWidth() + 10.0, lineBounds.getBounds2D().getHeight() + 10.0);
                    GJMarker marker2 = new GJMarker(r);
                    Path2D p = marker2.getPath();
                    if (this.textBackground != null) {
                        g2.setPaint(this.textBackground);
                        g2.fill(p);
                    }
                    if (this.lineColor != null) {
                        g2.setPaint(this.getLineColor());
                        g2.setStroke(this.getLineStroke());
                        g2.draw(p);
                    }
                }
                g2.setPaint(this.getTextColor());
                g2.setStroke(this.getLineStroke());
                g2.drawString(this.text, (float)pt.getX(), (float)pt.getY());
            }
        } else if (this instanceof ShapeAnnotation) {
            Path2D p = this.getPath();
            p.transform(af);
            Paint f = this.getFill();
            if (f != null) {
                g2.setPaint(f);
                g2.fill(p);
            }
            g2.setPaint(this.getLineColor());
            g2.setStroke(this.getLineStroke());
            g2.draw(p);
            if (!this.text.isEmpty()) {
                g2.setFont(this.font);
                FontMetrics metrics = g2.getFontMetrics();
                Rectangle2D lineBounds = metrics.getStringBounds(this.text, g2);
                X = (float)(p.getBounds2D().getCenterX() - lineBounds.getCenterX());
                Y = (float)(p.getBounds2D().getCenterY() + (double)metrics.getLineMetrics(this.text, g2).getDescent());
                g2.drawString(this.text, X, Y);
            }
        } else if (this instanceof LineAnnotation || this instanceof ArrowAnnotation) {
            Path2D p = this.getPath();
            p.transform(af);
            g2.setPaint(this.getLineColor());
            g2.setStroke(this.getLineStroke());
            g2.draw(p);
            if (this instanceof ArrowAnnotation && this.fill != null) {
                Path2D p2 = this.getExtra().getPath();
                p2.transform(af);
                g2.setPaint(this.fill);
                g2.fill(p2);
            }
            if (!this.text.isEmpty()) {
                g2.setFont(this.font);
                FontMetrics metrics = g2.getFontMetrics();
                Rectangle2D lineBounds = metrics.getStringBounds(this.text, g2);
                if (this.lineTextPosition == 1) {
                    X = (float)(p.getBounds2D().getCenterX() - lineBounds.getCenterX());
                    Y = (float)(p.getBounds2D().getY() - (double)metrics.getLineMetrics(this.text, g2).getHeight());
                    g2.drawString(this.text, X, Y);
                } else if (this.lineTextPosition == 2) {
                    X = (float)(p.getBounds2D().getX() + p.getBounds().getWidth() - lineBounds.getCenterX());
                    Y = (float)(p.getBounds2D().getY() - (double)metrics.getLineMetrics(this.text, g2).getHeight());
                    g2.drawString(this.text, X, Y);
                } else if (this.lineTextPosition == 8) {
                    X = (float)(p.getBounds().getX() - lineBounds.getCenterX());
                    Y = (float)(p.getBounds2D().getY() - (double)metrics.getLineMetrics(this.text, g2).getHeight());
                    g2.drawString(this.text, X, Y);
                } else if (this.lineTextPosition == 5) {
                    X = (float)(p.getBounds2D().getCenterX() - lineBounds.getCenterX());
                    Y = (float)(p.getBounds2D().getY() + p.getBounds2D().getHeight() + (double)metrics.getLineMetrics(this.text, g2).getHeight());
                    g2.drawString(this.text, X, Y);
                } else if (this.lineTextPosition == 4) {
                    X = (float)(p.getBounds2D().getX() + p.getBounds().getWidth() - lineBounds.getCenterX());
                    Y = (float)(p.getBounds2D().getY() + p.getBounds2D().getHeight() + (double)metrics.getLineMetrics(this.text, g2).getHeight());
                    g2.drawString(this.text, X, Y);
                } else if (this.lineTextPosition == 6) {
                    X = (float)(p.getBounds2D().getX() - lineBounds.getCenterX());
                    Y = (float)(p.getBounds2D().getY() + p.getBounds2D().getHeight() + (double)metrics.getLineMetrics(this.text, g2).getHeight());
                } else if (this.lineTextPosition == 11) {
                    X = (float)(p.getBounds2D().getCenterX() + 5.0);
                    Y = (float)(p.getBounds2D().getCenterY() - lineBounds.getCenterY());
                } else if (this.lineTextPosition == 10) {
                    X = (float)(p.getBounds2D().getCenterX() - lineBounds.getWidth() - 5.0);
                    Y = (float)(p.getBounds2D().getCenterY() - lineBounds.getCenterY());
                }
                if (this.textBackground != null || this.lineColor != null) {
                    Rectangle2D.Double r = new Rectangle2D.Double(X - 1.0f, Y - metrics.getLineMetrics(this.text, g2).getHeight() + metrics.getLineMetrics(this.text, g2).getDescent() - 1.0f, lineBounds.getWidth() + 1.0, lineBounds.getHeight() + 1.0);
                    GJMarker marker2 = new GJMarker(r);
                    p = marker2.getPath();
                    if (this.textBackground != null) {
                        g2.setPaint(this.textBackground);
                        g2.fill(p);
                    }
                    if (this.lineColor != null) {
                        g2.setPaint(this.getLineColor());
                        g2.setStroke(new BasicStroke(1.0f));
                        g2.draw(p);
                    }
                }
                g2.setPaint(this.getTextColor());
                g2.drawString(this.text, X, Y);
            }
        }
    }

    public static LineAnnotation createLine(double x1, double y1, double x2, double y2) {
        return new LineAnnotation(x1, y1, x2, y2);
    }

    public static ArrowAnnotation createArrow(double x1, double y1, double x2, double y2, double szx, double szy) {
        return new ArrowAnnotation(x1, y1, x2, y2, szx, szy);
    }

    public static ArrowAnnotation createArrow(double x1, double y1, double x2, double y2, double x3, double y3, double szx, double szy) {
        return new ArrowAnnotation(x1, y1, x2, y2, x3, y3, szx, szy);
    }

    public static LineAnnotation createLine(double x1, double y1, double x2, double y2, double x3, double y3) {
        return new LineAnnotation(x1, y1, x2, y2, x3, y3);
    }

    public static ShapeAnnotation createBox(double x, double y, double w, double h) {
        return new ShapeAnnotation(new Rectangle2D.Double(x, y, w, h));
    }

    public static ShapeAnnotation createEllipse(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(x, y, w, h);
        return new ShapeAnnotation(s);
    }

    public static ShapeAnnotation createShape(Shape s) {
        return new ShapeAnnotation(s);
    }

    public static TextAnnotation createText(double x, double y, String s) {
        return new TextAnnotation(x, y, s);
    }

    public Paint getTextBackground() {
        return this.textBackground;
    }

    public void setTextBackground(Paint textBackground) {
        this.textBackground = textBackground;
    }

    public static class TextAnnotation
    extends GJAnnotation {
        public TextAnnotation() {
        }

        public TextAnnotation(double x, double y, String text) {
            this.setXData(x);
            this.setYData(y);
            this.setText(text);
        }
    }

    public static class ShapeAnnotation
    extends GJAnnotation {
        public ShapeAnnotation() {
        }

        public ShapeAnnotation(Shape s) {
            this.setMarker(new GJMarker(s));
        }
    }

    public static class ArrowAnnotation
    extends GJAnnotation {
        public ArrowAnnotation() {
        }

        public ArrowAnnotation(double x1, double y1, double x2, double y2, double szx, double szy) {
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(x1, y1);
            ((Path2D)p).lineTo(x2, y2);
            this.setPath(p);
            double dX = x2 - x1;
            double dY = y2 - y1;
            Shape arrowhead = GJMarker.makeArrow(x2, y2, szx, szy, true);
            AffineTransform af = new AffineTransform();
            af.setToRotation(Math.atan2(dY, dX), x2, y2);
            arrowhead = af.createTransformedShape(arrowhead);
            p.append(arrowhead, false);
            this.setExtra(new GJMarker(arrowhead));
        }

        public ArrowAnnotation(double x1, double y1, double x2, double y2, double x3, double y3, double szx, double szy) {
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(x1, y1);
            ((Path2D)p).quadTo(x2, y2, x3, y3);
            this.setPath(p);
            double dX = x3 - x2;
            double dY = y3 - y2;
            Shape arrowhead = GJMarker.makeArrow(x3, y3, szx, szy, true);
            AffineTransform af = new AffineTransform();
            af.setToRotation(Math.atan2(dY, dX), x3, y3);
            arrowhead = af.createTransformedShape(arrowhead);
            p.append(arrowhead, false);
            this.setExtra(new GJMarker(arrowhead));
        }
    }

    public static class LineAnnotation
    extends GJAnnotation {
        public LineAnnotation() {
        }

        public LineAnnotation(double x1, double y1, double x2, double y2) {
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(x1, y1);
            ((Path2D)p).lineTo(x2, y2);
            this.setPath(p);
        }

        public LineAnnotation(double x1, double y1, double x2, double y2, double x3, double y3) {
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(x1, y1);
            ((Path2D)p).quadTo(x2, y2, x3, y3);
            this.setPath(p);
        }
    }
}

