/*
 * Decompiled with CFR 0.152.
 */
package cambria.stat;

public class Statistic {
    public static double average(double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum / (double)data.length;
    }

    public static double variance(double[] data) {
        double ave = Statistic.average(data);
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += (data[i] - ave) * (data[i] - ave);
        }
        return sum / (double)data.length;
    }

    public static double stddev(double[] data) {
        return Math.pow(Statistic.variance(data), 0.5);
    }

    public static double shannon(double[] prob) {
        double sum = 0.0;
        for (int i = 0; i < prob.length; ++i) {
            if (!(prob[i] > 0.0)) continue;
            sum -= prob[i] * Math.log(prob[i]) / Math.log(prob.length);
        }
        return sum;
    }

    public static double shannon(double[] prob, int nbase) {
        double sum = 0.0;
        for (int i = 0; i < prob.length; ++i) {
            if (!(prob[i] > 0.0)) continue;
            sum -= prob[i] * Math.log(prob[i]) / Math.log(nbase);
        }
        return sum;
    }
}

