/*
 * Decompiled with CFR 0.152.
 */
package cambria.mmi;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

class ImageCanvas
extends Canvas {
    Container pappy;
    Image image;
    Dimension size;
    int w;
    int h;
    boolean trueSizeKnown;
    MediaTracker tracker;

    public ImageCanvas(Image image, Container highestContainer, int initialWidth, int initialHeight) {
        if (image == null) {
            System.err.println("Canvas got invalid image object!");
            return;
        }
        this.image = image;
        this.pappy = highestContainer;
        this.w = initialWidth;
        this.h = initialHeight;
        this.tracker = new MediaTracker(this);
        this.tracker.addImage(image, 0);
        this.size = new Dimension(this.w, this.h);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public void paint(Graphics g) {
        if (this.image != null && !this.trueSizeKnown) {
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            if (this.tracker.checkAll(true)) {
                this.trueSizeKnown = true;
                if (this.tracker.isErrorAny()) {
                    System.err.println("Error loading image: " + this.image);
                }
            }
            if (imageWidth > 0 && this.w != imageWidth || imageHeight > 0 && this.h != imageHeight) {
                this.w = imageWidth;
                this.h = imageHeight;
                this.size = new Dimension(this.w, this.h);
                this.setSize(this.w, this.h);
                this.pappy.validate();
            }
        }
        g.drawImage(this.image, 0, 0, this);
        g.drawRect(0, 0, this.w - 1, this.h - 1);
    }
}

