/*
 * Decompiled with CFR 0.152.
 */
package cambria.misc;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class MyFileWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveString(String fileName, String string) {
        BufferedWriter bw;
        if (fileName == null) {
            throw new IllegalArgumentException("filename is null");
        }
        try {
            FileWriter fw = new FileWriter(fileName);
            bw = new BufferedWriter(fw);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return;
        }
        try {
            if (string != null) {
                bw.write(string, 0, string.length());
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveMatrix(String filename, double[][] dstate) {
        double[][] yData = new double[dstate[0].length][dstate.length];
        for (int i = 0; i < dstate.length; ++i) {
            for (int j = 0; j < dstate[0].length; ++j) {
                yData[j][i] = dstate[i][j];
            }
        }
        MyFileWriter.saveData(filename, yData);
    }

    public static void saveMatrix(String filename, float[][] fstate) {
        float[][] yData = new float[fstate[0].length][fstate.length];
        for (int i = 0; i < fstate.length; ++i) {
            for (int j = 0; j < fstate[0].length; ++j) {
                yData[j][i] = fstate[i][j];
            }
        }
        MyFileWriter.saveData(filename, null, null, yData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMatrix(String filename, int[][] state) {
        BufferedWriter bw;
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        try {
            FileWriter fw = new FileWriter(filename);
            bw = new BufferedWriter(fw);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return;
        }
        try {
            for (int i = 0; i < state.length; ++i) {
                for (int j = 0; j < state[0].length; ++j) {
                    String string = Integer.toString(state[i][j]);
                    bw.write(" " + string, 0, string.length() + 1);
                }
                bw.write(System.getProperty("line.separator"), 0, 1);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveMatrix(String filename, byte[][] state) {
        MyFileWriter.saveCAsnapshot(filename, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCAsnapshot(String filename, byte[][] caState) {
        BufferedWriter bw;
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        try {
            FileWriter fw = new FileWriter(filename);
            bw = new BufferedWriter(fw);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return;
        }
        try {
            for (int i = 0; i < caState.length; ++i) {
                for (int j = 0; j < caState[0].length; ++j) {
                    String string = Integer.toString(caState[i][j]);
                    bw.write(" " + string, 0, string.length() + 1);
                }
                bw.write(System.getProperty("line.separator"), 0, 1);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveData(String fileName, String header, float[] xData, float[][] yData) {
        BufferedWriter bw;
        if (fileName == null) {
            throw new IllegalArgumentException("filename is null");
        }
        boolean isNullXData = false;
        if (xData == null) {
            isNullXData = true;
        }
        if (!isNullXData && xData.length != yData[0].length) {
            throw new IllegalArgumentException("X and Y data-lengths do not match");
        }
        try {
            FileWriter fw = new FileWriter(fileName);
            bw = new BufferedWriter(fw);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return;
        }
        try {
            if (header != null) {
                bw.write(header, 0, header.length());
                bw.write(System.getProperty("line.separator"), 0, 1);
            }
            for (int i = 0; i < yData[0].length; ++i) {
                if (!isNullXData) {
                    String xString = Float.toString(xData[i]);
                    bw.write(xString, 0, xString.length());
                }
                String yString = null;
                for (int j = 0; j < yData.length; ++j) {
                    yString = Float.toString(yData[j][i]);
                    bw.write(" " + yString, 0, yString.length() + 1);
                }
                bw.write(System.getProperty("line.separator"), 0, 1);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveData(String fileName, String header, double[] xData, double[] yData) {
        float[] newXData = new float[xData.length];
        float[][] newYData = new float[1][yData.length];
        for (int i = 0; i < yData.length; ++i) {
            newXData[i] = (float)xData[i];
            newYData[0][i] = (float)yData[i];
        }
        MyFileWriter.saveData(fileName, header, newXData, newYData);
    }

    public static void saveData(String filename, double[][] yData) {
        float[][] newYData = new float[yData.length][yData[0].length];
        for (int i = 0; i < yData.length; ++i) {
            for (int j = 0; j < yData[0].length; ++j) {
                newYData[i][j] = (float)yData[i][j];
            }
        }
        MyFileWriter.saveData(filename, null, null, newYData);
    }

    public static void saveData(String fileName, String header, float[] xData, float[] yData) {
        float[][] newYData = new float[1][yData.length];
        for (int i = 0; i < yData.length; ++i) {
            newYData[0][i] = yData[i];
        }
        MyFileWriter.saveData(fileName, header, xData, newYData);
    }

    public static void saveData(String filename, float[] xData, float[][] yData) {
        MyFileWriter.saveData(filename, null, xData, yData);
    }

    static void saveData(String filename, String header, float[][] yData) {
        MyFileWriter.saveData(filename, header, null, yData);
    }

    static void saveData(String filename, float[][] yData) {
        MyFileWriter.saveData(filename, null, null, yData);
    }
}

