/*
 * Decompiled with CFR 0.152.
 */
package cambria.jgat;

import cambria.jgat.Genotype;
import cambria.jgat.Phenotype;
import cambria.misc.MyMath;

public class GeneticAlgorithm {
    private int chromosomeLength;
    private int maxChromosomeState;
    private int populationSize;
    private int eliteSize = 10;
    private Genotype[] genotype;
    private int generation = 0;
    private int maxGeneration;
    private int crossoverPosition;
    private int bestIndividual;
    private Phenotype[] phenotype;
    private double mutationRate = 0.001;
    private double crossoverRate = 0.7;
    private boolean getOptimized;
    private double bestFitness;
    private double[] pastBestFitness;
    private int windowForMA = 10;
    private int swapSize;

    public GeneticAlgorithm(Genotype[] genotype, Phenotype[] phenotype, int eliteSize) {
        this(genotype, phenotype);
        this.eliteSize = eliteSize;
        this.swapSize = this.populationSize - eliteSize;
        if (MyMath.mode(this.swapSize, 2) != 0) {
            throw new IllegalArgumentException("Swap size must be a multiple of 2");
        }
    }

    public GeneticAlgorithm(Genotype[] genotype, Phenotype[] phenotype) {
        this.genotype = genotype;
        this.populationSize = genotype.length;
        if (MyMath.mode(this.populationSize, 2) != 0) {
            throw new IllegalArgumentException("Population size must be a multiple of 2");
        }
        this.chromosomeLength = genotype[0].getChromosomeLength();
        this.maxChromosomeState = genotype[0].getMaxChromosomeState();
        this.phenotype = phenotype;
        for (int i = 0; i < this.populationSize; ++i) {
            phenotype[i].updateFitness();
        }
        this.pastBestFitness = new double[this.windowForMA];
    }

    public void setCrossoverRate(double crossoverRate) {
        this.crossoverRate = crossoverRate;
    }

    public void setMutationRate(double mutationRate) {
        this.mutationRate = mutationRate;
    }

    public double getMaxFitness() {
        double maximum = this.phenotype[0].getFitness();
        for (int i = 1; i < this.populationSize; ++i) {
            maximum = Math.max(maximum, this.phenotype[i].getFitness());
        }
        return maximum;
    }

    public double getTotalFitness() {
        double sum = 0.0;
        for (int i = 0; i < this.populationSize; ++i) {
            sum += this.phenotype[i].getFitness();
        }
        return sum;
    }

    private double getBestFitness() {
        return this.bestFitness;
    }

    private void updateBestFitness() {
        double best = this.phenotype[0].getFitness();
        for (int i = 1; i < this.populationSize; ++i) {
            if (!(best < this.phenotype[i].getFitness())) continue;
            best = this.phenotype[i].getFitness();
        }
        this.bestFitness = best;
    }

    private void updatePastBestFitness() {
        for (int i = 0; i < this.windowForMA - 1; ++i) {
            this.pastBestFitness[i] = this.pastBestFitness[i + 1];
        }
        this.pastBestFitness[this.windowForMA - 1] = this.getBestFitness();
    }

    private double getBestFitnessMA() {
        double sum = 0.0;
        for (int i = 0; i < this.windowForMA; ++i) {
            sum += this.pastBestFitness[i];
        }
        return sum / (double)this.windowForMA;
    }

    private synchronized int getGeneration() {
        return this.generation;
    }

    public void report(StringBuffer buff) {
        this.updateBestFitness();
        this.updatePastBestFitness();
        System.out.print(this.generation + ".");
        System.out.print(" bestFitness=" + Double.toString(this.getBestFitness()));
        System.out.println(" MA= " + Double.toString(this.getBestFitnessMA()));
        buff.append(" " + this.generation + " " + Double.toString(this.getBestFitness()) + " " + Double.toString(this.getTotalFitness()) + System.getProperty("line.separator"));
    }

    public synchronized void step() {
        int i;
        this.separateElites();
        this.setSelectionProb();
        int[][] tempChromosome = new int[this.swapSize][this.chromosomeLength];
        int[][] tempChromosome2 = new int[2][this.chromosomeLength];
        for (i = 0; i < this.swapSize / 2; ++i) {
            int j;
            int father = this.selectParent();
            int mother = this.selectParent();
            tempChromosome2[0] = this.genotype[father].getChromosome();
            tempChromosome2[1] = this.genotype[mother].getChromosome();
            if (Math.random() < this.crossoverRate) {
                int position = MyMath.irand(this.chromosomeLength - 1) + 1;
                tempChromosome[i * 2] = this.getCrossovered1(tempChromosome2, position);
                tempChromosome[i * 2 + 1] = this.getCrossovered2(tempChromosome2, position);
                continue;
            }
            for (j = 0; j < this.chromosomeLength; ++j) {
                tempChromosome[i * 2][j] = tempChromosome2[0][j];
            }
            for (j = 0; j < this.chromosomeLength; ++j) {
                tempChromosome[i * 2 + 1][j] = tempChromosome2[1][j];
            }
        }
        for (i = 0; i < this.swapSize; ++i) {
            this.genotype[i].copyChromosome(tempChromosome[i]);
            this.genotype[i].mutation(this.mutationRate);
        }
        for (i = 0; i < this.populationSize; ++i) {
            this.phenotype[i].setOptimized(false);
            this.phenotype[i].updateFitness();
            if (!this.phenotype[i].isOptimized()) continue;
            System.out.println("A chromosome is optimized at " + i);
        }
        ++this.generation;
    }

    private void separateElites() {
        int[][] tempChromosome = new int[this.populationSize][this.chromosomeLength];
        for (int i = 0; i < this.populationSize; ++i) {
            for (int j = 0; j < this.chromosomeLength; ++j) {
                tempChromosome[i][j] = this.genotype[i].getChromosome()[j];
            }
        }
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.populationSize; ++i) {
            double before;
            if (this.isElite(i)) {
                before = this.phenotype[this.populationSize - ++j].getFitness();
                this.genotype[this.populationSize - j].copyChromosome(tempChromosome[i]);
                this.phenotype[this.populationSize - j].updateFitness();
                double d = this.phenotype[this.populationSize - j].getFitness();
                continue;
            }
            before = this.phenotype[k].getFitness();
            this.genotype[k].copyChromosome(tempChromosome[i]);
            this.phenotype[k].updateFitness();
            double after = this.phenotype[k].getFitness();
            ++k;
        }
        if (j + k != this.populationSize) {
            throw new RuntimeException("Contradictory found.");
        }
    }

    private boolean isElite(int index) {
        int rank = 1;
        double fitness = this.phenotype[index].getFitness();
        for (int currentIndex = 0; currentIndex < this.populationSize; ++currentIndex) {
            if (!(fitness < this.phenotype[currentIndex].getFitness())) continue;
            ++rank;
        }
        return rank <= this.eliteSize;
    }

    private int[] getCrossovered1(int[][] chromosomePair, int position) {
        int i;
        if (position > this.chromosomeLength) {
            throw new IllegalArgumentException();
        }
        int[] dum = new int[this.chromosomeLength];
        for (i = 0; i < position; ++i) {
            dum[i] = chromosomePair[0][i];
        }
        for (i = position; i < this.chromosomeLength; ++i) {
            dum[i] = chromosomePair[1][i];
        }
        return dum;
    }

    private int[] getCrossovered2(int[][] chromosomePair, int position) {
        int i;
        if (position > this.chromosomeLength) {
            throw new IllegalArgumentException();
        }
        int[] dum = new int[this.chromosomeLength];
        for (i = 0; i < position; ++i) {
            dum[i] = chromosomePair[1][i];
        }
        for (i = position; i < this.chromosomeLength; ++i) {
            dum[i] = chromosomePair[0][i];
        }
        return dum;
    }

    private void setSelectionProb() {
        double totalFitness = this.getTotalFitness();
        for (int i = 0; i < this.populationSize; ++i) {
            double prob = this.phenotype[i].getFitness() / totalFitness;
            this.genotype[i].setSelectionProbability(prob);
        }
    }

    private int selectParent() {
        double sum = 0.0;
        double ran = Math.random();
        for (int i = 0; i < this.populationSize; ++i) {
            if (!(ran < (sum += this.genotype[i].getSelectionProbability()))) continue;
            return i;
        }
        throw new RuntimeException();
    }

    public boolean isOptimized() {
        return this.getOptimized;
    }

    public void setOptimized(boolean getOptimized) {
        this.getOptimized = getOptimized;
    }

    public static int getBestFitNumber(Phenotype[] phenotype, int populationSize) {
        int bestIndividual = 0;
        double bestFitness = phenotype[0].getFitness();
        for (int i = 1; i < populationSize; ++i) {
            if (!(bestFitness < phenotype[i].getFitness())) continue;
            bestFitness = phenotype[i].getFitness();
            bestIndividual = i;
        }
        return bestIndividual;
    }
}

