/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.Partition;
import cambria.PartitionRule;
import cambria.RuleStatistic;
import cambria.misc.MyFileReader;
import cambria.misc.MyFileWriter;
import cambria.misc.MyString;

public class RuleEntropy {
    private int[][] ruleArray;
    private int[] mass;
    private double[] ruleEntropy = new double[32];
    private String dataFilename;
    private String outputFile = "dummy.dat";
    private String directory;
    private int statePerCell = 2;
    private int maxNeighbor = 5;
    private int maxRuleEntry = 32;
    private int maxRule;
    private int firstNumber;
    private int lastNumber;
    private static final int numberOfDigits = 3;

    public static void main(String[] arg) {
        try {
            System.out.println(arg[0]);
            System.out.println(arg[1]);
            System.out.println(arg[2]);
            System.out.println(arg[3]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: >java <stemName> <first number> <last number> <data directory>");
            System.exit(-1);
        }
        RuleEntropy ruleEntropy = new RuleEntropy(arg[0], arg[1], arg[2], arg[3]);
        if (arg.length == 5) {
            ruleEntropy.setOutputFile(arg[4]);
        } else if (arg.length < 5) {
            System.out.println("output file is " + ruleEntropy.getOutputFile());
        } else {
            System.out.println("Usage: >java <stemName> <first number> <last number> <data directory>");
            throw new RuntimeException();
        }
        ruleEntropy.setBases();
        ruleEntropy.readRules();
        ruleEntropy.calculateEntropy();
        ruleEntropy.saveResults();
    }

    public RuleEntropy(String stemName, String FirstNumber, String LastNumber, String directory) {
        this.firstNumber = MyString.convertIntParameter(FirstNumber);
        this.lastNumber = MyString.convertIntParameter(LastNumber);
        this.maxRule = this.lastNumber - this.firstNumber + 1;
        this.ruleArray = new int[this.maxRuleEntry][this.maxRule];
        this.mass = new int[this.maxRuleEntry];
        this.directory = directory;
        this.dataFilename = directory != null ? directory + System.getProperty("file.separator") + stemName : stemName;
        this.outputFile = this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setBases() {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            Partition partition = PartitionRule.int2Partition(i, this.statePerCell, this.maxNeighbor);
            this.mass[i] = partition.getMass(1);
        }
    }

    public void readRules() {
        for (int i = 0; i < this.maxRule; ++i) {
            String fileName = this.dataFilename + MyString.getDigits(i + this.firstNumber, 3) + ".par";
            System.out.println(fileName);
            String fileContents = MyFileReader.file2string(fileName);
            for (int j = 0; j < 32; ++j) {
                String str = MyString.stripBack(MyString.lindex(fileContents, j + 2), ':');
                this.ruleArray[j][i] = MyString.convertIntParameter(str);
            }
        }
    }

    public void calculateEntropy() {
        for (int i = 0; i < 32; ++i) {
            int nbase = RuleStatistic.getCombination(this.maxNeighbor, this.mass[i]);
            this.ruleEntropy[i] = RuleStatistic.getRuleEntropy(i, this.ruleArray, nbase);
            System.out.println("entry " + i + " : " + this.ruleEntropy[i]);
        }
    }

    public void saveResults() {
        double[] xData = new double[this.maxRuleEntry];
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            xData[i] = i;
        }
        MyFileWriter.saveData(this.directory + System.getProperty("file.separator") + this.outputFile, null, xData, this.ruleEntropy);
    }
}

