/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.VonNeumann;

public class Q2RRule
extends CARule {
    private static final int statePerCell = 2;
    private static final int maxNeighbor = 5;

    private int getLocalIntEnergy(VonNeumann neighbor) {
        int total = neighbor.getNorthState() + neighbor.getEastState() + neighbor.getSouthState() + neighbor.getWestState() - 2;
        if (neighbor.getHomeState() == 1) {
            return -total * 2;
        }
        return total * 2;
    }

    @Override
    public String getDefaultThread() {
        return "MCSThread";
    }

    @Override
    public int output(BlockOfCells boc) {
        VonNeumann neighbor = (VonNeumann)boc;
        int localEnergy = this.getLocalIntEnergy(neighbor);
        boolean nextState = false;
        return localEnergy == 0 ? (neighbor.getHomeState() + 1) % 2 : neighbor.getHomeState();
    }

    @Override
    public int getStatePerCell() {
        return 2;
    }

    @Override
    public int getMaxNeighbor() {
        return 5;
    }
}

