/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.Partition;
import cambria.PartitionIF;
import cambria.PartitionRuleIO;
import cambria.PartitionRuleString;
import cambria.StochasticRuleUnit;
import cambria.jgat.Optimized;
import cambria.misc.MyFileWriter;
import cambria.misc.MyMath;
import cambria.misc.MyString;
import java.awt.Button;
import java.util.Random;
import javax.swing.JTextArea;

public class PartitionRule
extends CARule
implements PartitionIF,
Optimized {
    private int statePerCell;
    private int maxNeighbor;
    private int[] ruleArray;
    private int maxRuleEntry;
    private String RuleString = null;
    private Button adoptButton;
    private JTextArea ruleTA;
    static final int startIndex = 2;
    private Random rand = new Random(System.currentTimeMillis());
    private double fitness;
    private double selectionProbability;

    public void setRule(int statePerCell, int maxNeighbor) {
        this.statePerCell = statePerCell;
        this.maxNeighbor = maxNeighbor;
        this.maxRuleEntry = MyMath.ipow(statePerCell, maxNeighbor);
        this.ruleArray = new int[this.maxRuleEntry];
        StochasticRuleUnit[] stochasticRuleArray = PartitionRuleString.initializeRuleArray(this.maxRuleEntry);
        for (int i = 0; i < this.ruleArray.length; ++i) {
            this.ruleArray[i] = stochasticRuleArray[i].output;
        }
    }

    @Override
    public void setRule(String RuleString, String filename) {
        if (RuleString == null) {
            if (filename == null) {
                throw new IllegalArgumentException("null arguments");
            }
            PartitionRuleIO partitionRuleIO = new PartitionRuleIO(filename);
            RuleString = partitionRuleIO.buff.toString();
        }
        if (PartitionRuleString.isStochastic(RuleString)) {
            throw new RuntimeException("Stochastic rule is found.");
        }
        this.RuleString = RuleString;
        this.statePerCell = Integer.parseInt(MyString.lindex(RuleString, 0));
        this.maxNeighbor = Integer.parseInt(MyString.lindex(RuleString, 1));
        this.maxRuleEntry = MyMath.ipow(this.statePerCell, this.maxNeighbor);
        this.ruleArray = new int[this.maxRuleEntry];
        String RuleContent = MyString.stripHeader(RuleString, 2);
        StochasticRuleUnit[] stochasticRuleArray = PartitionRuleString.createRuleArray(this.statePerCell, this.maxNeighbor, RuleContent);
        for (int i = 0; i < this.ruleArray.length; ++i) {
            this.ruleArray[i] = stochasticRuleArray[i].output;
        }
    }

    public void saveRuleFile(String filename) {
        StringBuffer buff = new StringBuffer();
        buff.append(Integer.toString(this.statePerCell));
        buff.append(" ");
        buff.append(Integer.toString(this.maxNeighbor));
        buff.append(System.getProperty("line.separator"));
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            buff.append(Integer.toString(i));
            buff.append(":");
            buff.append(Integer.toString(this.ruleArray[i]));
            buff.append(System.getProperty("line.separator"));
        }
        MyFileWriter.saveString(filename, buff.toString());
    }

    public String getRuleString() {
        return this.RuleString;
    }

    @Override
    public BlockOfCells outputBlock(BlockOfCells boc) {
        Partition neighbor = (Partition)boc;
        int ruleEntry = this.getRuleEntry(neighbor);
        return this.getPartition(ruleEntry);
    }

    private int getConservationOutputAtRandom(int ruleEntry) {
        Partition partition = this.int2Partition(ruleEntry);
        partition.relocateParticlesAtRandom();
        return this.getRuleEntry(partition);
    }

    public static Partition int2Partition(int entry, int statePerCell, int maxNeighbor) {
        Partition partition = new Partition(maxNeighbor);
        if (maxNeighbor == 4) {
            int j = MyMath.ipow(statePerCell, maxNeighbor - 1);
            partition.setHomeState((byte)MyMath.idiv(entry, j));
            entry -= partition.getHomeState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 2);
            partition.setEastState((byte)MyMath.idiv(entry, j));
            entry -= partition.getEastState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 3);
            partition.setSouthState((byte)MyMath.idiv(entry, j));
            partition.setEsState((byte)(entry -= partition.getSouthState() * j));
        } else if (maxNeighbor == 5) {
            int j = MyMath.ipow(statePerCell, maxNeighbor - 1);
            partition.setHomeState((byte)MyMath.idiv(entry, j));
            entry -= partition.getHomeState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 2);
            partition.setNorthState((byte)MyMath.idiv(entry, j));
            entry -= partition.getNorthState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 3);
            partition.setEastState((byte)MyMath.idiv(entry, j));
            entry -= partition.getEastState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 4);
            partition.setSouthState((byte)MyMath.idiv(entry, j));
            partition.setWestState((byte)(entry -= partition.getSouthState() * j));
        } else if (maxNeighbor == 9) {
            int j = MyMath.ipow(statePerCell, maxNeighbor - 1);
            partition.setWnState((byte)MyMath.idiv(entry, j));
            entry -= partition.getWnState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 2);
            partition.setNorthState((byte)MyMath.idiv(entry, j));
            entry -= partition.getNorthState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 3);
            partition.setNeState((byte)MyMath.idiv(entry, j));
            entry -= partition.getNeState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 4);
            partition.setWestState((byte)MyMath.idiv(entry, j));
            entry -= partition.getWestState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 5);
            partition.setHomeState((byte)MyMath.idiv(entry, j));
            entry -= partition.getHomeState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 6);
            partition.setEastState((byte)MyMath.idiv(entry, j));
            entry -= partition.getEastState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 7);
            partition.setSwState((byte)MyMath.idiv(entry, j));
            entry -= partition.getSwState() * j;
            j = MyMath.ipow(statePerCell, maxNeighbor - 8);
            partition.setSouthState((byte)MyMath.idiv(entry, j));
            partition.setEsState((byte)(entry -= partition.getSouthState() * j));
        } else {
            throw new RuntimeException("No such maxNeighbor defined.");
        }
        return partition;
    }

    private Partition int2Partition(int entry) {
        return PartitionRule.int2Partition(entry, this.statePerCell, this.maxNeighbor);
    }

    private Partition getPartition(int ruleEntry) {
        int out = this.ruleArray[ruleEntry];
        return this.int2Partition(out);
    }

    private int getRuleEntry(Partition partition) {
        int sum = 0;
        if (this.maxNeighbor == 4) {
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 1) * partition.getHomeState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 2) * partition.getEastState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 3) * partition.getSouthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 4) * partition.getEsState();
        } else if (this.maxNeighbor == 5) {
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 1) * partition.getHomeState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 2) * partition.getNorthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 3) * partition.getEastState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 4) * partition.getSouthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 5) * partition.getWestState();
        } else if (this.maxNeighbor == 9) {
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 1) * partition.getWnState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 2) * partition.getNorthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 3) * partition.getNeState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 4) * partition.getWestState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 5) * partition.getHomeState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 6) * partition.getEastState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 7) * partition.getSwState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 8) * partition.getSouthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 9) * partition.getEsState();
        }
        return sum;
    }

    public double getMu() {
        int j = 0;
        for (int i = 0; i < this.ruleArray.length; ++i) {
            if (this.ruleArray[i] == i) continue;
            ++j;
        }
        return (double)j / (double)this.ruleArray.length;
    }

    public int getRuleArray(int entry) {
        return this.ruleArray[entry];
    }

    public void setRuleArray(int entry, int output) {
        this.ruleArray[entry] = output;
    }

    public void copyRule(PartitionRule source) {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            this.setRuleArray(i, source.getRuleArray(i));
        }
    }

    @Override
    public String getDefaultThread() {
        return "MCSThread";
    }

    @Override
    public int getStatePerCell() {
        return this.statePerCell;
    }

    @Override
    public int getMaxNeighbor() {
        return this.maxNeighbor;
    }

    public int getMaxRuleEntry() {
        return this.maxRuleEntry;
    }

    @Override
    public void randomizeChromosome() {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            this.randomizeChromosome(i);
        }
    }

    @Override
    public void mutation(double rate) {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            if (!(this.rand.nextDouble() < rate)) continue;
            this.randomizeChromosome(i);
        }
    }

    private void randomizeChromosome(int position) {
        this.setAnotherConservedTransition(position);
    }

    private void setAnotherConservedTransition(int entry) {
        Partition partition = this.getPartition(entry);
        int a0 = partition.getMass(0);
        partition.relocateParticlesAtRandom();
        int b0 = partition.getMass(0);
        if (a0 != b0) {
            throw new RuntimeException("Cell 0 in relocateParticlesAtRandom() is not conservative.");
        }
        this.setRuleArray(entry, this.getRuleEntry(partition));
    }

    @Override
    public int getChromosomeLength() {
        return this.maxRuleEntry;
    }

    @Override
    public int getMaxChromosomeState() {
        return this.maxRuleEntry;
    }

    @Override
    public int[] getChromosome() {
        int[] chromosome = new int[this.maxRuleEntry];
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            chromosome[i] = this.ruleArray[i];
        }
        return chromosome;
    }

    @Override
    public double getFitness() {
        return this.fitness;
    }

    @Override
    public void copyChromosome(int[] chromosome) {
        if (this.getChromosomeLength() != chromosome.length) {
            throw new IllegalArgumentException("Chromosome lengths do not match. ");
        }
        for (int i = 0; i < this.getChromosomeLength(); ++i) {
            this.ruleArray[i] = chromosome[i];
        }
    }

    @Override
    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    @Override
    public void setSelectionProbability(double selectionProbability) {
        this.selectionProbability = selectionProbability;
    }

    @Override
    public double getSelectionProbability() {
        return this.selectionProbability;
    }
}

