/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.Moore;

public class HodgeRule
extends CARule {
    private static final long serialVersionUID = 1L;
    public static final int statePerCell = 16;
    public static final int maxNeighbor = 9;

    @Override
    public int output(BlockOfCells boc) {
        Moore neighbor = (Moore)boc;
        int total = 0;
        total += neighbor.getNorthState();
        total += neighbor.getNeState();
        total += neighbor.getEastState();
        total += neighbor.getEsState();
        total += neighbor.getSouthState();
        total += neighbor.getSwState();
        total += neighbor.getWestState();
        int ave = (int)Math.floor((double)(total += neighbor.getWnState()) / 8.0);
        if (neighbor.getHomeState() == 0) {
            if (total > 50) {
                return 2;
            }
            if (total > 2) {
                return 1;
            }
            return 0;
        }
        if (neighbor.getHomeState() == 15) {
            return 0;
        }
        int sum = ave + 2;
        if (sum >= 16) {
            return 15;
        }
        return sum;
    }

    @Override
    public int getStatePerCell() {
        return 16;
    }

    @Override
    public int getMaxNeighbor() {
        return 9;
    }
}

