/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.Demon;
import cambria.InteractingEnergy;
import cambria.VonNeumann;
import java.awt.Button;
import java.awt.Panel;
import java.awt.event.ActionEvent;

public class GrowthRule
extends CARule
implements InteractingEnergy {
    private static final int interact = 1;
    private int maxEnergy = 16;
    private Demon demon;
    private Panel subPanel;
    private Button closeButton;
    private static final int statePerCell = 2;
    private static final int maxNeighbor = 5;

    private int getLocalIntEnergy(VonNeumann neighbor) {
        int total = neighbor.getNorthState() + neighbor.getEastState() + neighbor.getSouthState() + neighbor.getWestState() - 2;
        if (neighbor.getHomeState() == 1) {
            return -total * 2 * 1;
        }
        return total * 2 * 1;
    }

    @Override
    public String getDefaultThread() {
        return "MCSThread";
    }

    @Override
    public int output(BlockOfCells boc) {
        VonNeumann neighbor = (VonNeumann)boc;
        if (neighbor.getHomeState() != 0 || neighbor.getSouthState() != 1) {
            return neighbor.getHomeState();
        }
        int x = neighbor.getXAxis();
        int y = neighbor.getYAxis();
        int demonEnergy = this.demon.getEnergy(x, y);
        int localEnergy = this.getLocalIntEnergy(neighbor);
        int nextState = 0;
        if (localEnergy >= 0) {
            if (demonEnergy + 2 * localEnergy <= this.maxEnergy) {
                demonEnergy += 2 * localEnergy;
                nextState = (neighbor.getHomeState() + 1) % 2;
            } else {
                nextState = neighbor.getHomeState();
            }
        } else if (demonEnergy >= -2 * localEnergy) {
            demonEnergy += 2 * localEnergy;
            nextState = (neighbor.getHomeState() + 1) % 2;
        } else {
            nextState = neighbor.getHomeState();
        }
        this.demon.setEnergy(x, y, demonEnergy);
        return nextState;
    }

    @Override
    public void updateDemon() {
        if (this.demon.isFixedDemon()) {
            this.demon.setAveEnergy();
        }
    }

    @Override
    public int getStatePerCell() {
        return 2;
    }

    @Override
    public int getMaxNeighbor() {
        return 5;
    }

    @Override
    public void edit() {
        if (this.subPanel == null) {
            if (this.demon == null) {
                System.out.println("GrowthRule: Null demon.");
            } else {
                this.demon.addPanel(this);
            }
            this.subPanel = new Panel();
            this.closeButton = new Button("close");
            this.closeButton.addActionListener(this);
            this.subPanel.add(this.closeButton);
            this.add("South", this.subPanel);
            this.pack();
        }
        this.setVisible(true);
    }

    @Override
    public void setDemon(Demon demon) {
        this.demon = demon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.setVisible(false);
        } else {
            System.out.println("GrowthRule: Unknown button clicked");
        }
    }
}

