/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.stat.Statistic;

class EntroS {
    public byte[][] caState;
    int statePerCell;
    int x_max;
    int y_max;
    int t_max;

    public EntroS(int statePerCell, int x_max, int y_max) {
        this.statePerCell = statePerCell;
        this.x_max = x_max;
        this.y_max = y_max;
        this.caState = new byte[x_max][y_max];
    }

    public EntroS(int statePerCell, int x_max, int y_max, int t_max) {
        this.statePerCell = statePerCell;
        this.x_max = x_max;
        this.y_max = y_max;
        this.caState = new byte[x_max][y_max];
        this.t_max = t_max;
    }

    public void setCA(byte[][] caState) {
        this.caState = caState;
    }

    public float getAveEntro(byte[][][] hist) {
        float sum = 0.0f;
        for (int k = 0; k < this.t_max; ++k) {
            for (int i = 0; i < this.x_max; ++i) {
                for (int j = 0; j < this.y_max; ++j) {
                    this.caState[i][j] = hist[i][j][k];
                }
            }
            sum += this.getBEntro();
        }
        return sum / (float)this.t_max;
    }

    public float getVariance(byte[][][] hist) {
        double[] entro = new double[this.t_max];
        for (int k = 0; k < this.t_max; ++k) {
            for (int i = 0; i < this.x_max; ++i) {
                for (int j = 0; j < this.y_max; ++j) {
                    this.caState[i][j] = hist[i][j][k];
                }
            }
            entro[k] = this.getEntro();
        }
        return (float)Statistic.variance(entro);
    }

    public static float getEntro(byte[][] caState, int statePerCell) {
        if (caState == null || statePerCell < 2) {
            throw new IllegalArgumentException();
        }
        int x_max = caState.length;
        int y_max = caState[0].length;
        for (int i = 0; i < x_max; ++i) {
            for (int j = 0; j < y_max; ++j) {
                if (caState[i][j] <= statePerCell - 1) continue;
                throw new IllegalArgumentException("A CA-state exceeds the given state per cell.");
            }
        }
        int tot = x_max * y_max;
        int totPattern = statePerCell * statePerCell * statePerCell * statePerCell;
        int[] sum = new int[totPattern];
        int pState = 0;
        for (int i = 0; i < x_max; ++i) {
            for (int j = 0; j < y_max; ++j) {
                int n = pState = caState[i][j] + caState[i][(j + 1) % y_max] * statePerCell + caState[(i + 1) % x_max][j] * statePerCell * statePerCell + caState[(i + 1) % x_max][(j + 1) % y_max] * statePerCell * statePerCell * statePerCell;
                sum[n] = sum[n] + 1;
            }
        }
        double[] p = new double[totPattern];
        for (int i = 0; i < totPattern; ++i) {
            p[i] = (double)sum[i] / (double)tot;
        }
        return (float)Statistic.shannon(p);
    }

    public float getEntro() {
        int tot = this.x_max * this.y_max;
        int totPattern = this.statePerCell * this.statePerCell * this.statePerCell * this.statePerCell;
        int[] sum = new int[totPattern];
        int pState = 0;
        for (int i = 0; i < this.x_max; ++i) {
            for (int j = 0; j < this.y_max; ++j) {
                int n = pState = this.caState[i][j] + this.caState[i][(j + 1) % this.y_max] * this.statePerCell + this.caState[(i + 1) % this.x_max][j] * this.statePerCell * this.statePerCell + this.caState[(i + 1) % this.x_max][(j + 1) % this.y_max] * this.statePerCell * this.statePerCell * this.statePerCell;
                sum[n] = sum[n] + 1;
            }
        }
        double[] p = new double[totPattern];
        for (int i = 0; i < totPattern; ++i) {
            p[i] = (double)sum[i] / (double)tot;
        }
        return (float)Statistic.shannon(p);
    }

    public float getBEntro() {
        int tot = this.x_max * this.y_max;
        int totPattern = 16;
        int[][] bState = new int[this.x_max][this.y_max];
        for (int x = 0; x < this.x_max; ++x) {
            for (int y = 0; y < this.y_max; ++y) {
                bState[x][y] = (int)Math.ceil((double)this.caState[x][y] / (double)this.statePerCell);
            }
        }
        int[] sum = new int[totPattern];
        int pState = 0;
        for (int i = 0; i < this.x_max; ++i) {
            for (int j = 0; j < this.y_max; ++j) {
                int n = pState = bState[i][j] + bState[i][(j + 1) % this.y_max] * 2 + bState[(i + 1) % this.x_max][j] * 4 + bState[(i + 1) % this.x_max][(j + 1) % this.y_max] * 8;
                sum[n] = sum[n] + 1;
            }
        }
        double[] p = new double[totPattern];
        for (int i = 0; i < totPattern; ++i) {
            p[i] = (double)sum[i] / (double)tot;
        }
        return (float)Statistic.shannon(p);
    }
}

