/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.RuleStatistic;
import cambria.misc.MyFileReader;
import cambria.misc.MyString;

public class CorrelatedTrans {
    private int[][] ruleArray;
    private String dataFilename;
    private String outputFile = "dummy.dat";
    private String directory;
    private int maxRuleEntry = 32;
    private double[][] transProb = new double[this.maxRuleEntry][this.maxRuleEntry];
    private double[][][][] cooccurProb = new double[this.maxRuleEntry][this.maxRuleEntry][this.maxRuleEntry][this.maxRuleEntry];
    private double[][][][] normCooccurProb = new double[this.maxRuleEntry][this.maxRuleEntry][this.maxRuleEntry][this.maxRuleEntry];
    private int maxRule;
    private int firstNumber;
    private int lastNumber;
    private static final int numberOfDigits = 3;
    private int entryA;
    private int entryB;
    int top = 10;
    String[] topCombi = new String[this.top];
    double[] topValue = new double[this.top];

    public static void main(String[] arg) {
        try {
            System.out.println("stemName is " + arg[0]);
            System.out.println("first number is " + arg[1]);
            System.out.println("last number is " + arg[2]);
            System.out.println("data directory is " + arg[3]);
            System.out.println("entryA " + arg[4]);
            System.out.println("entryB " + arg[5]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: >java Cooccur <stemName> <firstNumber> <lastNumber> <dataDirectoty> <entryA> <entryB>");
            System.exit(-1);
        }
        CorrelatedTrans correlatedTrans = new CorrelatedTrans(arg[0], arg[1], arg[2], arg[3], arg[4], arg[5]);
    }

    public CorrelatedTrans(String stemName, String FirstNumber, String LastNumber, String directory, String EntryA, String EntryB) {
        int i;
        this.firstNumber = MyString.convertIntParameter(FirstNumber);
        this.lastNumber = MyString.convertIntParameter(LastNumber);
        this.maxRule = this.lastNumber - this.firstNumber + 1;
        this.ruleArray = new int[this.maxRuleEntry][this.maxRule];
        this.directory = directory;
        this.dataFilename = directory != null ? directory + System.getProperty("file.separator") + stemName : stemName;
        this.entryA = MyString.convertIntParameter(EntryA);
        this.entryB = MyString.convertIntParameter(EntryB);
        this.readRules();
        for (i = 0; i < this.topCombi.length; ++i) {
            this.topCombi[i] = new String();
        }
        for (i = 0; i < this.maxRuleEntry; ++i) {
            System.out.println(" entry " + i);
            for (int j = 0; j < this.maxRuleEntry; ++j) {
                System.out.print(" " + j);
                if (i >= j) continue;
                this.getTopTen(i, j);
            }
        }
        for (i = 0; i < this.top; ++i) {
            System.out.println(this.topCombi[i] + "  " + this.topValue[i]);
        }
    }

    public void readRules() {
        for (int i = 0; i < this.maxRule; ++i) {
            String fileName = this.dataFilename + MyString.getDigits(i + this.firstNumber, 3) + ".par";
            System.out.println(fileName);
            String fileContents = MyFileReader.file2string(fileName);
            for (int j = 0; j < this.maxRuleEntry; ++j) {
                String str = MyString.stripBack(MyString.lindex(fileContents, j + 2), ':');
                this.ruleArray[j][i] = MyString.convertIntParameter(str);
            }
        }
    }

    public void getTopTen(int ia, int ib) {
        double minProb = 0.0;
        this.normCooccurProb = RuleStatistic.calculateNormCooccurProb(this.ruleArray);
        for (int ja = 0; ja < this.maxRuleEntry; ++ja) {
            for (int jb = 0; jb < this.maxRuleEntry; ++jb) {
                int rank = this.getRank(this.normCooccurProb[ia][ja][ib][jb], this.topValue);
                if (rank <= -1 || !(this.getProb(ia, ja) > minProb) || !(this.getProb(ib, jb) > minProb)) continue;
                this.insert(rank, this.normCooccurProb[ia][ja][ib][jb], this.topValue, this.topCombi, ia, ja, ib, jb);
            }
        }
    }

    private int getRank(double value, double[] topValue) {
        for (int i = 0; i < topValue.length; ++i) {
            if (!(value > topValue[i])) continue;
            return i;
        }
        return -1;
    }

    private void insert(int rank, double value, double[] topValue, String[] topCombi, int ia, int ja, int ib, int jb) {
        for (int i = 0; i < topValue.length - rank - 1; ++i) {
            topValue[topValue.length - i - 1] = topValue[topValue.length - i - 2];
            topCombi[topValue.length - i - 1] = new String(topCombi[topValue.length - i - 2]);
        }
        topValue[rank] = value;
        topCombi[rank] = new String(" " + ia + " -> " + ja + " AND " + ib + " -> " + jb);
    }

    private double getProb(int input, int output) {
        int sum = 0;
        for (int i = 0; i < this.maxRule; ++i) {
            if (this.ruleArray[input][i] != output) continue;
            ++sum;
        }
        return (double)sum / (double)this.maxRule;
    }
}

