/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.Cambria;
import cambria.Partition;
import cambria.PartitionRule;
import cambria.RuleStatistic;
import cambria.misc.MyFileReader;
import cambria.misc.MyString;

public class Cooccur {
    private int[][] ruleArray;
    private String dataFilename;
    private String outputFile = "dummy.dat";
    private String directory;
    private int statePerCell = 2;
    private int maxNeighbor = 5;
    private int maxRuleEntry = 32;
    private double[][] transProb = new double[this.maxRuleEntry][this.maxRuleEntry];
    private double[][][][] cooccurProb = new double[this.maxRuleEntry][this.maxRuleEntry][this.maxRuleEntry][this.maxRuleEntry];
    private double[][][][] normCooccurProb = new double[this.maxRuleEntry][this.maxRuleEntry][this.maxRuleEntry][this.maxRuleEntry];
    private int maxRule;
    private int firstNumber;
    private int lastNumber;
    private static final int numberOfDigits = 3;
    private double criterion;
    private int[] mass = new int[this.maxRuleEntry];

    public static void main(String[] arg) {
        try {
            System.out.println("stemName is " + arg[0]);
            System.out.println("first number is " + arg[1]);
            System.out.println("last number is " + arg[2]);
            System.out.println("data directory is " + arg[3]);
            System.out.println("criterion " + arg[4]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: >java Cooccur <stemName> <firstNumber> <lastNumber> <dataDirectoty> <criterion>");
            System.exit(-1);
        }
        Cooccur cooccur = new Cooccur(arg[0], arg[1], arg[2], arg[3], arg[4]);
    }

    public Cooccur(String stemName, String FirstNumber, String LastNumber, String directory, String Criterion) {
        this.firstNumber = MyString.convertIntParameter(FirstNumber);
        this.lastNumber = MyString.convertIntParameter(LastNumber);
        this.maxRule = this.lastNumber - this.firstNumber + 1;
        this.ruleArray = new int[this.maxRuleEntry][this.maxRule];
        this.directory = directory;
        this.dataFilename = directory != null ? directory + System.getProperty("file.separator") + stemName : stemName;
        this.criterion = Cambria.convertDoubleParameter(Criterion, 0.5);
        this.createMassArray();
        this.readRules();
        this.cooccurProb = RuleStatistic.calculateCooccurProb(this.ruleArray);
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            for (int j = 0; j < this.maxRuleEntry; ++j) {
                if (i >= j) continue;
                int nbasei = RuleStatistic.getCombination(this.maxNeighbor, this.mass[i]);
                int nbasej = RuleStatistic.getCombination(this.maxNeighbor, this.mass[j]);
                double jentropy = RuleStatistic.getJointEntropy(i, j, this.cooccurProb, nbasei * nbasej);
                double mutual = RuleStatistic.getRuleEntropy(i, this.ruleArray, nbasei) + RuleStatistic.getRuleEntropy(j, this.ruleArray, nbasej) - jentropy;
                if (!(mutual > this.criterion)) continue;
                System.out.println(" " + i + " : " + j + " " + jentropy + "  " + mutual);
            }
        }
    }

    public void readRules() {
        for (int i = 0; i < this.maxRule; ++i) {
            String fileName = this.dataFilename + MyString.getDigits(i + this.firstNumber, 3) + ".par";
            System.out.println(fileName);
            String fileContents = MyFileReader.file2string(fileName);
            for (int j = 0; j < this.maxRuleEntry; ++j) {
                String str = MyString.stripBack(MyString.lindex(fileContents, j + 2), ':');
                this.ruleArray[j][i] = MyString.convertIntParameter(str);
            }
        }
    }

    private void createMassArray() {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            Partition partition = PartitionRule.int2Partition(i, this.statePerCell, this.maxNeighbor);
            this.mass[i] = partition.getMass(1);
        }
    }
}

