/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.AquaP2Rule;
import cambria.AquaRule;
import cambria.CARule;
import cambria.GMBrainRule;
import cambria.GenerationRule;
import cambria.Life2Rule;
import cambria.PartitionRule;
import cambria.StarWarsRule;
import cambria.TransersRule;
import java.awt.Color;

public class ColorSet {
    private ColorSet() {
    }

    public static Color[] createColorSet(CARule rule) {
        if (rule.getStatePerCell() == 2) {
            return ColorSet.lifeColorSet();
        }
        if (rule instanceof Life2Rule) {
            return ColorSet.life2ColorSet();
        }
        if (rule.getStatePerCell() == 3) {
            return ColorSet.aquaColorSet(3);
        }
        if (rule instanceof GenerationRule || rule instanceof GMBrainRule || rule instanceof PartitionRule || rule instanceof StarWarsRule || rule instanceof TransersRule || rule instanceof AquaP2Rule) {
            return ColorSet.generationColorSet(rule.getStatePerCell());
        }
        if (rule instanceof AquaRule) {
            return ColorSet.aquaColorSet(rule.getStatePerCell());
        }
        return ColorSet.blueGraduationColorSet(rule.getStatePerCell());
    }

    public static Color[] lifeColorSet() {
        Color[] stateColor = new Color[]{Color.black, Color.yellow};
        return stateColor;
    }

    public static Color[] life2ColorSet() {
        Color[] stateColor = new Color[]{Color.red, Color.black, Color.yellow};
        return stateColor;
    }

    public static Color[] aquaColorSet(int statePerCell) {
        if (statePerCell != 3) {
            System.out.println("ColorSet: Invalid statePerCell " + statePerCell);
        }
        Color[] stateColor = new Color[]{Color.black, Color.white, Color.red};
        return stateColor;
    }

    public static Color[] generation4ColorSet(int statePerCell) {
        if (statePerCell != 4) {
            System.out.println("ColorSet: Invalid statePerCell " + statePerCell);
        }
        Color[] stateColor = new Color[]{Color.black, Color.white, Color.pink, Color.red};
        return stateColor;
    }

    public static Color[] generationColorSet(int statePerCell) {
        if (statePerCell < 2 || statePerCell > 256) {
            System.out.println("ColorSet: Invalid statePerCell " + statePerCell);
        }
        Color[] stateColor = new Color[statePerCell];
        stateColor[0] = Color.black;
        for (int i = 1; i < statePerCell; ++i) {
            stateColor[i] = new Color(1.0f, (float)(i - 1) / (float)(statePerCell - 2), (float)(i - 1) / (float)(statePerCell - 2));
        }
        return stateColor;
    }

    public static Color[] blackGraduationColorSet(int statePerCell) {
        if (statePerCell < 2 || statePerCell > 256) {
            throw new IllegalArgumentException("Invalid statePerCell");
        }
        Color[] stateColor = new Color[statePerCell];
        for (int i = 0; i < statePerCell; ++i) {
            stateColor[i] = new Color((float)(1.0 - (double)((float)i / (float)(statePerCell - 1))), (float)(1.0 - (double)((float)i / (float)(statePerCell - 1))), (float)(1.0 - (double)((float)i / (float)(statePerCell - 1))));
        }
        return stateColor;
    }

    public static Color[] blueGraduationColorSet(int statePerCell) {
        if (statePerCell < 2 || statePerCell > 256) {
            System.out.println("ColorSet: Invalid statePerCell " + statePerCell);
        }
        Color[] stateColor = new Color[statePerCell];
        for (int i = 0; i < statePerCell; ++i) {
            stateColor[i] = new Color((float)(1.0 - (double)((float)i / (float)(statePerCell - 1))), (float)(1.0 - (double)((float)i / (float)(statePerCell - 1))), 1.0f);
        }
        return stateColor;
    }
}

