/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.RuleFilter;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class CARule
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JPanel mainPanel;
    protected JPanel subPanel;
    private JButton closeButton;
    private JTextArea infoTA;

    public static String newRule() {
        JFrame frame = new JFrame();
        String file = null;
        FileDialog fdOpen = new FileDialog((Frame)frame, "Note: Select a CA rule which ends with Rule.class");
        RuleFilter ruleFilter = new RuleFilter();
        fdOpen.setFilenameFilter(ruleFilter);
        fdOpen.setVisible(true);
        file = fdOpen.getFile();
        return file;
    }

    public static CARule createRule(String RuleClass) {
        CARule rule;
        if (RuleClass == null) {
            throw new RuntimeException("RuleClass is not given. Check arguments and Cambria.init");
        }
        if (!RuleClass.endsWith("Rule")) {
            throw new IllegalArgumentException("'" + RuleClass + "' is not Rule class.");
        }
        try {
            Class<?> c = Class.forName(RuleClass);
            try {
                rule = (CARule)c.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Rule class '" + RuleClass + "' does not have the default constructor.");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Rule class '" + RuleClass + "' not found.");
        }
        return rule;
    }

    public abstract int getStatePerCell();

    public abstract int getMaxNeighbor();

    public String getDefaultThread() {
        return "CAThread";
    }

    public String getForcedThread() {
        return null;
    }

    public int output(BlockOfCells neighbor) {
        return 0;
    }

    public void setRule(String ruleString, String filename) {
    }

    void edit() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridLayout(0, 10));
            this.infoTA = new JTextArea("Sorry. No infomation available.", 10, 40);
            this.infoTA.setEditable(false);
            this.add("Center", this.infoTA);
            this.subPanel = new JPanel();
            this.closeButton = new JButton("close");
            this.closeButton.addActionListener(this);
            this.subPanel.add(this.closeButton);
            this.add("South", this.subPanel);
            this.pack();
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == this.closeButton) {
            this.setVisible(false);
        }
    }

    protected static boolean isValidRuleArray(int[] ruleArray, int maxOutput) {
        for (int i = 0; i < ruleArray.length; ++i) {
            if (ruleArray[i] >= 0 && ruleArray[i] <= maxOutput - 1) continue;
            System.out.println("ruleArray[" + i + "] is " + ruleArray[i]);
            return false;
        }
        return true;
    }
}

