/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.BlockVN;
import cambria.misc.MyMath;

public class Block16
extends BlockOfCells {
    private static final int NORTHWEST = 0;
    private static final int NORTH = 1;
    private static final int NORTHEAST = 2;
    private static final int NORTHEASTEAST = 3;
    private static final int WEST = 4;
    private static final int HOME = 5;
    private static final int EAST = 6;
    private static final int EASTEAST = 7;
    private static final int SOUTHWEST = 8;
    private static final int SOUTH = 9;
    private static final int SOUTHEAST = 10;
    private static final int SOUTHEASTEAST = 11;
    private static final int SOUTHSOUTHWEST = 12;
    private static final int SOUTHSOUTH = 13;
    private static final int SOUTHSOUTHEAST = 14;
    private static final int SOUTHSOUTHEASTEAST = 15;
    private static final int maxNeighbor = 16;
    private byte[] neighborState = new byte[16];
    private int x;
    private int y;
    private boolean torus = true;
    private int x_max;
    private int y_max;

    public Block16() {
    }

    public Block16(boolean torus, int x_max, int y_max) {
        this.torus = torus;
        if (!torus) {
            throw new RuntimeException("Closed boundary condition not available.");
        }
        this.x_max = x_max;
        this.y_max = y_max;
    }

    public Block16(int x_max, int y_max) {
        this.x_max = x_max;
        this.y_max = y_max;
    }

    public Block16(byte[][] caState, int x, int y, int x_max, int y_max) {
        this.x_max = x_max;
        this.y_max = y_max;
        this.make(caState, x, y);
    }

    public Block16(Block16 partition) {
        this.neighborState[5] = partition.getHomeState();
        this.neighborState[1] = partition.getNorthState();
        this.neighborState[6] = partition.getEastState();
        this.neighborState[9] = partition.getSouthState();
        this.neighborState[4] = partition.getWestState();
        this.neighborState[2] = partition.getNeState();
        this.neighborState[10] = partition.getEsState();
        this.neighborState[8] = partition.getSwState();
        this.neighborState[0] = partition.getWnState();
        this.neighborState[3] = partition.getNeeState();
        this.neighborState[11] = partition.getEesState();
        this.neighborState[7] = partition.getEeState();
        this.neighborState[12] = partition.getSswState();
        this.neighborState[13] = partition.getSsState();
        this.neighborState[14] = partition.getEssState();
        this.neighborState[15] = partition.getEessState();
        this.torus = partition.isTorus();
    }

    @Override
    public void make(byte[][] caState, int x, int y) {
        this.x = x;
        this.y = y;
        int east = (x + 1) % this.x_max;
        int eastEast = (x + 2) % this.x_max;
        int south = (y + 1) % this.y_max;
        int southSouth = (y + 2) % this.y_max;
        int west = (x - 1 + this.x_max) % this.x_max;
        int north = (y - 1 + this.y_max) % this.y_max;
        this.setHomeState(caState[x][y]);
        this.setEastState(caState[east][y]);
        this.setSouthState(caState[x][south]);
        this.setEsState(caState[east][south]);
        this.setNorthState(caState[x][north]);
        this.setWestState(caState[west][y]);
        this.setNeState(caState[east][north]);
        this.setSwState(caState[west][south]);
        this.setWnState(caState[west][north]);
        this.setNeeState(caState[eastEast][north]);
        this.setEeState(caState[eastEast][y]);
        this.setEesState(caState[eastEast][south]);
        this.setSswState(caState[west][southSouth]);
        this.setSsState(caState[x][southSouth]);
        this.setEssState(caState[east][southSouth]);
        this.setEessState(caState[eastEast][southSouth]);
    }

    @Override
    public void setTorus(boolean torus) {
        this.torus = torus;
        if (!torus) {
            throw new RuntimeException("Closed boundary condition not available.");
        }
    }

    @Override
    public boolean isTorus() {
        return this.torus;
    }

    @Override
    public void updateCAState(byte[][] caState, int x, int y) {
        int east = (x + 1) % this.x_max;
        int south = (y + 1) % this.y_max;
        int west = (x - 1 + this.x_max) % this.x_max;
        int north = (y - 1 + this.y_max) % this.y_max;
        int eastEast = (x + 2) % this.x_max;
        int southSouth = (y + 2) % this.y_max;
        caState[x][y] = this.neighborState[5];
        caState[east][y] = this.neighborState[6];
        caState[x][south] = this.neighborState[9];
        caState[x][north] = this.neighborState[1];
        caState[west][y] = this.neighborState[4];
        caState[east][north] = this.neighborState[2];
        caState[east][south] = this.neighborState[10];
        caState[west][south] = this.neighborState[8];
        caState[west][north] = this.neighborState[0];
        caState[eastEast][north] = this.neighborState[3];
        caState[eastEast][south] = this.neighborState[11];
        caState[eastEast][y] = this.neighborState[7];
        caState[west][southSouth] = this.neighborState[12];
        caState[x][southSouth] = this.neighborState[13];
        caState[east][southSouth] = this.neighborState[14];
        caState[eastEast][southSouth] = this.neighborState[15];
    }

    @Override
    public byte[] getNeighborState() {
        return this.neighborState;
    }

    public byte getHomeState() {
        return this.neighborState[5];
    }

    public byte getNorthState() {
        return this.neighborState[1];
    }

    public byte getEastState() {
        return this.neighborState[6];
    }

    public byte getSouthState() {
        return this.neighborState[9];
    }

    public byte getWestState() {
        return this.neighborState[4];
    }

    public byte getNeState() {
        return this.neighborState[2];
    }

    public byte getEsState() {
        return this.neighborState[10];
    }

    public byte getSwState() {
        return this.neighborState[8];
    }

    public byte getWnState() {
        return this.neighborState[0];
    }

    public byte getNeeState() {
        return this.neighborState[3];
    }

    public byte getEeState() {
        return this.neighborState[7];
    }

    public byte getEesState() {
        return this.neighborState[11];
    }

    public byte getSswState() {
        return this.neighborState[12];
    }

    public byte getSsState() {
        return this.neighborState[13];
    }

    public byte getEssState() {
        return this.neighborState[14];
    }

    public byte getEessState() {
        return this.neighborState[15];
    }

    @Override
    public void setNeighborState(byte[] neighborState) {
        if (neighborState.length != 16) {
            throw new IllegalArgumentException("Neighbor type does not match.");
        }
        for (int i = 0; i < 16; ++i) {
            this.neighborState[i] = neighborState[i];
        }
    }

    public void setHomeState(byte state) {
        this.neighborState[5] = state;
    }

    public void setNorthState(byte state) {
        this.neighborState[1] = state;
    }

    public void setEastState(byte state) {
        this.neighborState[6] = state;
    }

    public void setSouthState(byte state) {
        this.neighborState[9] = state;
    }

    public void setWestState(byte state) {
        this.neighborState[4] = state;
    }

    public void setEsState(byte state) {
        this.neighborState[10] = state;
    }

    public void setNeState(byte state) {
        this.neighborState[2] = state;
    }

    public void setSwState(byte state) {
        this.neighborState[8] = state;
    }

    public void setWnState(byte state) {
        this.neighborState[0] = state;
    }

    public void setNeeState(byte state) {
        this.neighborState[3] = state;
    }

    public void setEeState(byte state) {
        this.neighborState[7] = state;
    }

    public void setEesState(byte state) {
        this.neighborState[11] = state;
    }

    public void setSswState(byte state) {
        this.neighborState[12] = state;
    }

    public void setSsState(byte state) {
        this.neighborState[13] = state;
    }

    public void setEssState(byte state) {
        this.neighborState[14] = state;
    }

    public void setEessState(byte state) {
        this.neighborState[15] = state;
    }

    @Override
    public int getMaxNeighbor() {
        return 16;
    }

    private void clear() {
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            this.neighborState[i] = 0;
        }
    }

    public void relocateParticlesAtRandom() {
        int[] allMasses = this.getAllMasses();
        this.clear();
        for (int i = 1; i < allMasses.length; ++i) {
            this.putParticlesAtRandom(i, allMasses[i]);
        }
    }

    private void putParticlesAtRandom(int state, int mass) {
        int remain = mass;
        while (remain > 0) {
            int j = MyMath.irand(16);
            if (this.neighborState[j] != 0) continue;
            this.neighborState[j] = (byte)state;
            --remain;
        }
    }

    public int getXAxis() {
        return this.x;
    }

    public int getYAxis() {
        return this.y;
    }

    public int getOuterTotal() {
        int sum = 0;
        for (int i = 1; i < 16; ++i) {
            sum += this.neighborState[i];
        }
        return sum;
    }

    public int getMass() {
        int mass = 0;
        for (int i = 0; i < 16; ++i) {
            if (this.neighborState[i] == 0) continue;
            ++mass;
        }
        return mass;
    }

    public int getMass(int state) {
        int sum = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] != state) continue;
            ++sum;
        }
        return sum;
    }

    private int[] getAllMasses() {
        int maxState = this.getMaxState();
        int[] allMasses = new int[maxState];
        for (int i = 0; i < maxState; ++i) {
            allMasses[i] = this.getMass(i);
        }
        return allMasses;
    }

    private int getMaxState() {
        byte maxState = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] <= maxState) continue;
            maxState = this.neighborState[i];
        }
        return 16;
    }

    public boolean equals(BlockVN ref) {
        if (ref.getHomeState() != this.neighborState[5]) {
            return false;
        }
        if (ref.getEastState() != this.neighborState[6]) {
            return false;
        }
        if (ref.getSouthState() != this.neighborState[9]) {
            return false;
        }
        if (ref.getNorthState() != this.neighborState[1]) {
            return false;
        }
        return ref.getWestState() == this.neighborState[4];
    }
}

