/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.VonNeumann;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AquaRule
extends CARule
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private static final int statePerCell = 3;
    protected static final int maxNeighbor = 5;
    static final boolean[] preyBornPond = new boolean[]{true, true, true, false};
    static final boolean[] predatorBornPond = new boolean[]{true, true, true, true, false, true};
    static final boolean[] preySurvivePond = new boolean[]{true, true, false, true, false};
    static final boolean[] preyToPredatorPond = new boolean[]{false, false, false, false, true, true, false, false, false, true};
    static final boolean[] predatorSurvivePond = new boolean[]{true, false, false, false, true, true, true, true, true, true};
    static final boolean[] preySurvivePlankton = new boolean[]{true, false, false, true, false};
    static final boolean[] preyBornHoneycomb = new boolean[]{true, false, false, false};
    static final boolean[] preySurviveHoneycomb = new boolean[]{true, true, true, false, false};
    static final boolean[] predatorSurviveHoneycomb = new boolean[]{true, true, true, true, true, true, true, true, false, true};
    static final boolean[] preySurviveBirds = new boolean[]{true, true, false, false, false};
    static final boolean[] preyToPredatorBirds = new boolean[]{true, true, true, false, true, false, false, false, false, true};
    static final boolean[] preyToPredatorTanks = new boolean[]{false, false, false, false, true, true, true, false, false, true};
    static final boolean[] predatorSurviveTanks = new boolean[]{true, true, false, false, true, false, false, true, true, true};
    static final boolean[] preyBornTyphoon = new boolean[]{true, true, true, true};
    static final boolean[] predatorBornTyphoon = new boolean[]{true, false, false, true, false, false};
    static final boolean[] preySurviveTyphoon = new boolean[]{false, false, false, false, false};
    static final boolean[] preyToPredatorTyphoon = new boolean[]{true, true, false, true, true, false, false, false, true, false};
    static final boolean[] predatorSurviveTyphoon = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    static final boolean[] predatorBornWave = new boolean[]{true, true, true, false, false, true};
    static final boolean[] preySurviveWave = new boolean[]{true, true, false, false, false};
    static final boolean[] preyToPredatorWave = new boolean[]{true, true, true, false, true, false, false, false, false, true};
    static final boolean[] preyBornLake = new boolean[]{true, true, false, true};
    static final boolean[] predatorBornLake = new boolean[]{true, true, false, false, true, false};
    static final boolean[] preySurviveLake = new boolean[]{false, true, true, false, false};
    static final boolean[] preyToPredatorLake = new boolean[]{true, true, false, false, false, false, false, false, true, false};
    static final boolean[] predatorSurviveLake = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    static final boolean[] preyBornGalaxy = new boolean[]{true, true, true, true};
    static final boolean[] predatorBornGalaxy = new boolean[]{true, false, false, true, false, false};
    static final boolean[] preySurviveGalaxy = new boolean[]{false, false, false, false, false};
    static final boolean[] preyToPredatorGalaxy = new boolean[]{true, true, false, true, true, false, false, false, true, false};
    static final boolean[] predatorSurviveGalaxy = new boolean[]{true, false, false, false, true, false, false, true, false, true};
    boolean[] preyBorn = new boolean[]{true, true, true, false};
    boolean[] predatorBorn = new boolean[]{true, true, true, true, false, true};
    boolean[] preySurvive = new boolean[]{true, true, false, true, false};
    boolean[] preyToPredator = new boolean[]{false, false, false, false, true, true, false, false, false, true};
    boolean[] predatorSurvive = new boolean[]{true, false, false, false, true, true, true, true, true, true};
    Checkbox[] preyBornCB = new Checkbox[]{new Checkbox("1 prey", this.preyBorn[0]), new Checkbox("2 preys", this.preyBorn[1]), new Checkbox("3 preys", this.preyBorn[2]), new Checkbox("4 preys", this.preyBorn[3])};
    Checkbox[] predatorBornCB = new Checkbox[]{new Checkbox("1 prey, 1 predator", this.predatorBorn[0]), new Checkbox("1 prey, 2 predators", this.predatorBorn[1]), new Checkbox("1 prey, 3 predators", this.predatorBorn[2]), new Checkbox("2 preys, 1 predator", this.predatorBorn[3]), new Checkbox("2 preys, 2 predators", this.predatorBorn[4]), new Checkbox("3 preys, 1 predator", this.predatorBorn[5])};
    Checkbox[] preySurviveCB = new Checkbox[]{new Checkbox("0 prey", this.preySurvive[0]), new Checkbox("1 prey", this.preySurvive[1]), new Checkbox("2 preys", this.preySurvive[2]), new Checkbox("3 preys", this.preySurvive[3]), new Checkbox("4 preys", this.preySurvive[4])};
    Checkbox[] preyToPredatorCB = new Checkbox[]{new Checkbox("0 prey, 1 predator", this.preyToPredator[0]), new Checkbox("0 prey, 2 predators", this.preyToPredator[1]), new Checkbox("0 prey, 3 predators", this.preyToPredator[2]), new Checkbox("0 prey, 4 predators", this.preyToPredator[3]), new Checkbox("1 prey, 1 predator", this.preyToPredator[4]), new Checkbox("1 prey, 2 predators", this.preyToPredator[5]), new Checkbox("1 prey, 3 predators", this.preyToPredator[6]), new Checkbox("2 preys, 1 predator", this.preyToPredator[7]), new Checkbox("2 preys, 2 predators", this.preyToPredator[8]), new Checkbox("3 preys, 1 predator", this.preyToPredator[9])};
    Checkbox[] predatorSurviveCB = new Checkbox[]{new Checkbox("1 prey, 0 predator", this.predatorSurvive[0]), new Checkbox("1 prey, 1 predator", this.predatorSurvive[1]), new Checkbox("1 prey, 2 predators", this.predatorSurvive[2]), new Checkbox("1 prey, 3 predators", this.predatorSurvive[3]), new Checkbox("2 preys, 0 predator", this.predatorSurvive[4]), new Checkbox("2 preys, 1 predator", this.predatorSurvive[5]), new Checkbox("2 preys, 2 predators", this.predatorSurvive[6]), new Checkbox("3 preys, 0 predator", this.predatorSurvive[7]), new Checkbox("3 preys, 1 predator", this.predatorSurvive[8]), new Checkbox("4 preys, 0 predator", this.predatorSurvive[9])};
    JButton adoptButton;
    JButton closeButton;
    JPanel innerPanel1;
    JPanel[] innerPanel = new JPanel[]{new JPanel(), new JPanel(), new JPanel(), new JPanel(), new JPanel()};
    JLabel preyBornLabel;
    JLabel preySurviveLabel;
    JLabel predatorSurviveLabel;
    JLabel preyToPredatorLabel;
    JLabel predatorBornLabel;
    JLabel blankLabel;
    String cr = System.getProperty("line.separator");
    String info = "    Aquarium rule is the group of CA rules which are a sort of the prey-predator system. The state zero (black) cell means empty, the state one (white) and two (red) cells correspond to prey and  predator, respectively. The von Neumann neighborhood is applied. Each rule entry is defined by the total of each state in the neighbor sites. As the three cell states are defined, nine update patterns are possible." + this.cr + "    1) empty -> prey: At least one prey must be at neighbor sites and any predators must not be at neighbor sites. You have to determine if born or not according to the total number of neighboring prey." + this.cr + "    2) empty -> predator: At least one predator and one prey must be at neighboring sites. You have to determine what combination cause the birth of predator." + this.cr + "    3) empty -> empty: The empty cell continue to be empty if any conditions defined above 1) and 2) are not satisfied. You do not have to define this." + this.cr + "    4) prey -> prey: Any predators must not be at neighbor sites. You have to determine if survive or not according to the total number of neighboring prey." + this.cr + "    5) prey -> predetor: At least one outer-neighbor must be a predetor. You have to determine what combination cause this replacement." + this.cr + "    6) prey -> empty: If any of the conditions defined in 4) and 5) are not satisfied, the prey cell becomes empty. You do not have to define this." + this.cr + "    7) predator -> predator: At least one prey must be at neighboring sites. You have to determine if born or not according to the total number of neighboring prey." + this.cr + "    8) The predetor is never replaced by the prey. You do not have to define this." + this.cr + "    9) If any conditions defined in 7) are not satisfied, the predator cell becomes empty. You do not have to define this." + this.cr + "    To summarize, you have to define five rule entries, 1), 2), 4), 5) and 7) as shown below.";
    private static final String[] presetRule = new String[]{"pond     ", "plankton ", "honeycomb", "birds    ", "tanks    ", "typhoon  ", "wave     ", "lake     ", "galaxy   "};
    private TextArea infoTA;

    @Override
    public int output(BlockOfCells boc) {
        VonNeumann neighbor = (VonNeumann)boc;
        int predatorTotal = neighbor.getNorthState() / 2 + neighbor.getEastState() / 2 + neighbor.getSouthState() / 2 + neighbor.getWestState() / 2;
        int preyTotal = neighbor.getNorthState() + neighbor.getEastState() + neighbor.getSouthState() + neighbor.getWestState() - predatorTotal * 2;
        int zeroTotal = 4 - predatorTotal - preyTotal;
        if (neighbor.getHomeState() == 0) {
            if (preyTotal == 0) {
                return 0;
            }
            if (predatorTotal == 0) {
                if (this.preyBornMap(preyTotal)) {
                    return 1;
                }
                return 0;
            }
            if (this.predatorBornMap(preyTotal, predatorTotal)) {
                return 2;
            }
            return 0;
        }
        if (neighbor.getHomeState() == 1) {
            if (predatorTotal == 0) {
                if (this.preySurviveMap(preyTotal)) {
                    return 1;
                }
                return 0;
            }
            if (this.preyToPredatorMap(preyTotal, predatorTotal)) {
                return 2;
            }
            return 0;
        }
        if (preyTotal == 0) {
            return 0;
        }
        if (this.predatorSurviveMap(preyTotal, predatorTotal)) {
            return 2;
        }
        return 0;
    }

    boolean preyBornMap(int preyTotal) {
        return this.preyBorn[preyTotal - 1];
    }

    boolean preySurviveMap(int preyTotal) {
        return this.preySurvive[preyTotal];
    }

    boolean predatorSurviveMap(int preyTotal, int predatorTotal) {
        if (preyTotal == 1) {
            if (predatorTotal == 0) {
                return this.predatorSurvive[0];
            }
            if (predatorTotal == 1) {
                return this.predatorSurvive[1];
            }
            if (predatorTotal == 2) {
                return this.predatorSurvive[2];
            }
            return this.predatorSurvive[3];
        }
        if (preyTotal == 2) {
            if (predatorTotal == 0) {
                return this.predatorSurvive[4];
            }
            if (predatorTotal == 1) {
                return this.predatorSurvive[5];
            }
            return this.predatorSurvive[6];
        }
        if (preyTotal == 3) {
            if (predatorTotal == 0) {
                return this.predatorSurvive[7];
            }
            return this.predatorSurvive[8];
        }
        return this.predatorSurvive[9];
    }

    boolean preyToPredatorMap(int preyTotal, int predatorTotal) {
        if (preyTotal == 0) {
            if (predatorTotal == 1) {
                return this.preyToPredator[0];
            }
            if (predatorTotal == 2) {
                return this.preyToPredator[1];
            }
            if (predatorTotal == 3) {
                return this.preyToPredator[2];
            }
            return this.preyToPredator[3];
        }
        if (preyTotal == 1) {
            if (predatorTotal == 1) {
                return this.preyToPredator[4];
            }
            if (predatorTotal == 2) {
                return this.preyToPredator[5];
            }
            return this.preyToPredator[6];
        }
        if (preyTotal == 2) {
            if (predatorTotal == 1) {
                return this.preyToPredator[7];
            }
            return this.preyToPredator[8];
        }
        return this.preyToPredator[9];
    }

    boolean predatorBornMap(int preyTotal, int predatorTotal) {
        if (preyTotal == 1) {
            if (predatorTotal == 1) {
                return this.predatorBorn[0];
            }
            if (predatorTotal == 2) {
                return this.predatorBorn[1];
            }
            return this.predatorBorn[2];
        }
        if (preyTotal == 2) {
            if (predatorTotal == 1) {
                return this.predatorBorn[3];
            }
            return this.predatorBorn[4];
        }
        return this.predatorBorn[5];
    }

    @Override
    public int getStatePerCell() {
        return 3;
    }

    @Override
    public int getMaxNeighbor() {
        return 5;
    }

    @Override
    public void edit() {
        if (this.mainPanel == null) {
            int i;
            this.infoTA = new TextArea(this.info, 10, 40, 1);
            this.infoTA.setEditable(false);
            this.add("North", this.infoTA);
            for (i = 0; i < 5; ++i) {
                this.innerPanel[i].setLayout(new GridLayout(0, 1));
            }
            this.preyBornLabel = new JLabel("prey born");
            this.innerPanel[0].add(this.preyBornLabel);
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.innerPanel[0].add(this.preyBornCB[i]);
            }
            this.predatorBornLabel = new JLabel("predator born");
            this.innerPanel[1].add(this.predatorBornLabel);
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.innerPanel[1].add(this.predatorBornCB[i]);
            }
            this.preySurviveLabel = new JLabel("prey survive");
            this.innerPanel[2].add(this.preySurviveLabel);
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.innerPanel[2].add(this.preySurviveCB[i]);
            }
            this.preyToPredatorLabel = new JLabel("prey to predator");
            this.innerPanel[3].add(this.preyToPredatorLabel);
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.innerPanel[3].add(this.preyToPredatorCB[i]);
            }
            this.predatorSurviveLabel = new JLabel("predator survive");
            this.innerPanel[4].add(this.predatorSurviveLabel);
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.innerPanel[4].add(this.predatorSurviveCB[i]);
            }
            this.mainPanel = new JPanel();
            for (i = 0; i < 5; ++i) {
                this.mainPanel.add(this.innerPanel[i]);
            }
            this.add("Center", this.mainPanel);
            this.subPanel = new JPanel();
            this.adoptButton = new JButton("adopt");
            this.adoptButton.setActionCommand("adopt");
            this.adoptButton.addActionListener(this);
            this.subPanel.add(this.adoptButton);
            Choice ruleChoice = new Choice();
            for (int i2 = 0; i2 < presetRule.length; ++i2) {
                ruleChoice.addItem(presetRule[i2]);
            }
            ruleChoice.select(0);
            ruleChoice.addItemListener(this);
            this.subPanel.add(ruleChoice);
            this.closeButton = new JButton("close");
            this.closeButton.setActionCommand("close");
            this.closeButton.addActionListener(this);
            this.subPanel.add(this.closeButton);
            this.add("South", this.subPanel);
            this.pack();
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("adopt")) {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = this.preyBornCB[i].getState();
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = this.preySurviveCB[i].getState();
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = this.predatorSurviveCB[i].getState();
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = this.predatorBornCB[i].getState();
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = this.preyToPredatorCB[i].getState();
            }
        } else if (command.equals("close")) {
            this.setVisible(false);
        }
    }

    private void setCheckboxes() {
        int i;
        for (i = 0; i < this.preyBornCB.length; ++i) {
            this.preyBornCB[i].setState(this.preyBorn[i]);
        }
        for (i = 0; i < this.predatorBornCB.length; ++i) {
            this.predatorBornCB[i].setState(this.predatorBorn[i]);
        }
        for (i = 0; i < this.preySurviveCB.length; ++i) {
            this.preySurviveCB[i].setState(this.preySurvive[i]);
        }
        for (i = 0; i < this.preyToPredatorCB.length; ++i) {
            this.preyToPredatorCB[i].setState(this.preyToPredator[i]);
        }
        for (i = 0; i < this.predatorSurviveCB.length; ++i) {
            this.predatorSurviveCB[i].setState(this.predatorSurvive[i]);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String selectedRule = e.getItem().toString();
        if (selectedRule == "pond     ") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornPond[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornPond[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurvivePond[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorPond[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurvivePond[i];
            }
        } else if (selectedRule == "plankton ") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornPond[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornPond[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurvivePlankton[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorPond[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurvivePond[i];
            }
        } else if (selectedRule == "honeycomb") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornHoneycomb[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornPond[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurviveHoneycomb[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorPond[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurviveHoneycomb[i];
            }
        } else if (selectedRule == "birds    ") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornPond[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornPond[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurviveBirds[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorBirds[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurvivePond[i];
            }
        } else if (selectedRule == "tanks    ") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornPond[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornPond[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurvivePond[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorTanks[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurviveTanks[i];
            }
        } else if (selectedRule == "typhoon  ") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornTyphoon[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornTyphoon[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurviveTyphoon[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorTyphoon[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurviveTyphoon[i];
            }
        } else if (selectedRule == "wave     ") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornPond[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornWave[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurviveWave[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorWave[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurvivePond[i];
            }
        } else if (selectedRule == "lake     ") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornLake[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornLake[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurviveLake[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorLake[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurviveLake[i];
            }
        } else if (selectedRule == "galaxy   ") {
            int i;
            for (i = 0; i < this.preyBorn.length; ++i) {
                this.preyBorn[i] = preyBornGalaxy[i];
            }
            for (i = 0; i < this.predatorBorn.length; ++i) {
                this.predatorBorn[i] = predatorBornGalaxy[i];
            }
            for (i = 0; i < this.preySurvive.length; ++i) {
                this.preySurvive[i] = preySurviveGalaxy[i];
            }
            for (i = 0; i < this.preyToPredator.length; ++i) {
                this.preyToPredator[i] = preyToPredatorGalaxy[i];
            }
            for (i = 0; i < this.predatorSurvive.length; ++i) {
                this.predatorSurvive[i] = predatorSurviveGalaxy[i];
            }
        } else {
            System.out.println("AquaRule: No such preset rule.");
        }
        this.setCheckboxes();
    }
}

