/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.table;

import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.ujmp.core.util.MathUtil;
import org.ujmp.gui.table.ConstantTableColumnEnumeration;
import org.ujmp.gui.table.FastListSelectionModel64;
import org.ujmp.gui.table.ListSelectionModel64;
import org.ujmp.gui.table.TableColumn64;
import org.ujmp.gui.table.TableColumnModel64;
import org.ujmp.gui.table.TableColumnModelListener64;
import org.ujmp.gui.table.TableModel64;

public class DefaultTableColumnModel64
extends DefaultTableColumnModel
implements TableColumnModel64 {
    private static final long serialVersionUID = 6012896374236252508L;
    private final TableModel64 tableModel64;
    private int defaultColumnWidth = -1;
    private final Map<Long, Integer> columnWidths = new TreeMap<Long, Integer>();

    public DefaultTableColumnModel64(TableModel64 m) {
        this.tableModel64 = m;
    }

    @Override
    public int getColumnWidth(long column) {
        Integer width = this.columnWidths.get(column);
        if (width == null) {
            return this.getDefaultColumnWidth();
        }
        return width;
    }

    @Override
    public int getDefaultColumnWidth() {
        if (this.defaultColumnWidth == -1) {
            if (this.tableModel64.getColumnCount() < 10) {
                return 200;
            }
            return 80;
        }
        return this.defaultColumnWidth;
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this.defaultColumnWidth = width;
    }

    @Override
    public TableColumn64 getColumn(int columnIndex) {
        TableColumn64 tableColumn = new TableColumn64(this, (long)columnIndex);
        return tableColumn;
    }

    @Override
    public ListSelectionModel64 getSelectionModel() {
        if (this.selectionModel instanceof ListSelectionModel64) {
            return (ListSelectionModel64)this.selectionModel;
        }
        return null;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener x) {
        if (!(x instanceof TableColumnModelListener64)) {
            throw new IllegalArgumentException("use TableColumnModelListener64");
        }
        super.addColumnModelListener(x);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener x) {
        if (!(x instanceof TableColumnModelListener64)) {
            throw new IllegalArgumentException("use TableColumnModelListener64");
        }
        super.removeColumnModelListener(x);
    }

    @Override
    public long getColumnCount64() {
        return this.tableModel64.getColumnCount64();
    }

    @Override
    public int getColumnCount() {
        return MathUtil.longToInt(this.getColumnCount64());
    }

    @Override
    public void addColumn(TableColumn64 aColumn) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void removeColumn(TableColumn64 column) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void moveColumn(long columnIndex, long newIndex) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Enumeration<TableColumn64> getColumns64() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return new ConstantTableColumnEnumeration(this, this.tableModel64);
    }

    @Override
    public long getColumnIndex64(Object columnIdentifier) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public TableColumn64 getColumn(long columnIndex) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public long[] getSelectedColumns64() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public long getSelectedColumnCount64() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setSelectionModel(ListSelectionModel64 newModel) {
        super.setSelectionModel(newModel);
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        if (!(newModel instanceof ListSelectionModel64)) {
            throw new IllegalArgumentException("use ListSelectionModel64");
        }
        this.setSelectionModel((ListSelectionModel64)newModel);
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener64 x) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener64 x) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    protected ListSelectionModel64 createSelectionModel() {
        return new FastListSelectionModel64();
    }

    @Override
    public void removeColumn(TableColumn column) {
        if (!(column instanceof TableColumn64)) {
            throw new IllegalArgumentException("use TableColumn64");
        }
        this.removeColumn((TableColumn64)column);
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        this.moveColumn((long)columnIndex, (long)newIndex);
    }

    @Override
    public void setColumnMargin(int newMargin) {
        if (newMargin != this.columnMargin) {
            this.columnMargin = newMargin;
            this.fireColumnMarginChanged();
        }
    }

    @Override
    protected void fireColumnMarginChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == TableColumnModelListener64.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((TableColumnModelListener64)listeners[i + 1]).columnMarginChanged(this.changeEvent);
                continue;
            }
            if (listeners[i] != TableColumnModelListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((TableColumnModelListener)listeners[i + 1]).columnMarginChanged(this.changeEvent);
        }
    }

    @Override
    public int getColumnIndex(Object columnIdentifier) {
        return MathUtil.longToInt(this.getColumnIndex64(columnIdentifier));
    }

    @Override
    public int getColumnIndexAtX(int xPosition) {
        return MathUtil.longToInt(this.getColumnIndexAtX((long)xPosition));
    }

    @Override
    public long getColumnIndexAtX(long xPosition) {
        if (xPosition < 0L || xPosition > (long)this.getTotalColumnWidth()) {
            return -1L;
        }
        long lastColumn = 0L;
        long lastPosition = 0L;
        for (Long column : this.columnWidths.keySet()) {
            long distance = (column - lastColumn) * (long)this.getDefaultColumnWidth();
            long newPosition = lastPosition + distance;
            if (xPosition <= newPosition) {
                return lastColumn + (xPosition - lastPosition) / (long)this.getDefaultColumnWidth();
            }
            lastPosition = newPosition;
            distance = this.columnWidths.get(column).intValue();
            if (xPosition <= (newPosition = lastPosition + distance)) {
                return column;
            }
            lastPosition = newPosition;
            lastColumn = column + 1L;
        }
        return lastColumn + (xPosition - lastPosition) / (long)this.getDefaultColumnWidth();
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            if (this.getColumnCount64() == -1L) {
                return 0;
            }
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    @Override
    protected void recalcWidthCache() {
        long width = (this.getColumnCount64() - (long)this.columnWidths.size()) * (long)this.getDefaultColumnWidth();
        for (Long column : this.columnWidths.keySet()) {
            width += (long)this.columnWidths.get(column).intValue();
        }
        this.totalColumnWidth = MathUtil.longToInt(width);
    }

    @Override
    public void setColumnSelectionAllowed(boolean flag) {
        this.columnSelectionAllowed = flag;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }

    @Override
    public void setColumnWidth(long index, int width) {
        this.invalidateWidthCache();
        this.columnWidths.put(index, width);
        this.fireColumnMarginChanged();
    }
}

