/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.ujmp.core.util.MathUtil;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.table.JTable64;
import org.ujmp.gui.table.TableCellRenderer64;

public class ColumnTableHeaderRenderer64
extends JLabel
implements TableCellRenderer64 {
    private static final long serialVersionUID = -800986952766999425L;

    public ColumnTableHeaderRenderer64(JTable64 table) {
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.GRAY));
        this.setForeground(table.getTableHeader().getForeground());
        this.setBackground(table.getTableHeader().getBackground());
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable64 table, Object value, boolean isSelected, boolean hasFocus, long row, long column) {
        if (table.getColumnModel().getSelectionModel().isSelectedIndex(MathUtil.longToInt(column))) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        value = ((MatrixGUIObject)table.getModel()).getColumnName(column);
        if (value != null) {
            this.setText("[" + String.valueOf(value) + "] " + String.valueOf(column));
        } else {
            this.setText(String.valueOf(column));
        }
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table instanceof JTable64) {
            return this.getTableCellRendererComponent((JTable64)table, value, isSelected, hasFocus, (long)row, (long)column);
        }
        throw new RuntimeException("use JTable64 instead");
    }
}

