/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.ujmp.core.Matrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.util.concurrent.BackgroundTask;
import org.ujmp.core.util.matrices.SubnetMatrix;

public class NetworkInterfaceMatrix
extends DefaultMapMatrix<String, Matrix> {
    private static final long serialVersionUID = 2604261022691386860L;

    public NetworkInterfaceMatrix(final NetworkInterface networkInterface) throws SocketException {
        this.setLabel(networkInterface.getDisplayName());
        this.setMetaData("MTU", networkInterface.getMTU());
        this.setMetaData("IsLoopback", networkInterface.isLoopback());
        this.setMetaData("IsPointToPoint", networkInterface.isPointToPoint());
        this.setMetaData("IsUp", networkInterface.isUp());
        this.setMetaData("IsVirtual", networkInterface.isVirtual());
        new BackgroundTask(new Object[0]){

            @Override
            public Object run() {
                for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
                    try {
                        NetworkInterfaceMatrix.this.put(address.getAddress() + "/" + address.getNetworkPrefixLength(), new SubnetMatrix(address));
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }
}

