/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.ujmp.core.mapmatrix.AbstractMapMatrix;
import org.ujmp.core.util.io.HttpUtil;

public class HttpMatrix
extends AbstractMapMatrix<String, String> {
    private static final long serialVersionUID = -8091708294752801016L;
    private final String defaultProtocol;

    public HttpMatrix() {
        this("http://");
    }

    public HttpMatrix(String defaultProtocol) {
        if (defaultProtocol == null || !defaultProtocol.endsWith("/")) {
            defaultProtocol = defaultProtocol + "/";
        }
        this.defaultProtocol = defaultProtocol;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public String get(Object key) {
        try {
            String urlString = String.valueOf(key);
            if (!urlString.startsWith("https://") && !urlString.startsWith("http://")) {
                urlString = this.defaultProtocol + urlString;
            }
            String data = HttpUtil.getStringFromUrl(urlString);
            return data;
        }
        catch (Exception e) {
            if (e instanceof IOException && e.getMessage().contains("code: 403")) {
                return null;
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<String> keySet() {
        return Collections.emptySet();
    }

    @Override
    protected void clearMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String removeFromMap(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String putIntoMap(String key, String value) {
        throw new UnsupportedOperationException();
    }
}

